/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.SystemException;
import weblogic.corba.utils.RepositoryId;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.ClusterComponent;
import weblogic.iiop.CodebaseComponent;
import weblogic.iiop.ConnectionKey;
import weblogic.iiop.IIOPClientService;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.IOPProfile;
import weblogic.iiop.ObjectKey;
import weblogic.iiop.Profile;
import weblogic.iiop.ProtocolHandlerIIOP;
import weblogic.kernel.Kernel;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.Protocol;
import weblogic.protocol.ServerChannelManager;
import weblogic.rmi.internal.RuntimeDescriptor;
import weblogic.utils.AssertionError;
import weblogic.utils.collections.NumericKeyHashMap;
import weblogic.utils.io.Chunk;

public final class IOR
implements Externalizable {
    private static final long serialVersionUID = 1952182103399381650L;
    static String localHost;
    static int localPort;
    public static final IOR NULL;
    private static final DebugLogger debugIIOPDetail;
    protected boolean iorIsLocal;
    protected boolean iorIsForeign = false;
    private RepositoryId typeId;
    private String applicationName;
    private Profile[] profiles;
    private IOPProfile iopProfile;

    public IOR() {
        this.typeId = RepositoryId.EMPTY;
        this.profiles = new Profile[0];
    }

    IOR(IIOPInputStream iIOPInputStream) {
        this.read(iIOPInputStream, false);
    }

    IOR(IIOPInputStream iIOPInputStream, boolean bl) {
        this.read(iIOPInputStream, true);
    }

    public IOR(String string, String string2, int n, ObjectKey objectKey) {
        this(string, string2, n, objectKey, null);
    }

    public IOR(String string, String string2, int n, ObjectKey objectKey, byte by, byte by2) {
        this(string, string2, n, objectKey, by, by2, null, null, null);
    }

    public IOR(String string, String string2, int n, ObjectKey objectKey, byte by, byte by2, int n2) {
        this(string, string2, n, objectKey, by, by2, null, null, null);
        this.iopProfile.securePort = n2;
    }

    public IOR(String string, String string2, int n, ObjectKey objectKey, String string3) {
        this(string, string2, n, objectKey, 1, IIOPClientService.defaultGIOPMinorVersion, string3, null, null);
    }

    public IOR(String string, ObjectKey objectKey) throws SystemException {
        this(string, IOR.getLocalHost(), IOR.getLocalPort(), objectKey);
    }

    public IOR(String string, int n) {
        this(string, ServerChannelManager.findLocalServerAddress((Protocol)ProtocolHandlerIIOP.PROTOCOL_IIOP), ServerChannelManager.findLocalServerPort((Protocol)ProtocolHandlerIIOP.PROTOCOL_IIOP), new ObjectKey(string, n, LocalServerIdentity.getIdentity()), 1, IIOPClientService.defaultGIOPMinorVersion);
    }

    private IOR(String string, String string2, IOPProfile iOPProfile) {
        this.typeId = string == null ? RepositoryId.OBJECT : new RepositoryId(string);
        this.applicationName = string2;
        this.iopProfile = iOPProfile;
        this.profiles = new Profile[]{this.iopProfile};
    }

    IOR(String string, String string2, int n, ObjectKey objectKey, byte by, byte by2, String string3, ClusterComponent clusterComponent, RuntimeDescriptor runtimeDescriptor) {
        this(string, string3, new IOPProfile(string2, n, objectKey, string3, by, by2, clusterComponent, runtimeDescriptor));
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            IOR.p("building ior for typeId = " + string + ", and host = " + string2 + ", and port = " + n);
        }
    }

    public IOR(String string, String string2, int n, ObjectKey objectKey, String string3, ClusterComponent clusterComponent, RuntimeDescriptor runtimeDescriptor) {
        this(string, string2, n, objectKey, 1, IIOPClientService.defaultGIOPMinorVersion, string3, clusterComponent, runtimeDescriptor);
    }

    public IOR(String string, String string2, int n, ObjectKey objectKey, String string3, ClusterComponent clusterComponent, NumericKeyHashMap numericKeyHashMap) {
        this(string, string3, new IOPProfile(string2, n, objectKey, string3, 1, IIOPClientService.defaultGIOPMinorVersion, clusterComponent, null, numericKeyHashMap));
    }

    IOR(IOR iOR, ClusterComponent clusterComponent) {
        this.typeId = iOR.typeId;
        this.applicationName = iOR.applicationName;
        this.profiles = new Profile[1];
        this.iopProfile = new IOPProfile(iOR.iopProfile);
        this.iopProfile.setClusterComponent(clusterComponent);
        this.profiles[0] = this.iopProfile;
    }

    public final boolean isRemote() {
        return this.iorIsForeign;
    }

    public String toString() {
        return this.getClass().getName().toString() + "[" + this.typeId.toString() + "] @" + this.iopProfile.getHost() + ":" + this.iopProfile.getPort() + ", <" + this.iopProfile.getObjectKey().getObjectID() + ", " + this.iopProfile.getObjectKey().getActivationID() + ">";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        byte[] byArray = this.getEncapsulation();
        objectOutput.writeInt(byArray.length);
        objectOutput.write(byArray);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        byte[] byArray = new byte[n];
        objectInput.readFully(byArray);
        IIOPInputStream iIOPInputStream = new IIOPInputStream(byArray);
        iIOPInputStream.consumeEndian();
        this.read(iIOPInputStream, false);
        iIOPInputStream.close();
    }

    public final String stringify() {
        byte[] byArray = this.getEncapsulation();
        char[] cArray = new char[4 + byArray.length * 2];
        cArray[0] = 73;
        cArray[1] = 79;
        cArray[2] = 82;
        cArray[3] = 58;
        for (int i = 0; i < byArray.length; ++i) {
            cArray[4 + i * 2] = this.toHexChar(byArray[i] >> 4 & 0xF);
            cArray[4 + i * 2 + 1] = this.toHexChar(byArray[i] & 0xF);
        }
        return new String(cArray);
    }

    public static IOR destringify(String string) {
        Chunk chunk;
        if (string == null) {
            throw new IllegalArgumentException("Null not a valid argument");
        }
        if (!string.startsWith("IOR:") || (string.length() & 1) == 1) {
            throw new IllegalArgumentException("String not valid");
        }
        Chunk chunk2 = chunk = Chunk.getChunk();
        int n = 0;
        int n2 = 4;
        while (n2 < string.length()) {
            chunk2.buf[n] = (byte)(IOR.fromHexChar(string.charAt(n2)) << 4 & 0xF0);
            int n3 = n;
            chunk2.buf[n3] = (byte)(chunk2.buf[n3] | (byte)(IOR.fromHexChar(string.charAt(n2 + 1)) << 0 & 0xF));
            if (n == Chunk.CHUNK_SIZE) {
                chunk2.next = Chunk.getChunk();
                chunk2.end = Chunk.CHUNK_SIZE;
                chunk2 = chunk2.next;
                n = 0;
            }
            n2 += 2;
            ++n;
        }
        chunk2.end = n;
        IIOPInputStream iIOPInputStream = new IIOPInputStream(chunk, false, null);
        iIOPInputStream.consumeEndian();
        IOR iOR = new IOR(iIOPInputStream);
        iIOPInputStream.close();
        return iOR;
    }

    private final char toHexChar(int n) {
        switch (n) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return 'A';
            }
            case 11: {
                return 'B';
            }
            case 12: {
                return 'C';
            }
            case 13: {
                return 'D';
            }
            case 14: {
                return 'E';
            }
            case 15: {
                return 'F';
            }
        }
        throw new AssertionError("Unknown char: " + n);
    }

    private static int fromHexChar(char c) {
        int n = c - 48;
        if (n >= 0 && n <= 9) {
            return n;
        }
        n = c - 97 + 10;
        if (n >= 10 && n <= 15) {
            return n;
        }
        n = c - 65 + 10;
        if (n >= 10 && n <= 15) {
            return n;
        }
        throw new IllegalArgumentException("String not hex");
    }

    private final byte[] getEncapsulation() {
        IIOPOutputStream iIOPOutputStream = new IIOPOutputStream();
        iIOPOutputStream.putEndian();
        this.write(iIOPOutputStream);
        byte[] byArray = iIOPOutputStream.getBuffer();
        iIOPOutputStream.close();
        return byArray;
    }

    public final RepositoryId getTypeId() {
        return this.typeId;
    }

    public final String getCodebase() {
        CodebaseComponent codebaseComponent = (CodebaseComponent)this.getProfile().getComponent(25);
        if (codebaseComponent != null) {
            return codebaseComponent.getCodebase();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getLocalHost() {
        if (localHost != null) return localHost;
        Class<IOR> clazz = IOR.class;
        synchronized (IOR.class) {
            localHost = ServerChannelManager.findLocalServerAddress((Protocol)ProtocolHandlerIIOP.PROTOCOL_IIOP);
            // ** MonitorExit[var0] (shouldn't be in output)
            return localHost;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getLocalPort() {
        if (localPort >= 0) return localPort;
        Class<IOR> clazz = IOR.class;
        synchronized (IOR.class) {
            localPort = ServerChannelManager.findLocalServerPort((Protocol)ProtocolHandlerIIOP.PROTOCOL_IIOP);
            // ** MonitorExit[var0] (shouldn't be in output)
            return localPort;
        }
    }

    public final IOPProfile getProfile() {
        if (this.iopProfile == null) {
            throw new NO_IMPLEMENT(1330446339, CompletionStatus.COMPLETED_NO);
        }
        return this.iopProfile;
    }

    public final ConnectionKey getConnectionKey() {
        return this.getProfile().getConnectionKey();
    }

    final boolean isSecure() {
        return this.getProfile().isSecure();
    }

    final boolean isNull() {
        return !(this.typeId != null && this.typeId.length() != 0 || this.profiles != null && this.profiles.length != 0);
    }

    public final boolean isLocal() {
        if (this.iopProfile != null) {
            if (this.iopProfile.getObjectKey().isLocalKey()) {
                return true;
            }
            ClusterComponent clusterComponent = (ClusterComponent)this.iopProfile.getComponent(1111834883);
            return clusterComponent != null && clusterComponent.findLocalIOR() != null;
        }
        return false;
    }

    private void read(IIOPInputStream iIOPInputStream, boolean bl) {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            IOR.p("read()");
        }
        this.typeId = iIOPInputStream.read_repository_id();
        if ((this.typeId == null || this.typeId.equals(RepositoryId.EMPTY)) && !bl) {
            iIOPInputStream.mark(0);
            if (iIOPInputStream.read_long() != 0) {
                iIOPInputStream.reset();
            }
            return;
        }
        int n = iIOPInputStream.read_long();
        this.profiles = new Profile[n];
        block3: for (int i = 0; i < n; ++i) {
            int n2 = iIOPInputStream.read_long();
            switch (n2) {
                case 0: {
                    this.iopProfile = new IOPProfile();
                    this.iopProfile.read(iIOPInputStream);
                    this.profiles[i] = this.iopProfile;
                    continue block3;
                }
                default: {
                    this.profiles[i] = new Profile(i);
                    this.profiles[i].read(iIOPInputStream);
                }
            }
        }
        this.iorIsForeign = true;
    }

    public void write(IIOPOutputStream iIOPOutputStream) {
        iIOPOutputStream.write_repository_id(this.typeId);
        if (this.profiles == null) {
            iIOPOutputStream.write_long(0);
            return;
        }
        iIOPOutputStream.write_long(this.profiles.length);
        for (int i = 0; i < this.profiles.length; ++i) {
            this.profiles[i].write(iIOPOutputStream);
        }
    }

    public final boolean readSecurely() {
        return this.getProfile().readSecurely();
    }

    public final byte[] getGSSUPTarget() {
        return this.getProfile().getGSSUPTarget();
    }

    public final boolean isGSSUPTargetStateful() {
        return this.getProfile().isGSSUPTargetStateful();
    }

    public final byte getMaxStreamFormatVersion() {
        return this.getProfile().getMaxStreamFormatVersion();
    }

    public final int hashCode() {
        if (this.iopProfile == null) {
            return this.typeId.hashCode();
        }
        return this.typeId.hashCode() ^ this.iopProfile.hashCode();
    }

    public final boolean equals(Object object) {
        if (object instanceof IOR) {
            IOR iOR = (IOR)object;
            return this.typeId.equals(iOR.typeId) && (this.iopProfile == iOR.iopProfile || (this.iopProfile == null || this.iopProfile.equals(iOR.iopProfile)) && this.iopProfile != null);
        }
        return false;
    }

    static void p(String string) {
        System.err.println("<IOR> " + string);
    }

    static {
        localPort = -1;
        NULL = new IOR();
        debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");
    }
}

