/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.naming.NamingException;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.NamingContextHelper;
import weblogic.corba.j2ee.naming.NameParser;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.EndPoint;
import weblogic.iiop.EndPointManager;
import weblogic.iiop.IIOPClient;
import weblogic.iiop.IIOPClientService;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IIOPReplacer;
import weblogic.iiop.IOPProfile;
import weblogic.iiop.IOR;
import weblogic.iiop.IORFactory;
import weblogic.iiop.InitialReferences;
import weblogic.iiop.LocateReplyMessage;
import weblogic.iiop.LocateRequestMessage;
import weblogic.iiop.Message;
import weblogic.iiop.ObjectKey;
import weblogic.iiop.RequestMessage;
import weblogic.iiop.SequencedRequestMessage;
import weblogic.iiop.Utils;
import weblogic.kernel.Kernel;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.concurrent.locks.Mutex;

public final class IORManager {
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");
    private static boolean isClient = true;
    private static final String TRUE_PROP = "true";
    private static final String FALSE_PROP = "false";
    private static final DebugCategory debugTransport = Debug.getCategory((String)"weblogic.iiop.transport");
    private static final DebugLogger debugIIOPTransport = DebugLogger.getDebugLogger((String)"DebugIIOPTransport");
    private static final Mutex bootstrapLock = new Mutex();

    public static IOR createIOR(String string, String string2, int n, String string3, int n2, int n3) {
        try {
            IORFactory iORFactory = (IORFactory)Class.forName("weblogic.factories." + string + "." + "IORFactoryImpl").newInstance();
            return iORFactory.createIOR(string2, n, string3, n2, n3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error(classNotFoundException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new Error(instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error(illegalAccessException.toString());
        }
    }

    public static void initialize() {
        isClient = false;
    }

    public static boolean isClient() {
        return isClient;
    }

    public static Object createInitialReference(String string, long l) throws NamingException {
        try {
            Serializable serializable;
            String string2;
            NameParser.URLInfo uRLInfo = NameParser.parseURL(string);
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                IORManager.p("createInitialReference: " + uRLInfo.getHost() + ":" + Integer.toString(uRLInfo.getPort()));
            }
            try {
                string2 = System.getProperty("weblogic.system.iiop.enableClient");
            }
            catch (SecurityException securityException) {
                string2 = FALSE_PROP;
            }
            if (!IIOPClient.isEnabled() && TRUE_PROP.equals(string2)) {
                IIOPClient.initialize();
            }
            if (!isClient) {
                try {
                    serializable = Class.forName("weblogic.rjvm.ServerURL");
                    Constructor<?> constructor = ((Class)serializable).getConstructor(String.class, String.class, Integer.TYPE, String.class);
                    java.lang.Object obj = constructor.newInstance(uRLInfo.getProtocol(), uRLInfo.getHost(), new Integer(uRLInfo.getPort()), uRLInfo.name);
                    Method method = ((Class)serializable).getDeclaredMethod("isHostedByLocalRJVM", null);
                    if (((Boolean)method.invoke(obj, (java.lang.Object[])null)).booleanValue()) {
                        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                            IORManager.p(uRLInfo.getURL() + " is local");
                        }
                        return InitialReferences.getInitialReferenceObject(uRLInfo.getService());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            serializable = IORManager.createIOR(uRLInfo.getProtocol(), uRLInfo.getHost(), uRLInfo.getPort(), uRLInfo.serviceName, uRLInfo.getMajorVersion(), uRLInfo.getMinorVersion());
            if (uRLInfo.serviceName.equals("NameService")) {
                serializable = IORManager.locateNameService(serializable, l);
            }
            return (Object)IIOPReplacer.resolveObject(serializable);
        }
        catch (SystemException systemException) {
            throw weblogic.corba.j2ee.naming.Utils.wrapNamingException((Exception)((java.lang.Object)systemException), systemException.getMessage());
        }
        catch (IOException iOException) {
            throw weblogic.corba.j2ee.naming.Utils.wrapNamingException(iOException, iOException.getMessage());
        }
    }

    public static IOR locateNameService(IOR iOR, long l) {
        Message message = null;
        Message message2 = null;
        boolean bl = IIOPClientService.reconnectOnBootstrap && iOR.getProfile().getObjectKey().isNamingKey();
        try {
            EndPoint endPoint;
            if (bl) {
                bootstrapLock.lock();
                endPoint = EndPointManager.findOrCreateEndPoint(iOR, null, true);
            } else {
                endPoint = EndPointManager.findOrCreateEndPoint(iOR);
            }
            if (endPoint.supportsForwarding()) {
                IOR iOR2;
                IOPProfile iOPProfile = iOR.getProfile();
                if (iOPProfile.getMinorVersion() == 0) {
                    IOR iOR3 = new IOR(NamingContextHelper.id(), iOPProfile.getHost(), iOPProfile.getPort(), ObjectKey.BOOTSTRAP_KEY, iOPProfile.getMajorVersion(), iOPProfile.getMinorVersion());
                    message = new RequestMessage(endPoint, iOR3, "get", false);
                    ((SequencedRequestMessage)message).setTimeout(l);
                    message.flush();
                    message.getOutputStream().write_string("NameService");
                    message2 = endPoint.sendReceive((SequencedRequestMessage)message);
                    IOR iOR4 = new IOR(message2.getInputStream(), true);
                    return iOR4;
                }
                message = new LocateRequestMessage(endPoint, iOR);
                ((SequencedRequestMessage)message).setTimeout(l);
                if (debugTransport.isEnabled() || debugIIOPTransport.isDebugEnabled()) {
                    IIOPLogger.logDebugTransport((String)("LOCATE_REQUEST(" + message.getRequestID() + ")"));
                }
                if ((iOR2 = ((LocateReplyMessage)(message2 = endPoint.sendReceive((SequencedRequestMessage)message))).needsForwarding()) != null) {
                    IOR iOR5 = iOR2;
                    return iOR5;
                }
            }
        }
        catch (IOException iOException) {
            throw Utils.mapToCORBAException(iOException);
        }
        finally {
            if (bl) {
                bootstrapLock.unlock();
            }
            if (message != null) {
                message.getOutputStream().close();
            }
            if (message2 != null) {
                message2.getInputStream().close();
            }
        }
        return iOR;
    }

    public static IOR locateInitialReference(IOR iOR, String string, long l) {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            IORManager.p("locateInitialReference(" + iOR + ", " + string + ")");
        }
        Message message = null;
        Message message2 = null;
        try {
            EndPoint endPoint = EndPointManager.findOrCreateEndPoint(iOR, string);
            if (endPoint.supportsForwarding()) {
                IOR iOR2;
                message = new LocateRequestMessage(endPoint, iOR);
                ((SequencedRequestMessage)message).setTimeout(l);
                if (debugTransport.isEnabled() || debugIIOPTransport.isDebugEnabled()) {
                    IIOPLogger.logDebugTransport((String)("LOCATE_REQUEST(" + message.getRequestID() + ")"));
                }
                if ((iOR2 = ((LocateReplyMessage)(message2 = endPoint.sendReceive((SequencedRequestMessage)message))).needsForwarding()) != null) {
                    IOR iOR3 = iOR2;
                    return iOR3;
                }
            }
        }
        catch (IOException iOException) {
            throw Utils.mapToCORBAException(iOException);
        }
        finally {
            if (message != null) {
                message.getOutputStream().close();
            }
            if (message2 != null) {
                message2.getInputStream().close();
            }
        }
        return iOR;
    }

    static void p(String string) {
        System.err.println("<IORManager> " + string);
    }
}

