/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.IOException;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.InputStream;
import org.omg.PortableServer.POA;
import weblogic.corba.cos.transactions.PropagationContextImpl;
import weblogic.corba.idl.ObjectImpl;
import weblogic.corba.j2ee.workarea.WorkAreaContext;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.EndPoint;
import weblogic.iiop.IDLMsgInput;
import weblogic.iiop.InboundRequest;
import weblogic.iiop.OutboundResponseImpl;
import weblogic.iiop.ProtocolHandlerIIOP;
import weblogic.iiop.ProtocolHandlerIIOPS;
import weblogic.iiop.ReplyMessage;
import weblogic.iiop.RequestMessage;
import weblogic.iiop.ServiceContext;
import weblogic.iiop.VendorInfoCluster;
import weblogic.iiop.VendorInfoTrace;
import weblogic.kernel.Kernel;
import weblogic.protocol.Protocol;
import weblogic.protocol.ServerChannel;
import weblogic.rmi.extensions.server.ActivatableServerReference;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.MethodDescriptor;
import weblogic.rmi.internal.OIDManager;
import weblogic.rmi.internal.RuntimeDescriptor;
import weblogic.rmi.internal.ServerReference;
import weblogic.rmi.spi.MsgInput;
import weblogic.rmi.spi.OutboundResponse;
import weblogic.security.service.ContextHandler;
import weblogic.security.subject.AbstractSubject;
import weblogic.utils.Debug;
import weblogic.workarea.WorkContextHelper;
import weblogic.workarea.spi.WorkContextMapInterceptor;

final class InboundRequestImpl
implements InboundRequest {
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");
    private static final String INTERFACE = "_interface";
    private static final String GET_INTERFACE = "_get_interface_def";
    private static final OIDManager oidManager = OIDManager.getInstance();
    private final EndPoint endPoint;
    private final RequestMessage request;
    private MsgInput msgInput;
    private int oid = -1;
    private RuntimeMethodDescriptor md;
    private Method method;
    private ServerReference serverReference;
    private static final Object NULL = new Object();
    private Object cachedTx = NULL;
    private boolean pending = false;
    private boolean rmiType = true;
    private static final MethodDescriptor NULL_METHOD = new MethodDescriptor();

    static void p(String string) {
        System.err.println("<InboundRequestImpl> " + string);
    }

    public InboundRequestImpl(EndPoint endPoint, RequestMessage requestMessage) throws RemoteException {
        this(endPoint, requestMessage, -1);
    }

    public InboundRequestImpl(EndPoint endPoint, RequestMessage requestMessage, int n) throws RemoteException {
        this.oid = n;
        this.endPoint = endPoint;
        this.request = requestMessage;
        String string = requestMessage.getOperationName();
        if (string.charAt(0) == '_' && string.equals(INTERFACE)) {
            string = GET_INTERFACE;
        }
        try {
            boolean bl;
            block17: {
                int n2;
                Class[] classArray;
                block18: {
                    RuntimeDescriptor runtimeDescriptor = this.getServerReference().getDescriptor();
                    this.md = runtimeDescriptor.getMethodDescriptor(string);
                    bl = false;
                    classArray = runtimeDescriptor.getRemoteInterfaces();
                    for (n2 = 0; n2 < classArray.length; ++n2) {
                        if (!IDLEntity.class.isAssignableFrom(classArray[n2])) continue;
                        bl = true;
                        break;
                    }
                    if (this.md != null) break block17;
                    if (bl) break block18;
                    Object object = this.getServerReference().getImplementation();
                    ClassLoader classLoader = null;
                    ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
                    try {
                        if (object == null) {
                            classLoader = this.getServerReference().getApplicationClassLoader();
                            Thread.currentThread().setContextClassLoader(classLoader);
                            object = ((ActivatableServerReference)this.getServerReference()).getImplementation(this.getActivationID());
                        }
                    }
                    catch (IOException iOException) {
                        throw new NoSuchObjectException("Failed to unmarshal activation id");
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(classLoader2);
                    }
                    Debug.assertion((object != null ? 1 : 0) != 0);
                    ObjectImpl objectImpl = new ObjectImpl((Remote)object);
                    oidManager.getReplacement((Object)objectImpl);
                    this.serverReference = oidManager.getServerReference((Object)objectImpl);
                    if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                        InboundRequestImpl.p("Object server ref is : " + this.serverReference);
                    }
                    this.oid = this.serverReference.getObjectID();
                    if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                        InboundRequestImpl.p("Object id is : " + this.oid);
                    }
                    bl = true;
                    this.md = this.serverReference.getDescriptor().getMethodDescriptor(string);
                    if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                        InboundRequestImpl.p("Object md is : " + this.md);
                    }
                    object = this.serverReference.getImplementation();
                    if (!Kernel.DEBUG || !debugIIOPDetail.isDebugEnabled()) break block17;
                    InboundRequestImpl.p("Object impl is : " + object);
                    break block17;
                }
                for (n2 = 0; n2 < classArray.length; ++n2) {
                    if (!POA.class.isAssignableFrom(classArray[n2])) continue;
                    this.md = NULL_METHOD;
                    break;
                }
            }
            this.method = this.getServerReference().getDescriptor().getMethod(string);
            if (this.md == null || bl) {
                this.rmiType = false;
                this.msgInput = new IDLMsgInput(requestMessage.getInputStream());
            } else {
                this.msgInput = requestMessage.getInputStream();
            }
        }
        catch (NoSuchObjectException noSuchObjectException) {
            this.msgInput = requestMessage.getInputStream();
            this.oid = n;
        }
    }

    final ServerReference getServerReference() throws RemoteException {
        if (this.serverReference == null) {
            this.serverReference = oidManager.getServerReference(this.getObjectID());
        }
        return this.serverReference;
    }

    final void registerAsPending() {
        if (!this.isOneWay()) {
            this.pending = true;
            this.endPoint.incrementPendingRequests();
        }
    }

    public final InputStream getInputStream() {
        this.request.flush();
        return this.request.getInputStream();
    }

    public final String getMethod() {
        return this.request.getOperationName();
    }

    public MsgInput getMsgInput() {
        return this.msgInput;
    }

    public boolean isCollocated() {
        return false;
    }

    public weblogic.rmi.spi.EndPoint getEndPoint() {
        return this.endPoint;
    }

    public ServerChannel getServerChannel() {
        return this.endPoint.getServerChannel();
    }

    public Protocol getProtocol() {
        if (this.endPoint.isSecure()) {
            return ProtocolHandlerIIOPS.PROTOCOL_IIOPS;
        }
        return ProtocolHandlerIIOP.PROTOCOL_IIOP;
    }

    public AbstractSubject getSubject() {
        return this.request.getSubject();
    }

    public int getObjectID() {
        if (this.oid != -1) {
            return this.oid;
        }
        this.oid = this.request.getObjectKey().getObjectID();
        return this.oid;
    }

    public RuntimeMethodDescriptor getRuntimeMethodDescriptor(RuntimeDescriptor runtimeDescriptor) {
        return this.md;
    }

    public Object getTxContext() {
        if (this.cachedTx == NULL) {
            this.cachedTx = this.md != null && !this.md.isTransactional() ? null : this.endPoint.getInboundRequestTxContext(this.request);
        }
        return this.cachedTx;
    }

    public void retrieveThreadLocalContext() throws IOException {
        WorkAreaContext workAreaContext = (WorkAreaContext)this.endPoint.getMessageServiceContext(this.request, 1111834891);
        if (workAreaContext != null) {
            WorkContextMapInterceptor workContextMapInterceptor = WorkContextHelper.getWorkContextHelper().getInterceptor();
            workContextMapInterceptor.receiveRequest(workAreaContext.getInputStream());
        }
    }

    public Object getReplicaInfo() throws IOException {
        VendorInfoCluster vendorInfoCluster = (VendorInfoCluster)this.endPoint.getMessageServiceContext(this.request, 1111834883);
        if (vendorInfoCluster != null) {
            return vendorInfoCluster.version();
        }
        return null;
    }

    public Object getActivationID() throws IOException {
        return this.request.getObjectKey().getActivationID();
    }

    public OutboundResponse getOutboundResponse() {
        if (this.isOneWay()) {
            return null;
        }
        ReplyMessage replyMessage = new ReplyMessage(this.endPoint, this.request, this.request.getOutboundServiceContexts(), 0);
        ServiceContext serviceContext = null;
        if (this.md != null && !this.md.isTransactional() && (serviceContext = this.request.getServiceContext(0)) != null) {
            replyMessage.addServiceContext(((PropagationContextImpl)serviceContext).getNullContext());
        }
        return new OutboundResponseImpl(this.endPoint, replyMessage, this.method, this.rmiType, this.pending);
    }

    public void close() throws IOException {
        this.msgInput.close();
    }

    final boolean isOneWay() {
        return this.request.isOneWay();
    }

    public Object getContext(int n) throws IOException {
        switch (n) {
            case 4: {
                ServiceContext serviceContext = null;
                serviceContext = this.request.getServiceContext(1111834890);
                if (serviceContext == null) break;
                return ((VendorInfoTrace)serviceContext).getTrace();
            }
        }
        return null;
    }

    public X509Certificate[] getCertificateChain() {
        return null;
    }

    public ContextHandler getContextHandler() {
        return null;
    }
}

