/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import org.omg.CORBA.OBJECT_NOT_EXIST;
import weblogic.iiop.EndPoint;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.IOR;
import weblogic.iiop.LocateRequestMessage;
import weblogic.iiop.Message;
import weblogic.iiop.MessageHeader;
import weblogic.iiop.MessageTypeConstants;
import weblogic.iiop.SystemExceptionReplyBody;

public final class LocateReplyMessage
extends Message
implements MessageTypeConstants {
    private int locate_status;
    private IOR ior;

    public LocateReplyMessage(EndPoint endPoint, MessageHeader messageHeader, IIOPInputStream iIOPInputStream) {
        this.endPoint = endPoint;
        this.msgHdr = messageHeader;
        this.inputStream = iIOPInputStream;
        this.read(iIOPInputStream);
    }

    public LocateReplyMessage(LocateRequestMessage locateRequestMessage, int n) {
        this.msgHdr = new MessageHeader(4, locateRequestMessage.getMinorVersion());
        this.endPoint = locateRequestMessage.getEndPoint();
        this.request_id = locateRequestMessage.getRequestID();
        this.locate_status = n;
    }

    public LocateReplyMessage(LocateRequestMessage locateRequestMessage, IOR iOR, int n) {
        this.msgHdr = new MessageHeader(4, locateRequestMessage.getMinorVersion());
        this.endPoint = locateRequestMessage.getEndPoint();
        this.request_id = locateRequestMessage.getRequestID();
        this.locate_status = n;
        this.ior = iOR;
    }

    public LocateReplyMessage(LocateRequestMessage locateRequestMessage, int n, Throwable throwable) {
        this.msgHdr = new MessageHeader(4, locateRequestMessage.getMinorVersion());
        this.endPoint = locateRequestMessage.getEndPoint();
        this.request_id = locateRequestMessage.getRequestID();
        this.locate_status = n;
    }

    public IOR needsForwarding() {
        if (this.locate_status == 2 || this.locate_status == 3) {
            return this.ior;
        }
        if (this.locate_status == 0) {
            throw new OBJECT_NOT_EXIST("Unknown object in LOCATE_REQUEST");
        }
        return null;
    }

    public IOR getIOR() {
        return this.ior;
    }

    public void read(IIOPInputStream iIOPInputStream) {
        this.request_id = iIOPInputStream.read_long();
        this.locate_status = iIOPInputStream.read_long();
        switch (this.locate_status) {
            case 2: 
            case 3: {
                this.ior = new IOR(iIOPInputStream, true);
                break;
            }
            case 4: {
                SystemExceptionReplyBody systemExceptionReplyBody = new SystemExceptionReplyBody();
                systemExceptionReplyBody.read(iIOPInputStream);
                break;
            }
            case 5: {
                short s = iIOPInputStream.read_short();
                break;
            }
        }
    }

    public void write(IIOPOutputStream iIOPOutputStream) {
        this.msgHdr.write(iIOPOutputStream);
        iIOPOutputStream.write_long(this.request_id);
        iIOPOutputStream.write_long(this.locate_status);
        if (this.locate_status == 2 && this.ior != null) {
            this.ior.write(iIOPOutputStream);
        }
    }
}

