/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import weblogic.iiop.EndPoint;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.IOR;
import weblogic.iiop.MessageHeader;
import weblogic.iiop.MessageTypeConstants;
import weblogic.iiop.ObjectKey;
import weblogic.iiop.SequencedRequestMessage;
import weblogic.iiop.TargetAddress;

public final class LocateRequestMessage
extends SequencedRequestMessage
implements MessageTypeConstants {
    private ObjectKey object_key = null;
    private TargetAddress target;

    public LocateRequestMessage(EndPoint endPoint, IOR iOR) {
        this.msgHdr = new MessageHeader(3, endPoint.getMinorVersion());
        this.endPoint = endPoint;
        this.request_id = endPoint.getNextRequestID();
        this.object_key = iOR.getProfile().getObjectKey();
        this.target = new TargetAddress(this.object_key);
        this.write(this.getOutputStream());
    }

    public LocateRequestMessage(EndPoint endPoint, MessageHeader messageHeader, IIOPInputStream iIOPInputStream) {
        this.msgHdr = messageHeader;
        this.endPoint = endPoint;
        this.inputStream = iIOPInputStream;
        this.read(iIOPInputStream);
    }

    public ObjectKey getObjectKey() {
        return this.object_key;
    }

    public void read(IIOPInputStream iIOPInputStream) {
        switch (this.getMinorVersion()) {
            case 0: 
            case 1: {
                this.request_id = iIOPInputStream.read_long();
                this.object_key = new ObjectKey(iIOPInputStream);
                break;
            }
            case 2: {
                this.request_id = iIOPInputStream.read_long();
                this.target = new TargetAddress(iIOPInputStream);
                this.object_key = this.target.object_key;
            }
        }
    }

    public void write(IIOPOutputStream iIOPOutputStream) {
        this.msgHdr.write(iIOPOutputStream);
        switch (this.getMinorVersion()) {
            case 0: 
            case 1: {
                iIOPOutputStream.write_long(this.request_id);
                this.object_key.write(iIOPOutputStream);
                break;
            }
            case 2: {
                iIOPOutputStream.write_long(this.request_id);
                this.target.write(iIOPOutputStream);
            }
        }
    }
}

