/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.SystemException;
import weblogic.common.internal.PeerInfo;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.BiDirIIOPContextImpl;
import weblogic.iiop.CodeSet;
import weblogic.iiop.ConnectionKey;
import weblogic.iiop.EndPoint;
import weblogic.iiop.EndPointManager;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.MessageHeader;
import weblogic.iiop.RoutingContext;
import weblogic.iiop.SFVContext;
import weblogic.iiop.SendingContextRunTime;
import weblogic.iiop.ServiceContext;
import weblogic.iiop.ServiceContextList;
import weblogic.iiop.VendorInfo;
import weblogic.kernel.Kernel;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.SyncKeyTable;

public abstract class Message
implements weblogic.iiop.spi.Message {
    protected MessageHeader msgHdr;
    protected int request_id;
    protected ServiceContextList serviceContexts;
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");
    private static final DebugCategory debugTransport = Debug.getCategory((String)"weblogic.iiop.transport");
    private static final DebugLogger debugIIOPTransport = DebugLogger.getDebugLogger((String)"DebugIIOPTransport");
    protected EndPoint endPoint;
    protected IIOPInputStream inputStream;
    protected IIOPOutputStream outputStream;
    private boolean marshaled = false;
    private byte maxFormatVersion = 1;

    public Message() {
        this.serviceContexts = new ServiceContextList();
    }

    public Message(ServiceContextList serviceContextList) {
        this.serviceContexts = serviceContextList;
    }

    public void close() {
        this.endPoint = null;
        this.outputStream = null;
        this.inputStream = null;
        this.msgHdr.close();
        this.msgHdr = null;
        this.serviceContexts.reset();
    }

    public final EndPoint getEndPoint() {
        return this.endPoint;
    }

    public final MessageHeader getMessageHeader() {
        return this.msgHdr;
    }

    public final int getRequestID() {
        return this.request_id;
    }

    public final int hashCode() {
        return this.request_id;
    }

    public final boolean equals(Object object) {
        if (object instanceof Message) {
            return object.hashCode() == this.hashCode();
        }
        return false;
    }

    public final int getMsgType() {
        return this.msgHdr.getMsgType();
    }

    public final int getMsgSize() {
        return this.msgHdr.getMsgSize();
    }

    public final boolean isLittleEndian() {
        return this.msgHdr.isLittleEndian();
    }

    public final boolean isFragmented() {
        return this.msgHdr.isFragmented();
    }

    public final int getMinorVersion() {
        int n = this.msgHdr.getMinorVersion();
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return n;
            }
        }
        throw new MARSHAL("Unsupported GIOP minor version.");
    }

    public final byte getMaxStreamFormatVersion() {
        return this.maxFormatVersion;
    }

    protected final void setMaxStreamFormatVersion(byte by) {
        this.maxFormatVersion = by;
    }

    public final void alignOnEightByteBoundry(IIOPInputStream iIOPInputStream) {
        switch (this.getMinorVersion()) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                iIOPInputStream.setNeedEightByteAlignment();
            }
        }
    }

    public final void alignOnEightByteBoundry(IIOPOutputStream iIOPOutputStream) {
        switch (this.getMinorVersion()) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                if (iIOPOutputStream.getPeerInfo().compareTo((Object)PeerInfo.VERSION_701) <= 0 && iIOPOutputStream.getPeerInfo() != PeerInfo.FOREIGN) {
                    iIOPOutputStream.align8();
                    break;
                }
                iIOPOutputStream.setNeedEightByteAlignment();
            }
        }
    }

    public final IIOPOutputStream getOutputStream() {
        if (this.outputStream == null) {
            this.outputStream = new IIOPOutputStream(this.isLittleEndian(), this.endPoint, this);
        }
        return this.outputStream;
    }

    public abstract void write(IIOPOutputStream var1) throws SystemException;

    public void read(IIOPInputStream iIOPInputStream) throws SystemException {
    }

    public void flush() {
        if (!this.marshaled) {
            if (this.inputStream != null) {
                this.read(this.getInputStream());
            } else {
                this.write(this.getOutputStream());
            }
            this.marshaled = true;
        }
    }

    public final IIOPInputStream getInputStream() {
        Debug.assertion((this.inputStream != null ? 1 : 0) != 0);
        return this.inputStream;
    }

    public final ServiceContext getServiceContext(int n) {
        return this.serviceContexts.getServiceContext(n);
    }

    public ServiceContextList getServiceContexts() {
        return this.serviceContexts;
    }

    public final void removeServiceContext(int n) {
        this.serviceContexts.removeServiceContext(n);
    }

    protected final void addServiceContext(ServiceContext serviceContext) {
        this.serviceContexts.addServiceContext(serviceContext);
    }

    protected void writeServiceContexts(IIOPOutputStream iIOPOutputStream) {
        this.serviceContexts.write(iIOPOutputStream);
    }

    protected void readServiceContexts(IIOPInputStream iIOPInputStream) {
        ServiceContext serviceContext;
        SFVContext sFVContext;
        SendingContextRunTime sendingContextRunTime;
        this.serviceContexts.read(iIOPInputStream);
        CodeSet codeSet = (CodeSet)this.serviceContexts.getServiceContext(1);
        if (codeSet != null) {
            int n = codeSet.getCharCodeSet();
            int n2 = codeSet.getWcharCodeSet();
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled() || debugTransport.isEnabled() || debugIIOPTransport.isDebugEnabled()) {
                IIOPLogger.logDebugTransport((String)("client selected char codeset = " + Integer.toHexString(n) + ", wchar codeset = " + Integer.toHexString(n2)));
            }
            iIOPInputStream.setCodeSets(n, n2);
            if (this.endPoint != null && !this.endPoint.getFlag(16)) {
                this.endPoint.setCodeSets(n, n2);
                this.endPoint.setFlag(32);
            }
        }
        if ((sendingContextRunTime = (SendingContextRunTime)this.serviceContexts.getServiceContext(6)) != null) {
            this.endPoint.setRemoteCodeBase(sendingContextRunTime.getCodeBase());
        }
        if ((sFVContext = (SFVContext)this.serviceContexts.getServiceContext(17)) != null) {
            this.setMaxStreamFormatVersion(sFVContext.getMaxFormatVersion());
        }
        if (this.endPoint != null && this.endPoint.supportsForwarding()) {
            RoutingContext routingContext;
            serviceContext = (BiDirIIOPContextImpl)this.serviceContexts.getServiceContext(5);
            if (serviceContext != null) {
                this.endPoint.setFlag(64);
                routingContext = (SyncKeyTable)this.endPoint.getConnection().getProperty("weblogic.iiop.BiDirKeys");
                if (routingContext == null) {
                    routingContext = new SyncKeyTable();
                    this.endPoint.getConnection().setProperty("weblogic.iiop.BiDirKeys", routingContext);
                }
                ConnectionKey[] connectionKeyArray = ((BiDirIIOPContextImpl)serviceContext).getListenPoints();
                for (int i = 0; i < connectionKeyArray.length; ++i) {
                    routingContext.put(connectionKeyArray[i]);
                }
                if (connectionKeyArray.length > 0) {
                    EndPointManager.updateConnection(this.endPoint.getConnection(), connectionKeyArray[0]);
                }
            }
            if ((routingContext = (RoutingContext)this.serviceContexts.getServiceContext(1111834888)) != null) {
                EndPointManager.updateRoutingTable(routingContext.getIdentity(), routingContext.getConnectionKey());
            }
        }
        if (this.endPoint != null && this.endPoint.getPeerInfo() == null && (serviceContext = (VendorInfo)this.serviceContexts.getServiceContext(1111834880)) != null) {
            this.endPoint.setPeerInfo(((VendorInfo)serviceContext).getPeerInfo());
        }
    }

    protected static void p(String string) {
        System.err.println("<Message> " + string);
    }
}

