/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.ConnectionKey;
import weblogic.iiop.EndPoint;
import weblogic.iiop.EndPointManager;
import weblogic.iiop.ForwardingContext;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.Message;
import weblogic.iiop.ReplyMessage;
import weblogic.iiop.ServiceContext;
import weblogic.kernel.Kernel;
import weblogic.protocol.Identity;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;

public final class MessageForwardingHandler
extends WorkAdapter {
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");
    private final EndPoint endpoint;
    private final ConnectionKey finalDest;
    private final Message m;
    private Identity identity = null;

    static void p(String string) {
        System.err.println("<MessageForwardingHandler at " + System.currentTimeMillis() + "> " + string);
    }

    public MessageForwardingHandler(EndPoint endPoint, Message message, Identity identity, ConnectionKey connectionKey) {
        this.endpoint = endPoint;
        this.m = message;
        this.identity = identity;
        this.finalDest = connectionKey;
        WorkManagerFactory.getInstance().getSystem().schedule((Runnable)((Object)this));
    }

    public void run() {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            MessageForwardingHandler.p(" sending...");
        }
        try {
            Object object;
            if (this.finalDest != null) {
                object = new ForwardingContext(this.finalDest);
                if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                    MessageForwardingHandler.p("adding forwarding context" + object);
                }
                this.m.addServiceContext((ServiceContext)object);
            } else {
                this.m.removeServiceContext(1111834889);
            }
            object = new IIOPOutputStream(this.m.isLittleEndian(), this.endpoint);
            ((IIOPOutputStream)object).setCodeSets(this.endpoint.getCharCodeSet(), this.endpoint.getWcharCodeSet());
            ((IIOPOutputStream)object).setMinorVersion(this.m.getMinorVersion());
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                MessageForwardingHandler.p("re-write message");
            }
            this.m.getMessageHeader().setFragmented(false);
            this.m.write((IIOPOutputStream)object);
            if (this.m instanceof ReplyMessage) {
                if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                    MessageForwardingHandler.p("flushing pending data");
                }
                IIOPInputStream iIOPInputStream = this.m.getInputStream();
                while (!iIOPInputStream.eof()) {
                    ((IIOPOutputStream)object).write_octet(iIOPInputStream.read_octet());
                }
            }
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                MessageForwardingHandler.p(" queue send...");
            }
            this.endpoint.send((IIOPOutputStream)object);
            ((IIOPOutputStream)object).close();
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                MessageForwardingHandler.p("... queuing completes");
            }
        }
        catch (Throwable throwable) {
            OBJECT_NOT_EXIST oBJECT_NOT_EXIST;
            if (this.identity != null) {
                EndPointManager.purgeRoutingTable(this.identity);
                oBJECT_NOT_EXIST = new OBJECT_NOT_EXIST("Route to object has been lost due to : " + throwable, 1330446337, CompletionStatus.COMPLETED_MAYBE);
            }
            this.endpoint.handleProtocolException(this.m, oBJECT_NOT_EXIST);
        }
    }
}

