/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import org.omg.CORBA.MARSHAL;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.MessageHeaderConstants;
import weblogic.kernel.Kernel;
import weblogic.utils.Debug;
import weblogic.utils.collections.Pool;
import weblogic.utils.collections.StackPool;

public final class MessageHeader
implements MessageHeaderConstants {
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");
    private byte[] magic = new byte[4];
    private byte[] GIOP_version = new byte[2];
    private byte flags;
    private byte message_type;
    private long message_size;
    private static final int MSG_POOL_SIZE = 1024;
    private static final Pool msgPool = new StackPool(1024);

    public String toString() {
        return "MessageHeader: magic = " + (char)this.magic[0] + (char)this.magic[1] + (char)this.magic[2] + (char)this.magic[3] + " GIOP_version = " + this.GIOP_version[0] + "." + this.GIOP_version[1] + "\n" + ((this.flags & 1) == 0 ? " big-endian byte order" : "little-endian byte order ") + " fragments follow = " + this.isFragmented() + " message_type = " + this.message_type + " message_size = " + this.message_size;
    }

    public MessageHeader(IIOPInputStream iIOPInputStream) {
        this.read(iIOPInputStream);
    }

    public void read(IIOPInputStream iIOPInputStream) {
        iIOPInputStream.read_octet_array(this.magic, 0, 4);
        iIOPInputStream.read_octet_array(this.GIOP_version, 0, 2);
        if (this.GIOP_version[0] != 1) {
            throw new MARSHAL("Unsupported GIOP version.");
        }
        switch (this.getMinorVersion()) {
            default: 
        }
        this.flags = iIOPInputStream.read_octet();
        iIOPInputStream.setEndian(this.isLittleEndian());
        iIOPInputStream.setMinorVersion(this.getMinorVersion());
        this.message_type = iIOPInputStream.read_octet();
        this.message_size = iIOPInputStream.read_long();
        if (this.isFragmented() && (this.message_size + 12L) % 8L != 0L) {
            throw new MARSHAL("Fragments must be a multiple of 8 bytes ");
        }
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            Debug.say((String)("MessageHeader: " + this));
        }
    }

    public MessageHeader(int n, int n2) {
        this.magic = MAGIC_VALUE;
        switch (n2) {
            case 0: {
                this.GIOP_version = GIOP_VERSION_1_0;
                break;
            }
            case 1: {
                this.GIOP_version = GIOP_VERSION_1_1;
                break;
            }
            case 2: {
                this.GIOP_version = GIOP_VERSION_1_2;
                break;
            }
            default: {
                throw new MARSHAL("Unsupported GIOP version.");
            }
        }
        this.flags = 0;
        this.message_type = (byte)n;
        this.message_size = 0L;
    }

    public static int getMsgType(byte[] byArray) {
        switch (byArray[7]) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
        }
        return -1;
    }

    public int getMsgType() {
        return this.message_type;
    }

    public int getMsgSize() {
        return (int)this.message_size;
    }

    public boolean isLittleEndian() {
        return (this.flags & 1) == 1;
    }

    public boolean isFragmented() {
        return (this.flags & 2) == 2;
    }

    public void setFragmented(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
    }

    public int getMinorVersion() {
        return this.GIOP_version[1];
    }

    public String getMsgTypeAsString() {
        switch (this.message_type) {
            case 0: {
                return "REQUEST";
            }
            case 1: {
                return "REPLY";
            }
            case 2: {
                return "CANCEL_REQUEST";
            }
            case 3: {
                return "LOCATE_REQUEST";
            }
            case 4: {
                return "LOCATE_REPLY";
            }
            case 5: {
                return "CLOSE_CONNECTION";
            }
            case 6: {
                return "MESSAGE_ERROR";
            }
            case 7: {
                return "FRAGMENT";
            }
        }
        return "UNKNOWN";
    }

    public void write(IIOPOutputStream iIOPOutputStream) {
        iIOPOutputStream.write_octet(MAGIC_VALUE[0]);
        iIOPOutputStream.write_octet(MAGIC_VALUE[1]);
        iIOPOutputStream.write_octet(MAGIC_VALUE[2]);
        iIOPOutputStream.write_octet(MAGIC_VALUE[3]);
        iIOPOutputStream.write_octet(this.GIOP_version[0]);
        iIOPOutputStream.write_octet(this.GIOP_version[1]);
        iIOPOutputStream.write_octet(this.flags);
        iIOPOutputStream.write_octet(this.message_type);
        iIOPOutputStream.write_long(51966);
    }

    public static final MessageHeader getMessageHeader(IIOPInputStream iIOPInputStream) {
        MessageHeader messageHeader = (MessageHeader)msgPool.remove();
        if (messageHeader == null) {
            messageHeader = new MessageHeader(iIOPInputStream);
        } else {
            messageHeader.read(iIOPInputStream);
        }
        return messageHeader;
    }

    public final void close() {
        this.flags = 0;
        this.message_type = 0;
        this.message_size = 0L;
        msgPool.add((Object)this);
    }
}

