/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import weblogic.iiop.MessageHeaderConstants;

public class MessageHeaderUtils
implements MessageHeaderConstants {
    public static final int getIntBigEndian(byte[] byArray, int n) {
        int n2 = byArray[n] << 24 & 0xFF000000;
        int n3 = byArray[n + 1] << 16 & 0xFF0000;
        int n4 = byArray[n + 2] << 8 & 0xFF00;
        int n5 = byArray[n + 3] & 0xFF;
        return n2 | n3 | n4 | n5;
    }

    public static final int getIntLittleEndian(byte[] byArray, int n) {
        int n2 = byArray[n + 3] << 24 & 0xFF000000;
        int n3 = byArray[n + 2] << 16 & 0xFF0000;
        int n4 = byArray[n + 1] << 8 & 0xFF00;
        int n5 = byArray[n] & 0xFF;
        return n2 | n3 | n4 | n5;
    }

    public static final int getShortBigEndian(byte[] byArray, int n) {
        int n2 = byArray[n] << 8 & 0xFF00;
        int n3 = byArray[n + 1] & 0xFF;
        return n2 | n3;
    }

    public static final int getShortLittleEndian(byte[] byArray, int n) {
        int n2 = byArray[n + 1] << 8 & 0xFF00;
        int n3 = byArray[n] & 0xFF;
        return n2 | n3;
    }

    public static final int getMsgLength(byte[] byArray) {
        byte by = (byte)(byArray[6] & 1);
        if (by == 0) {
            return MessageHeaderUtils.getIntBigEndian(byArray, 8) + 12;
        }
        return MessageHeaderUtils.getIntLittleEndian(byArray, 8) + 12;
    }
}

