/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.omg.CORBA.portable.ObjectImpl;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.Connection;
import weblogic.iiop.ConnectionKey;
import weblogic.iiop.ConnectionManager;
import weblogic.iiop.ConnectionShutdownHandler;
import weblogic.iiop.EndPoint;
import weblogic.iiop.EndPointImpl;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.MessageHeaderConstants;
import weblogic.iiop.ProtocolHandlerIIOP;
import weblogic.kernel.Kernel;
import weblogic.kernel.KernelStatus;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.AsyncMessageSenderImpl;
import weblogic.protocol.AsyncOutgoingMessage;
import weblogic.protocol.ChannelImpl;
import weblogic.protocol.MessageSender;
import weblogic.protocol.MessageSenderStatistics;
import weblogic.protocol.OutgoingMessage;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolHandlerAdmin;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.rmi.RMILogger;
import weblogic.rmi.spi.Channel;
import weblogic.security.SimpleCallbackHandler;
import weblogic.security.acl.DefaultUserInfoImpl;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.auth.login.PasswordCredential;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.subject.AbstractSubject;
import weblogic.socket.AbstractMuxableSocket;
import weblogic.socket.SocketMuxer;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.io.Chunk;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;

class MuxableSocketIIOP
extends AbstractMuxableSocket
implements MessageSender,
MessageHeaderConstants {
    protected static final int INITIAL_SO_TIMEOUT = 60000;
    private static final int CONNECT_TIMEOUT = Integer.getInteger("weblogic.iiop.connectTimeout", 0);
    private static final DebugCategory debugTransport = Debug.getCategory((String)"weblogic.iiop.transport");
    private static final DebugCategory debugConnection = Debug.getCategory((String)"weblogic.iiop.connection");
    private static final DebugLogger debugIIOPTransport = DebugLogger.getDebugLogger((String)"DebugIIOPTransport");
    private static final DebugLogger debugIIOPConnection = DebugLogger.getDebugLogger((String)"DebugIIOPConnection");
    private static final boolean DEBUG = false;
    private static final int CONNECT_MAX_RETRY = 1;
    private static final int BACKOFF_INTERVAL = Kernel.getConfig().getSocketReaderTimeoutMinMillis();
    private static boolean enabled = false;
    private boolean timeoutPingFailed = false;
    private AuthenticatedSubject subject = null;
    static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final IIOPConnection connection = new IIOPConnection();
    private ConnectionKey key;
    private Channel channel;

    void setSubject(AuthenticatedSubject authenticatedSubject) {
        this.subject = authenticatedSubject;
    }

    protected AuthenticatedSubject getSubject() {
        return this.subject;
    }

    private AuthenticatedSubject authenticateLocally(UserInfo userInfo) {
        if (userInfo instanceof DefaultUserInfoImpl) {
            DefaultUserInfoImpl defaultUserInfoImpl = (DefaultUserInfoImpl)userInfo;
            String string = defaultUserInfoImpl.getName();
            String string2 = defaultUserInfoImpl.getPassword();
            if (string == null || string.length() == 0) {
                return null;
            }
            PrincipalAuthenticator principalAuthenticator = Connection.getPrincipalAuthenticator();
            try {
                SimpleCallbackHandler simpleCallbackHandler = new SimpleCallbackHandler(string, string2);
                AuthenticatedSubject authenticatedSubject = principalAuthenticator.authenticate((CallbackHandler)simpleCallbackHandler, (ContextHandler)this);
                PasswordCredential passwordCredential = new PasswordCredential(string, string2);
                authenticatedSubject.getPrivateCredentials((AbstractSubject)kernelId).add(passwordCredential);
                return authenticatedSubject;
            }
            catch (LoginException loginException) {
                throw new SecurityException("User failed to be authenticated: " + loginException.getMessage());
            }
        }
        throw new SecurityException("Received bad UserInfo: " + userInfo.getClass().getName());
    }

    protected static void p(String string) {
        System.err.println("<MuxableSocketIIOP:" + System.currentTimeMillis() + "> " + string);
    }

    public static void initialize() {
        enabled = !Kernel.isServer() ? true : ManagementService.getRuntimeAccess(kernelId).getServer().isIIOPEnabled();
    }

    static void disable() {
        enabled = false;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public MuxableSocketIIOP(Chunk chunk, Socket socket, ServerChannel serverChannel) throws IOException {
        super(chunk, socket, serverChannel);
        this.setSoTimeout(60000);
        this.key = new ConnectionKey(this.getSocket().getInetAddress().getHostAddress(), this.getSocket().getPort());
        this.channel = new ChannelImpl(this.getSocket().getInetAddress().getHostAddress(), this.getSocket().getPort(), ProtocolHandlerIIOP.PROTOCOL_IIOP.getProtocolName());
    }

    protected MuxableSocketIIOP(ServerChannel serverChannel) {
        super(serverChannel);
    }

    static MuxableSocketIIOP createConnection(InetAddress inetAddress, int n, String string) throws IOException {
        ServerChannel serverChannel = null;
        if (KernelStatus.isServer() && kernelId.getQOS() == 103 && SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId) == kernelId) {
            if (ProtocolManager.getDefaultAdminProtocol().toByte() != ProtocolHandlerIIOP.PROTOCOL_IIOP.toByte()) {
                throw new IOException("Attempted to use IIOP as the admin protocol");
            }
            serverChannel = ServerChannelManager.findOutboundServerChannel((Protocol)ProtocolHandlerAdmin.PROTOCOL_ADMIN, (String)string);
        } else {
            serverChannel = ServerChannelManager.findOutboundServerChannel((Protocol)ProtocolHandlerIIOP.PROTOCOL_IIOP, (String)string);
        }
        if (debugConnection.isEnabled() || debugIIOPConnection.isDebugEnabled()) {
            IIOPLogger.logDebugConnection((String)("Initiating connection to " + inetAddress + ":" + n + " on " + serverChannel));
        }
        MuxableSocketIIOP muxableSocketIIOP = new MuxableSocketIIOP(serverChannel);
        muxableSocketIIOP.connect(inetAddress, n);
        SocketMuxer.getMuxer().register(muxableSocketIIOP);
        SocketMuxer.getMuxer().read(muxableSocketIIOP);
        if (debugConnection.isEnabled() || debugIIOPConnection.isDebugEnabled()) {
            IIOPLogger.logDebugConnection((String)("Connected to " + inetAddress + ":" + n));
        }
        return muxableSocketIIOP;
    }

    public final void connect(InetAddress inetAddress, int n) throws IOException, UnknownHostException {
        super.connect(inetAddress, n);
        this.setSoTimeout(60000);
        this.key = new ConnectionKey(inetAddress.getHostAddress(), n, this.getSocket().getLocalPort());
        this.channel = new ChannelImpl(inetAddress.getHostAddress(), n, ProtocolHandlerIIOP.PROTOCOL_IIOP.getProtocolName());
    }

    protected final Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        int n2 = 0;
        while (true) {
            try {
                return this.newSocket(inetAddress, n);
            }
            catch (SocketException socketException) {
                if (n2 == 1) {
                    throw socketException;
                }
                try {
                    Thread.sleep((long)(Math.random() * (double)(BACKOFF_INTERVAL << n2)));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n2;
                continue;
            }
            break;
        }
    }

    protected Socket newSocket(InetAddress inetAddress, int n) throws IOException {
        return super.createSocket(inetAddress, n, CONNECT_TIMEOUT);
    }

    public final int getIdleTimeoutMillis() {
        int n = super.getIdleTimeoutMillis();
        if (this.connection.hasPendingResponses()) {
            n = this.connection.getChannel().getTimeoutConnectionWithPendingResponses() ? (n *= Kernel.getConfig().getIdlePeriodsUntilTimeout()) : 0;
        }
        Debug.assertion((n == 0 || n >= 1000 ? 1 : 0) != 0);
        if (n == 0 && this.connection.getHeartbeatStub() != null && !Kernel.isServer()) {
            n = Kernel.getConfig().getPeriodLength();
        }
        return n;
    }

    public final void dispatch(Chunk chunk) {
        ConnectionManager.getConnectionManager().dispatch(this.connection, chunk);
    }

    protected int getMessageLength() {
        int n = this.getHeaderByte(6) & 1;
        int n2 = this.getHeaderByte(8) & 0xFF;
        int n3 = this.getHeaderByte(9) & 0xFF;
        int n4 = this.getHeaderByte(10) & 0xFF;
        int n5 = this.getHeaderByte(11) & 0xFF;
        int n6 = 0;
        n6 = n == 0 ? (n2 << 24 | n3 << 16 | n4 << 8 | n5) + 12 : (n5 << 24 | n4 << 16 | n3 << 8 | n2) + 12;
        Debug.assertion((n6 >= 0 && n6 < 0x8000000 ? 1 : 0) != 0);
        return n6;
    }

    protected int getHeaderLength() {
        return 12;
    }

    public final void hasException(Throwable throwable) {
        boolean bl = false;
        if (this.getSocket() != null) {
            bl = true;
        }
        if (bl) {
            new ConnectionShutdownHandler(this.connection, throwable);
        }
    }

    public final void endOfStream() {
        boolean bl = false;
        if (this.getSocket() != null) {
            bl = true;
        }
        if (bl) {
            new ConnectionShutdownHandler(this.connection, new EOFException("endOfStream called by muxer"), false);
        }
    }

    public boolean isDead() {
        return !this.getSocketFilter().getSocketInfo().touch();
    }

    public final boolean timeout() {
        new ConnectionShutdownHandler(this.connection, new EOFException("Idle connection was timed out"));
        return false;
    }

    public final boolean requestTimeout() {
        if (this.connection.getHeartbeatStub() == null || this.timeoutPingFailed) {
            return true;
        }
        WorkManagerFactory.getInstance().getSystem().schedule((Runnable)new WorkAdapter(){

            public void run() {
                try {
                    MuxableSocketIIOP.this.timeoutPingFailed = true;
                    if (((ObjectImpl)MuxableSocketIIOP.this.connection.getHeartbeatStub())._non_existent()) {
                        RMILogger.logHeartbeatPeerClosed();
                    } else {
                        MuxableSocketIIOP.this.timeoutPingFailed = false;
                        if (debugTransport.isEnabled() || debugIIOPTransport.isDebugEnabled()) {
                            IIOPLogger.logDebugTransport((String)("Heartbeat sent successfully to: " + MuxableSocketIIOP.this.connection.getHeartbeatStub()));
                        }
                    }
                }
                catch (Throwable throwable) {
                    RMILogger.logHeartbeatPeerClosed();
                    MuxableSocketIIOP.this.timeoutPingFailed = true;
                }
            }
        });
        return false;
    }

    public String toString() {
        return super.toString() + ", key = " + this.key + ", raw socket = " + this.getSocket();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public final void send(OutgoingMessage outgoingMessage) throws IOException {
        OutputStream outputStream = this.getSocketOutputStream();
        if (this.isClosed()) {
            throw new EOFException("Attempt to send message on closed socket");
        }
        try {
            this.getSocketFilter().getSocketInfo().touch();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        outgoingMessage.writeTo(outputStream);
    }

    public void gotExceptionSending(OutgoingMessage outgoingMessage, IOException iOException) {
        ConnectionManager.getConnectionManager().handleExceptionSending(this.connection, iOException);
    }

    protected final void cleanup() {
        super.cleanup();
        SocketMuxer.getMuxer().deliverEndOfStream(this.getSocketFilter());
        SocketMuxer.getMuxer().finishExceptionHandling(this.getSocketFilter());
    }

    public AuthenticatedSubject getUser() {
        return this.subject == null ? Connection.getDefaultSubject() : this.subject;
    }

    public void authenticate(UserInfo userInfo) throws SecurityException {
        if (userInfo == null) {
            return;
        }
        this.subject = userInfo instanceof AuthenticatedUser ? SecurityServiceManager.getASFromAU((AuthenticatedUser)((AuthenticatedUser)userInfo)) : this.authenticateLocally(userInfo);
    }

    protected boolean isSecure() {
        return false;
    }

    private class IIOPConnection
    extends Connection {
        private final AsyncMessageSenderImpl sender;
        private EndPoint endPoint;
        private Object txContext = null;

        private IIOPConnection() {
            this.sender = new AsyncMessageSenderImpl((MessageSender)MuxableSocketIIOP.this);
            MuxableSocketIIOP.this.addSenderStatistics((MessageSenderStatistics)this.sender);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final EndPoint getEndPoint() {
            if (this.endPoint == null) {
                IIOPConnection iIOPConnection = this;
                synchronized (iIOPConnection) {
                    if (this.endPoint == null) {
                        this.endPoint = new EndPointImpl(this, ConnectionManager.getConnectionManager());
                    }
                }
            }
            return this.endPoint;
        }

        private boolean hasPendingResponses() {
            EndPoint endPoint = this.getEndPoint();
            if (endPoint == null) {
                return false;
            }
            return endPoint.hasPendingResponses();
        }

        public Object getTxContext() {
            return this.txContext;
        }

        public void setTxContext(Object object) {
            this.txContext = object;
        }

        public void authenticate(UserInfo userInfo) throws SecurityException {
            MuxableSocketIIOP.this.authenticate(userInfo);
        }

        public AuthenticatedSubject getUser() {
            return MuxableSocketIIOP.this.getUser();
        }

        public final void send(AsyncOutgoingMessage asyncOutgoingMessage) throws IOException {
            this.sender.send(asyncOutgoingMessage);
        }

        public final ServerChannel getChannel() {
            return MuxableSocketIIOP.this.getChannel();
        }

        public final boolean isClosed() {
            return MuxableSocketIIOP.this.isClosed();
        }

        public final void close() {
            MuxableSocketIIOP.this.close();
        }

        public final ConnectionKey getConnectionKey() {
            return MuxableSocketIIOP.this.key;
        }

        public final Channel getRemoteChannel() {
            return MuxableSocketIIOP.this.channel;
        }

        public final ContextHandler getContextHandler() {
            return MuxableSocketIIOP.this;
        }

        public final void setConnectionKey(ConnectionKey connectionKey) {
            MuxableSocketIIOP.this.key = connectionKey;
            MuxableSocketIIOP.this.channel = (Channel)new ChannelImpl(MuxableSocketIIOP.this.key.getAddress(), MuxableSocketIIOP.this.key.getPort(), ProtocolHandlerIIOP.PROTOCOL_IIOP.getProtocolName());
        }

        protected boolean isSecure() {
            return MuxableSocketIIOP.this.isSecure();
        }
    }
}

