/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.security.auth.login.LoginException;
import weblogic.iiop.Connection;
import weblogic.iiop.MuxableSocketIIOP;
import weblogic.iiop.ProtocolHandlerIIOPS;
import weblogic.kernel.Kernel;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolHandlerAdmin;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.utils.SSLCertUtility;
import weblogic.security.utils.SSLIOContext;
import weblogic.security.utils.SSLIOContextTable;
import weblogic.socket.JSSESocket;
import weblogic.socket.SSLFilter;
import weblogic.socket.utils.JSSEUtils;
import weblogic.utils.io.Chunk;

final class MuxableSocketIIOPS
extends MuxableSocketIIOP {
    public MuxableSocketIIOPS(Chunk chunk, Socket socket, ServerChannel serverChannel) throws IOException {
        super(chunk, socket, serverChannel);
    }

    protected MuxableSocketIIOPS(ServerChannel serverChannel) {
        super(serverChannel);
    }

    static MuxableSocketIIOP createConnection(InetAddress inetAddress, int n, String string) throws IOException {
        ServerChannel serverChannel = null;
        if (KernelStatus.isServer() && kernelId.getQOS() == 103 && SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId) == kernelId) {
            if (ProtocolManager.getDefaultAdminProtocol().toByte() != ProtocolHandlerIIOPS.PROTOCOL_IIOPS.toByte()) {
                throw new IOException("Attempted to use IIOPS as the admin protocol");
            }
            serverChannel = ServerChannelManager.findOutboundServerChannel((Protocol)ProtocolHandlerAdmin.PROTOCOL_ADMIN, (String)string);
        } else {
            serverChannel = ServerChannelManager.findOutboundServerChannel((Protocol)ProtocolHandlerIIOPS.PROTOCOL_IIOPS, (String)string);
        }
        MuxableSocketIIOPS muxableSocketIIOPS = new MuxableSocketIIOPS(serverChannel);
        muxableSocketIIOPS.connect(inetAddress, n);
        muxableSocketIIOPS.register(muxableSocketIIOPS.getSocket(), true);
        return muxableSocketIIOPS;
    }

    public void register(Socket socket, boolean bl) throws IOException {
        if (bl) {
            SSLSocket sSLSocket = (SSLSocket)socket;
            JSSESocket jSSESocket = JSSEUtils.getJSSESocket(sSLSocket);
            if (jSSESocket != null) {
                JSSEUtils.registerJSSEFilter(jSSESocket, this);
                JSSEUtils.activate(jSSESocket, this);
            } else {
                SSLIOContext sSLIOContext = SSLIOContextTable.findContext(sSLSocket);
                SSLFilter sSLFilter = (SSLFilter)sSLIOContext.getFilter();
                this.setSocketFilter(sSLFilter);
                try {
                    sSLSocket.startHandshake();
                }
                catch (SSLException sSLException) {
                    if (!sSLSocket.isClosed()) {
                        try {
                            sSLSocket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw sSLException;
                }
                sSLFilter.setDelegate(this);
                sSLFilter.activate();
                if (!Kernel.isServer()) {
                    return;
                }
            }
        }
    }

    public byte getQOS() {
        return 102;
    }

    public void authenticate(UserInfo userInfo) {
        if (userInfo != null && !(userInfo instanceof AuthenticatedUser) && this.authenticate()) {
            return;
        }
        super.authenticate(userInfo);
    }

    public AuthenticatedSubject getUser() {
        if (this.getSubject() == null && Kernel.isServer()) {
            this.authenticate();
        }
        return super.getUser();
    }

    private boolean authenticate() {
        X509Certificate[] x509CertificateArray = null;
        SSLSocket sSLSocket = (SSLSocket)this.getSocket();
        try {
            x509CertificateArray = SSLCertUtility.getPeerCertChain(sSLSocket);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (x509CertificateArray != null) {
            String string = "X.509";
            PrincipalAuthenticator principalAuthenticator = Connection.getPrincipalAuthenticator();
            try {
                AuthenticatedSubject authenticatedSubject = principalAuthenticator.assertIdentity(string, (Object)x509CertificateArray, (ContextHandler)this);
                if (authenticatedSubject != null) {
                    this.setSubject(authenticatedSubject);
                    return true;
                }
            }
            catch (LoginException loginException) {
                // empty catch block
            }
        }
        return false;
    }

    protected final boolean isSecure() {
        return true;
    }
}

