/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.util.HashMap;
import weblogic.common.internal.ProxyClassResolver;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.IIOPInputStream;
import weblogic.kernel.Kernel;
import weblogic.utils.collections.NumericValueHashMap;
import weblogic.utils.collections.Stack;
import weblogic.utils.io.ObjectInput;
import weblogic.utils.io.ObjectStreamField;

final class ObjectInputStreamImpl
extends ObjectInputStream {
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");
    private IIOPInputStream delegate;
    private Object value;
    private weblogic.utils.io.ObjectStreamClass osc;
    private boolean dfwoCalled = false;
    private int streamFormatState;
    private static final int STREAM_VERSION_1 = 0;
    private static final int STREAM_VERSION_2 = 1;
    private static final int STREAM_VERSION_2_UNTERMINATED = 2;
    private GetFieldImpl getFields;
    private IIOPInputStream.Marker mark = new IIOPInputStream.Marker();
    private Stack streamStack;

    ObjectInputStreamImpl(IIOPInputStream iIOPInputStream, Object object, weblogic.utils.io.ObjectStreamClass objectStreamClass, boolean bl, byte by) throws IOException {
        this.delegate = iIOPInputStream;
        this.value = object;
        this.osc = objectStreamClass;
        this.streamFormatState = by > 1 ? 1 : 0;
        this.delegate.mark(0);
        this.delegate.mark(this.mark);
        this.dfwoCalled = bl;
    }

    void pushCurrent(Object object, weblogic.utils.io.ObjectStreamClass objectStreamClass, boolean bl, byte by) {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            ObjectInputStreamImpl.p("pushCurrent(" + objectStreamClass + ")");
        }
        if (this.streamStack == null) {
            this.streamStack = new Stack();
        }
        this.streamStack.push((Object)new StreamEntry());
        this.value = object;
        this.osc = objectStreamClass;
        this.dfwoCalled = bl;
        this.getFields = null;
        this.streamFormatState = by > 1 ? 1 : 0;
        this.delegate.mark(this.mark);
    }

    private void popCurrent() {
        if (this.streamStack != null && this.streamStack.size() > 0) {
            StreamEntry streamEntry = (StreamEntry)this.streamStack.pop();
            this.value = streamEntry.value;
            this.osc = streamEntry.osc;
            this.dfwoCalled = streamEntry.dfwoCalled;
            this.getFields = streamEntry.getFields;
            this.streamFormatState = streamEntry.streamFormatState;
            this.mark.copy(streamEntry.mark);
        } else {
            this.value = null;
            this.osc = null;
        }
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            ObjectInputStreamImpl.p("popCurrent(" + this.osc + ")");
        }
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException("readLine");
    }

    public int readInt() throws IOException {
        return this.delegate.readInt();
    }

    public String readUTF() throws IOException {
        return this.delegate.readUTF();
    }

    public long readLong() throws IOException {
        return this.delegate.readLong();
    }

    public byte readByte() throws IOException {
        return this.delegate.readByte();
    }

    public short readShort() throws IOException {
        return this.delegate.readShort();
    }

    public float readFloat() throws IOException {
        return this.delegate.readFloat();
    }

    public char readChar() throws IOException {
        return this.delegate.readChar();
    }

    public void readFully(byte[] byArray) throws IOException {
        this.delegate.readFully(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.delegate.readFully(byArray, n, n2);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.delegate.read(byArray, n, n2);
    }

    public int read() throws IOException {
        return this.delegate.read();
    }

    public int skipBytes(int n) throws IOException {
        return this.delegate.skipBytes(n);
    }

    public boolean readBoolean() throws IOException {
        return this.delegate.readBoolean();
    }

    public int readUnsignedByte() throws IOException {
        return this.delegate.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.delegate.readUnsignedShort();
    }

    public double readDouble() throws IOException {
        return this.delegate.readDouble();
    }

    public Object readObjectOverride() throws IOException, ClassNotFoundException {
        return this.delegate.readObject();
    }

    public Object readUnshared() throws IOException, ClassNotFoundException {
        return this.delegate.readObject();
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException {
        if (this.value == null) {
            throw new NotActiveException("Not in writeObject()");
        }
        if (!this.dfwoCalled) {
            throw new StreamCorruptedException("defaultWriteObject was not called by the sender.");
        }
        this.osc.readFields(this.value, (ObjectInput)this.delegate);
        if (this.streamFormatState == 1 && this.delegate.startValue()) {
            this.streamFormatState = 2;
        }
    }

    public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
        if (this.value == null) {
            throw new NotActiveException("Not in writeObject()");
        }
        if (this.getFields == null) {
            this.getFields = new GetFieldImpl();
        }
        this.getFields.read();
        return this.getFields;
    }

    protected Class resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        return ProxyClassResolver.resolveProxyClass(stringArray);
    }

    public void reset() throws IOException {
        this.delegate.reset(this.mark);
    }

    public void close() throws IOException {
        if (this.streamFormatState == 2) {
            this.delegate.end_value();
        }
        this.popCurrent();
    }

    private static void p(String string) {
        System.out.println("<ObjectInputStreamImpl>: " + string);
    }

    private final class GetFieldImpl
    extends ObjectInputStream.GetField {
        private final HashMap fieldMap = new HashMap();
        private final NumericValueHashMap primitiveFieldMap = new NumericValueHashMap();

        private GetFieldImpl() {
        }

        public boolean get(String string, boolean bl) {
            return this.primitiveFieldMap.get((Object)string, (long)(bl ? 1 : 0)) == 1L;
        }

        public byte get(String string, byte by) {
            return (byte)this.primitiveFieldMap.get((Object)string, (long)by);
        }

        public char get(String string, char c) {
            return (char)this.primitiveFieldMap.get((Object)string, (long)c);
        }

        public short get(String string, short s) {
            return (short)this.primitiveFieldMap.get((Object)string, (long)s);
        }

        public int get(String string, int n) {
            return (int)this.primitiveFieldMap.get((Object)string, (long)n);
        }

        public long get(String string, long l) {
            return this.primitiveFieldMap.get((Object)string, l);
        }

        public float get(String string, float f) {
            return Float.intBitsToFloat((int)this.primitiveFieldMap.get((Object)string, (long)Float.floatToIntBits(f)));
        }

        public double get(String string, double d) {
            return Double.longBitsToDouble(this.primitiveFieldMap.get((Object)string, Double.doubleToLongBits(d)));
        }

        public Object get(String string, Object object) {
            return this.fieldMap.get(string);
        }

        public boolean defaulted(String string) {
            return !this.primitiveFieldMap.containsKey((Object)string) && !this.fieldMap.containsKey(string);
        }

        public ObjectStreamClass getObjectStreamClass() {
            return ObjectInputStreamImpl.this.osc.getObjectStreamClass();
        }

        private void read() throws IOException, ClassNotFoundException {
            ObjectStreamField[] objectStreamFieldArray = ObjectInputStreamImpl.this.osc.getFields();
            block8: for (int i = 0; i < objectStreamFieldArray.length; ++i) {
                ObjectStreamField objectStreamField = objectStreamFieldArray[i];
                if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                    ObjectInputStreamImpl.p("Reading: " + objectStreamField);
                }
                switch (objectStreamField.getTypeCode()) {
                    case 'B': 
                    case 'Z': {
                        this.primitiveFieldMap.put((Object)objectStreamField.getName(), (long)ObjectInputStreamImpl.this.delegate.readByte());
                        continue block8;
                    }
                    case 'C': {
                        this.primitiveFieldMap.put((Object)objectStreamField.getName(), (long)ObjectInputStreamImpl.this.delegate.readChar());
                        continue block8;
                    }
                    case 'S': {
                        this.primitiveFieldMap.put((Object)objectStreamField.getName(), (long)ObjectInputStreamImpl.this.delegate.readShort());
                        continue block8;
                    }
                    case 'F': 
                    case 'I': {
                        this.primitiveFieldMap.put((Object)objectStreamField.getName(), (long)ObjectInputStreamImpl.this.delegate.readInt());
                        continue block8;
                    }
                    case 'D': 
                    case 'J': {
                        this.primitiveFieldMap.put((Object)objectStreamField.getName(), ObjectInputStreamImpl.this.delegate.readLong());
                        continue block8;
                    }
                    case 'L': 
                    case '[': {
                        this.fieldMap.put(objectStreamField.getName(), ObjectInputStreamImpl.this.delegate.readObject(objectStreamField.getType()));
                        continue block8;
                    }
                    default: {
                        throw new IOException("Bad typecode: " + objectStreamField.getTypeCode());
                    }
                }
            }
            if (ObjectInputStreamImpl.this.streamFormatState == 1 && ObjectInputStreamImpl.this.delegate.startValue()) {
                ObjectInputStreamImpl.this.streamFormatState = 2;
            }
        }
    }

    private final class StreamEntry {
        private final Object value;
        private final weblogic.utils.io.ObjectStreamClass osc;
        private final boolean dfwoCalled;
        private final GetFieldImpl getFields;
        private final int streamFormatState;
        private final IIOPInputStream.Marker mark = new IIOPInputStream.Marker();

        private StreamEntry() {
            this.value = ObjectInputStreamImpl.this.value;
            this.osc = ObjectInputStreamImpl.this.osc;
            this.dfwoCalled = ObjectInputStreamImpl.this.dfwoCalled;
            this.getFields = ObjectInputStreamImpl.this.getFields;
            this.streamFormatState = ObjectInputStreamImpl.this.streamFormatState;
            this.mark.copy(ObjectInputStreamImpl.this.mark);
        }
    }
}

