/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.HashMap;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosTransactions.TransactionFactoryHelper;
import org.omg.SendingContext.CodeBaseHelper;
import weblogic.corba.utils.MarshaledString;
import weblogic.corba.utils.RepositoryId;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.IOR;
import weblogic.iiop.InitialReferences;
import weblogic.iiop.ServiceContext;
import weblogic.iiop.TaggedComponent;
import weblogic.kernel.Kernel;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.Identity;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.ServerIdentity;
import weblogic.protocol.ServerIdentityManager;
import weblogic.rmi.extensions.server.ActivatableServerReference;
import weblogic.rmi.internal.OIDManager;
import weblogic.rmi.internal.RemoteType;
import weblogic.rmi.internal.RuntimeDescriptor;
import weblogic.rmi.internal.ServerReference;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;
import weblogic.utils.Hex;
import weblogic.utils.StringUtils;

public class ObjectKey {
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");
    private int keyType = 0;
    private int oid = 0;
    private int keyLength = 0;
    private transient int numComponents = 0;
    private Object activationID;
    private IIOPInputStream activationData;
    private boolean foreignKey = false;
    private byte[] key_data;
    private ServerIdentity target;
    private Identity identity;
    private static final String BOOTSTRAP_NAME_SERVICE = "INIT";
    static final String NAME_SERVICE = "NameService";
    private static final String BEA_NAME_SERVICE = "BEA:NameService:Root";
    static final ObjectKey BOOTSTRAP_KEY = new ObjectKey("INIT");
    static final ObjectKey NAME_SERVICE_KEY = new ObjectKey("NameService");
    private byte[] preMarshalled;
    private static HashMap typeIdMap = new HashMap();
    private static final int ENCAPKEYHEADERSIZE = 8;
    private static final int KEYTYPE_ICEBERG = 8;
    private static final int TAG_OBJKEY_HASH = 1111834886;
    private static final int TAG_CLNT_ROUTE_INFO = 1111834884;
    private static final int TAG_WLS_INITIAL_REF = 1111834888;
    private static final int TAG_WLS_TRANSIENT_REF_51 = 1111834890;
    private static final int TAG_WLS_TRANSIENT_REF_61 = 1111834887;
    private static final int TAG_WLS_OBJ_INFO = 1111834891;
    private static final int TAG_WLS_ACTIVATABLE_REF = 1111834897;
    private static final int TAG_WLS_ACTIVATABLE_REF_81 = 1111834896;
    private static final int TAG_WLS_TRANSIENT_REF = 1111834922;
    private static final int KEY_MAJOR_VERSION = 1;
    private static final int KEY_MINOR_VERSION = 3;
    private static final int WLS_OA_ID = 0;
    private static final int MAX_KEY_SIZE = 0x100000;
    private static MarshaledString localDomainId;
    private int wleVersionMajor = 1;
    private int wleVersionMinor = 3;
    private RepositoryId interfaceName = RepositoryId.EMPTY;
    private MarshaledString wleDomainId;
    private int wleGroupId = 0;
    private String wleObjectId = "";
    private int wleObjectAdapter = 0;
    private int wleScaInterfaceBucket = -1;
    private transient int numForeignComponents = 0;
    private TaggedComponent[] foreignComponents;
    private String[] remoteInterfaces = null;
    private boolean isRepIdAnInterface = true;
    private transient boolean writeObjInfo = false;
    private transient boolean computeRepId = true;

    public ObjectKey() {
    }

    ObjectKey(IIOPInputStream iIOPInputStream) {
        this.read(iIOPInputStream);
    }

    ObjectKey(byte[] byArray) {
        this.key_data = byArray;
        this.foreignKey = true;
        this.keyLength = this.key_data.length;
    }

    private ObjectKey(String string) {
        this.keyLength = string.length();
        this.key_data = new byte[this.keyLength];
        string.getBytes(0, this.keyLength, this.key_data, 0);
        this.foreignKey = true;
    }

    public ObjectKey(String string, int n, ServerIdentity serverIdentity) {
        this.interfaceName = new RepositoryId(string);
        this.oid = n;
        this.keyType = 1111834922;
        this.target = serverIdentity;
        this.identity = serverIdentity.getTransientIdentity();
        this.wleDomainId = serverIdentity.getServerName() == null ? MarshaledString.EMPTY : (serverIdentity.isLocal() ? localDomainId : new MarshaledString(serverIdentity.getServerName()));
        this.wleGroupId = 0;
        this.numComponents = 1;
        this.checkObjInfoRequiredToBeMarshalled();
    }

    public ObjectKey(String string, int n) {
        this(string, n, LocalServerIdentity.getIdentity());
    }

    public ObjectKey(String string, int n, Object object) {
        this.interfaceName = new RepositoryId(string);
        this.oid = n;
        this.activationID = object;
        Debug.assertion((object != null ? 1 : 0) != 0);
        this.keyType = 1111834897;
        this.target = LocalServerIdentity.getIdentity();
        this.identity = this.target.getPersistentIdentity();
        this.wleDomainId = localDomainId;
        this.wleGroupId = 0;
        this.numComponents = 1;
        this.checkObjInfoRequiredToBeMarshalled();
    }

    public static final MarshaledString getLocalDomainID() {
        return localDomainId;
    }

    private static final MarshaledString getLocalDomainIDInternal() {
        if (Kernel.isServer()) {
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            return new MarshaledString(ManagementService.getRuntimeAccess(authenticatedSubject).getServerName());
        }
        return MarshaledString.EMPTY;
    }

    static void p(String string) {
        System.err.println("<ObjectKey> " + string);
    }

    protected final String getInterfaceName() {
        return this.interfaceName.toString();
    }

    protected final void setInterfaceName(String string) {
        this.preMarshalled = null;
        this.interfaceName = new RepositoryId(string);
    }

    public final int getObjectID() {
        return this.oid;
    }

    final MarshaledString getWLEDomainId() {
        return this.wleDomainId;
    }

    protected final void setWLEDomainId(String string) {
        this.preMarshalled = null;
        this.wleDomainId = new MarshaledString(string);
    }

    protected final void setWLEObjectId(String string) {
        this.preMarshalled = null;
        this.wleObjectId = string;
    }

    protected final void setWLEObjectAdapter(int n) {
        this.preMarshalled = null;
        this.wleObjectAdapter = n;
    }

    final boolean isWLEKey() {
        return this.target == null && !this.foreignKey && this.wleObjectAdapter >= 0;
    }

    final boolean isWLSKey() {
        return this.identity != null && this.target != null;
    }

    private final boolean isForeignKey() {
        return this.foreignKey || this.identity == null && this.wleObjectAdapter == 0;
    }

    final boolean isBEAKey() {
        return !this.foreignKey;
    }

    final boolean isBootstrapKey() {
        return this.foreignKey && this.key_data != null && this.key_data.length == 4 && (this.key_data[0] == 73 && this.key_data[1] == 78 && this.key_data[2] == 73 && this.key_data[3] == 84 || this.key_data[0] == 84 && this.key_data[1] == 73 && this.key_data[2] == 78 && this.key_data[3] == 73);
    }

    public final boolean isNamingKey() {
        return this.key_data != null && this.key_data.length < 128 && new String(this.key_data).equals(NAME_SERVICE) || this.oid == 8;
    }

    final IOR getInitialReference() {
        if (this.key_data != null && this.key_data.length < 128) {
            return InitialReferences.getInitialReference(new String(this.key_data));
        }
        return null;
    }

    final boolean isLocalKey() {
        return this.isWLSKey() && this.target != null && this.target.isLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getActivationID() {
        if (this.activationID == null && this.activationData != null) {
            IIOPInputStream iIOPInputStream = this.activationData;
            synchronized (iIOPInputStream) {
                if (this.activationData != null) {
                    this.activationID = this.activationData.read_value();
                    this.activationData.close();
                    this.activationData = null;
                }
            }
        }
        return this.activationID;
    }

    final ServerIdentity getTarget() {
        return this.target;
    }

    public final Identity getIdentity() {
        return this.identity;
    }

    public static String getTypeId(Object object) {
        String[] stringArray = (String[])typeIdMap.get(object);
        if (stringArray != null) {
            return stringArray[0];
        }
        return null;
    }

    protected final void setKeyType(int n) {
        this.preMarshalled = null;
        this.keyType = n;
    }

    public static ObjectKey getBootstrapKey(String string) {
        String[] stringArray;
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            ObjectKey.p("getBootstrapKey(" + string + ")");
        }
        if ((stringArray = (String[])typeIdMap.get(string)) != null) {
            byte[] byArray = new byte[stringArray[1].length()];
            stringArray[1].getBytes(0, stringArray[1].length(), byArray, 0);
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                ObjectKey.p("getBootstrapKey(" + string + ") = " + stringArray[1]);
            }
            return new ObjectKey(byArray);
        }
        byte[] byArray = new byte[string.length()];
        string.getBytes(0, string.length(), byArray, 0);
        return new ObjectKey(byArray);
    }

    Identity getTransientIdentity() {
        return this.identity;
    }

    private final boolean readVendor(IIOPInputStream iIOPInputStream) {
        char c = (char)iIOPInputStream.read_octet();
        char c2 = (char)iIOPInputStream.read_octet();
        char c3 = (char)iIOPInputStream.read_octet();
        return c == 'B' && c2 == 'E' && c3 == 'A';
    }

    private final void writeVendor(IIOPOutputStream iIOPOutputStream) {
        byte[] byArray = new byte[]{66, 69, 65};
        iIOPOutputStream.write_octet_array(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    final void read(IIOPInputStream iIOPInputStream) {
        this.preMarshalled = null;
        boolean bl = iIOPInputStream.isReadingObjectKey();
        iIOPInputStream.mark(0);
        int n = iIOPInputStream.read_long();
        if (n > 0x100000) {
            throw new MARSHAL("Stream corrupted at " + iIOPInputStream.pos() + ": tried to read object key of length " + Integer.toHexString(n));
        }
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            ObjectKey.p("read(" + Integer.toHexString(n) + "@" + iIOPInputStream.pos() + ")");
        }
        iIOPInputStream.reset();
        this.foreignKey = false;
        long l = iIOPInputStream.startEncapsulation(false);
        iIOPInputStream.mark(0);
        iIOPInputStream.consumeEndian();
        if (n < 8) {
            this.readForeignKey(iIOPInputStream, n, l);
            return;
        }
        if (!this.readVendor(iIOPInputStream)) {
            this.readForeignKey(iIOPInputStream, n, l);
            return;
        }
        if (iIOPInputStream.read_octet() != 8) {
            this.readForeignKey(iIOPInputStream, n, l);
            return;
        }
        byte by = iIOPInputStream.read_octet();
        this.wleVersionMajor = by;
        if (by > 1) {
            this.readForeignKey(iIOPInputStream, n, l);
            return;
        }
        iIOPInputStream.setReadingObjectKey(true);
        iIOPInputStream.clearMark();
        this.wleVersionMinor = iIOPInputStream.read_octet();
        this.wleObjectAdapter = iIOPInputStream.read_octet();
        this.wleDomainId = new MarshaledString((InputStream)iIOPInputStream);
        this.wleGroupId = iIOPInputStream.read_long();
        this.interfaceName = iIOPInputStream.read_repository_id();
        try {
            this.oid = iIOPInputStream.read_numeric_string();
        }
        catch (NumberFormatException numberFormatException) {
            this.oid = 0;
            this.wleObjectId = numberFormatException.getMessage();
            String[] stringArray = (String[])typeIdMap.get(this.wleObjectId);
            this.oid = stringArray != null && stringArray[1].equals(NAME_SERVICE) ? 8 : 0;
        }
        if (this.wleVersionMinor > 1 && this.wleVersionMajor == 1) {
            this.numComponents = iIOPInputStream.read_long();
            block14: for (int i = 0; i < this.numComponents; ++i) {
                int n2 = iIOPInputStream.read_long();
                switch (n2) {
                    case 1111834922: {
                        this.keyType = 1111834922;
                        long l2 = iIOPInputStream.startEncapsulation();
                        this.identity = Identity.read((InputStream)iIOPInputStream);
                        this.target = ServerIdentityManager.findServerIdentityFromTransient((Identity)this.identity);
                        iIOPInputStream.endEncapsulation(l2);
                        continue block14;
                    }
                    case 1111834888: {
                        this.keyType = 1111834888;
                        iIOPInputStream.read_long();
                        this.target = LocalServerIdentity.getIdentity();
                        continue block14;
                    }
                    case 1111834897: {
                        this.keyType = 1111834897;
                        this.activationData = new IIOPInputStream(iIOPInputStream);
                        this.identity = Identity.read((InputStream)this.activationData);
                        this.target = ServerIdentityManager.findServerIdentityFromPersistent((Identity)this.identity);
                        continue block14;
                    }
                    case 1111834891: {
                        long l2 = iIOPInputStream.startEncapsulation();
                        ByteArrayInputStream byteArrayInputStream = null;
                        DataInputStream dataInputStream = null;
                        try {
                            byte[] byArray = iIOPInputStream.read_octet_sequence();
                            byteArrayInputStream = new ByteArrayInputStream(byArray);
                            dataInputStream = new DataInputStream(byteArrayInputStream);
                            this.isRepIdAnInterface = dataInputStream.readBoolean();
                            String string = dataInputStream.readUTF();
                            if (string != null && string.length() > 0) {
                                this.remoteInterfaces = StringUtils.splitCompletely((String)string, (String)":");
                            }
                            if (dataInputStream != null) {
                                this.close(dataInputStream);
                            }
                        }
                        catch (Exception exception) {
                            if (dataInputStream != null) {
                                this.close(dataInputStream);
                            }
                            catch (Throwable throwable) {
                                if (dataInputStream != null) {
                                    this.close(dataInputStream);
                                }
                                throw throwable;
                            }
                        }
                        iIOPInputStream.endEncapsulation(l2);
                        this.writeObjInfo = true;
                        this.computeRepId = false;
                        continue block14;
                    }
                    default: {
                        if (this.foreignComponents == null) {
                            this.foreignComponents = new TaggedComponent[this.numComponents];
                        }
                        this.foreignComponents[this.numForeignComponents++] = new TaggedComponent(n2, iIOPInputStream);
                    }
                }
            }
        }
        iIOPInputStream.endEncapsulation(l);
        iIOPInputStream.setReadingObjectKey(bl);
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            ObjectKey.p("read length: " + n + ", Vendor: " + (this.foreignKey ? "Foreign" : "BEA"));
            if (!this.foreignKey) {
                ObjectKey.p("Domain Id: " + this.wleDomainId.toString() + ", Interface: " + this.interfaceName + ", Target: " + this.target + ", " + this.identity + " (local: " + LocalServerIdentity.getIdentity().getTransientIdentity() + ")");
            } else {
                try {
                    ObjectKey.p("Key data: " + new String(this.key_data, "US-ASCII"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
    }

    private final void readForeignKey(IIOPInputStream iIOPInputStream, int n, long l) {
        iIOPInputStream.reset();
        this.key_data = new byte[n];
        iIOPInputStream.read_octet_array(this.key_data, 0, this.key_data.length);
        this.foreignKey = true;
        iIOPInputStream.endEncapsulation(l);
    }

    final void write(IIOPOutputStream iIOPOutputStream) {
        long l = iIOPOutputStream.startEncapsulationNoEndian();
        if (this.preMarshalled == null) {
            if (!iIOPOutputStream.isWritingObjectKey()) {
                IIOPOutputStream iIOPOutputStream2 = new IIOPOutputStream(iIOPOutputStream.getLittleEndian(), iIOPOutputStream.getEndPoint());
                iIOPOutputStream2.setWritingObjectKey(true);
                this.writeEncapsulation(iIOPOutputStream2);
                this.preMarshalled = iIOPOutputStream2.getBuffer();
                iIOPOutputStream2.close();
            } else {
                IIOPOutputStream.Marker marker = new IIOPOutputStream.Marker();
                iIOPOutputStream.setMark(marker);
                this.writeEncapsulation(iIOPOutputStream);
                this.preMarshalled = iIOPOutputStream.getBufferFromMark(marker);
            }
        }
        iIOPOutputStream.write_octet_array(this.preMarshalled, 0, this.preMarshalled.length);
        iIOPOutputStream.endEncapsulation(l);
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            ObjectKey.p("wrote key length: " + this.keyLength + ", Vendor: " + (this.isForeignKey() ? "Foreign" : "BEA"));
            if (!this.isForeignKey()) {
                ObjectKey.p("Domain Id: " + this.wleDomainId.toString() + ", Interface: " + this.interfaceName + " Target: " + this.target);
            }
            ObjectKey.p("Key data: " + iIOPOutputStream.dumpBuf());
        }
    }

    private final void writeEncapsulation(IIOPOutputStream iIOPOutputStream) {
        if (this.foreignKey) {
            iIOPOutputStream.write_octet_array(this.key_data, 0, this.key_data.length);
            return;
        }
        iIOPOutputStream.putEndian();
        this.writeVendor(iIOPOutputStream);
        iIOPOutputStream.write_octet((byte)8);
        iIOPOutputStream.write_octet((byte)this.wleVersionMajor);
        iIOPOutputStream.write_octet((byte)this.wleVersionMinor);
        iIOPOutputStream.write_octet((byte)this.wleObjectAdapter);
        this.wleDomainId.write((OutputStream)iIOPOutputStream);
        iIOPOutputStream.write_long(this.wleGroupId);
        iIOPOutputStream.write_repository_id(this.interfaceName);
        if (this.oid != 0 && (this.wleObjectId == null || this.wleObjectId.length() == 0)) {
            iIOPOutputStream.write_string(Integer.toString(this.oid));
        } else {
            iIOPOutputStream.write_string(this.wleObjectId);
        }
        if (this.wleVersionMinor > 1 && this.wleVersionMajor == 1) {
            long l;
            iIOPOutputStream.write_long(this.numComponents);
            switch (this.keyType) {
                case 1111834922: {
                    iIOPOutputStream.write_long(1111834922);
                    l = iIOPOutputStream.startEncapsulation();
                    this.identity.write((OutputStream)iIOPOutputStream);
                    iIOPOutputStream.endEncapsulation(l);
                    break;
                }
                case 1111834888: {
                    iIOPOutputStream.write_long(1111834888);
                    iIOPOutputStream.write_long(0);
                    break;
                }
                case 1111834897: {
                    iIOPOutputStream.write_long(1111834897);
                    l = iIOPOutputStream.startEncapsulationNoNesting();
                    this.identity.write((OutputStream)iIOPOutputStream);
                    iIOPOutputStream.write_value((Serializable)this.getActivationID());
                    iIOPOutputStream.endEncapsulation(l);
                }
            }
            if (this.writeObjInfo) {
                iIOPOutputStream.write_long(1111834891);
                l = iIOPOutputStream.startEncapsulation();
                iIOPOutputStream.write_octet_sequence(this.getObjInfo());
                iIOPOutputStream.endEncapsulation(l);
            }
            for (int i = 0; i < this.numForeignComponents; ++i) {
                this.foreignComponents[i].write(iIOPOutputStream);
            }
        } else {
            iIOPOutputStream.write_long(0);
        }
    }

    private void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final int hashCode() {
        int n;
        int n2 = n = this.foreignKey ? 0 : -1;
        if (this.foreignKey) {
            if (this.key_data != null) {
                for (int i = 0; i < this.key_data.length; ++i) {
                    n ^= this.key_data[i];
                }
            }
        } else {
            n ^= this.wleVersionMajor ^ this.wleVersionMinor ^ this.wleObjectAdapter ^ this.wleGroupId ^ this.oid ^ this.wleDomainId.hashCode();
        }
        return n;
    }

    public final boolean equals(Object object) {
        if (object instanceof ObjectKey) {
            ObjectKey objectKey = (ObjectKey)object;
            if (this.foreignKey) {
                if (!objectKey.foreignKey) {
                    return false;
                }
                if (this.key_data == null) {
                    return objectKey.key_data == null;
                }
                if (this.key_data.length != objectKey.key_data.length) {
                    return false;
                }
                for (int i = 0; i < this.key_data.length; ++i) {
                    if (this.key_data[i] == objectKey.key_data[i]) continue;
                    return false;
                }
                return true;
            }
            if (objectKey.foreignKey) {
                return false;
            }
            if (this.wleVersionMajor != objectKey.wleVersionMajor) {
                return false;
            }
            if (this.wleVersionMinor != objectKey.wleVersionMinor) {
                return false;
            }
            if (this.wleObjectAdapter != objectKey.wleObjectAdapter) {
                return false;
            }
            if (this.wleGroupId != objectKey.wleGroupId) {
                return false;
            }
            if (this.oid != objectKey.oid) {
                return false;
            }
            if (!this.wleDomainId.equals(objectKey.wleDomainId)) {
                return false;
            }
            if (!this.interfaceName.equals(objectKey.interfaceName)) {
                return false;
            }
            if (!this.wleObjectId.equals(objectKey.wleObjectId)) {
                return false;
            }
            if (this.wleScaInterfaceBucket != objectKey.wleScaInterfaceBucket) {
                return false;
            }
            if (this.target != null && this.identity != objectKey.identity && !this.identity.equals((Object)objectKey.identity)) {
                return false;
            }
            return this.keyType == objectKey.keyType;
        }
        return false;
    }

    public final String toString() {
        if (!this.foreignKey) {
            return "type: " + ServiceContext.VMCIDToString(this.keyType) + ", interface: " + this.interfaceName + ", oid: " + this.oid + ", target: " + this.target + ", identity: " + this.identity;
        }
        return Hex.dump((byte[])this.key_data, (int)0, (int)this.key_data.length);
    }

    public String[] getRemoteInterfaces() {
        return this.remoteInterfaces;
    }

    public boolean isRepositoryIdAnInterface() {
        return this.isRepIdAnInterface;
    }

    private String[] getRemoteInterfacesForOid(int n) {
        String[] stringArray = null;
        try {
            RemoteType remoteType;
            RuntimeDescriptor runtimeDescriptor;
            ServerReference serverReference = OIDManager.getInstance().findServerReference(n);
            if (serverReference != null && (runtimeDescriptor = serverReference.getDescriptor()) != null && (remoteType = runtimeDescriptor.getRemoteType()) != null) {
                stringArray = remoteType.getInterfaces();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringArray;
    }

    private boolean isRepositoryIdAnInterfaceForOid(int n, RepositoryId repositoryId) {
        boolean bl;
        block6: {
            bl = true;
            try {
                ServerReference serverReference = OIDManager.getInstance().findServerReference(n);
                if (serverReference == null) break block6;
                Object object = serverReference.getImplementation();
                if (object == null && serverReference instanceof ActivatableServerReference) {
                    try {
                        object = ((ActivatableServerReference)serverReference).getImplementation(this.activationID);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                if (object != null && repositoryId != null && object.getClass().getName().equals(repositoryId.getClassName())) {
                    bl = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getObjInfo() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = null;
        try {
            dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            boolean bl = true;
            bl = this.computeRepId ? this.isRepositoryIdAnInterfaceForOid(this.oid, this.interfaceName) : this.isRepIdAnInterface;
            dataOutputStream.writeBoolean(bl);
            String string = "";
            if (this.remoteInterfaces != null) {
                string = StringUtils.join((String[])this.remoteInterfaces, (String)":");
            }
            dataOutputStream.writeUTF(string);
            dataOutputStream.flush();
        }
        catch (Exception exception) {
        }
        finally {
            if (dataOutputStream != null) {
                this.close(dataOutputStream);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    private boolean checkObjInfoRequiredToBeMarshalled() {
        boolean bl = false;
        if (!this.interfaceName.isIDLType()) {
            this.remoteInterfaces = this.getRemoteInterfacesForOid(this.oid);
            if (this.remoteInterfaces != null && this.remoteInterfaces.length > 1) {
                this.writeObjInfo = true;
                ++this.numComponents;
                bl = true;
            }
        }
        return bl;
    }

    static {
        Kernel.ensureInitialized();
        typeIdMap.put(new Integer(8), new String[]{NamingContextHelper.id(), NAME_SERVICE});
        typeIdMap.put(NAME_SERVICE, new String[]{NamingContextHelper.id(), NAME_SERVICE});
        typeIdMap.put(BOOTSTRAP_NAME_SERVICE, new String[]{NamingContextHelper.id(), NAME_SERVICE});
        typeIdMap.put(BEA_NAME_SERVICE, new String[]{NamingContextHelper.id(), NAME_SERVICE});
        typeIdMap.put("TransactionFactory", new String[]{TransactionFactoryHelper.id(), "TransactionFactory"});
        typeIdMap.put("CodeBase", new String[]{CodeBaseHelper.id(), "CodeBase"});
        localDomainId = ObjectKey.getLocalDomainIDInternal();
    }
}

