/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.IOException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import weblogic.corba.utils.ValueHandlerImpl;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.IIOPOutputStream;
import weblogic.kernel.Kernel;
import weblogic.utils.UnsyncStringBuffer;
import weblogic.utils.collections.NumericValueHashMap;
import weblogic.utils.collections.Stack;
import weblogic.utils.io.ObjectOutput;
import weblogic.utils.io.ObjectStreamClass;
import weblogic.utils.io.ObjectStreamField;

final class ObjectOutputStreamImpl
extends ObjectOutputStream {
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");
    private final IIOPOutputStream delegate;
    private Object value;
    private ObjectStreamClass osc;
    private boolean dfwoHandled = false;
    private int streamFormatState;
    private static final int STREAM_VERSION_1 = 0;
    private static final int STREAM_VERSION_2 = 1;
    private static final int STREAM_VERSION_2_UNTERMINATED = 2;
    private PutFieldImpl putFields;
    private IIOPOutputStream.Marker mark = new IIOPOutputStream.Marker();
    private Stack streamStack;

    ObjectOutputStreamImpl(IIOPOutputStream iIOPOutputStream, Object object, ObjectStreamClass objectStreamClass, byte by) throws IOException {
        this.delegate = iIOPOutputStream;
        this.value = object;
        this.osc = objectStreamClass;
        this.streamFormatState = by > 1 ? 1 : 0;
        this.delegate.setMark(this.mark);
    }

    void pushCurrent(Object object, ObjectStreamClass objectStreamClass, byte by) {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            ObjectOutputStreamImpl.p("pushCurrent(" + objectStreamClass + ")");
        }
        if (this.streamStack == null) {
            this.streamStack = new Stack();
        }
        this.streamStack.push((Object)new StreamEntry());
        this.value = object;
        this.osc = objectStreamClass;
        this.dfwoHandled = false;
        this.putFields = null;
        this.streamFormatState = by > 1 ? 1 : 0;
        this.delegate.setMark(this.mark);
    }

    private void popCurrent() {
        if (this.streamStack != null && this.streamStack.size() > 0) {
            StreamEntry streamEntry = (StreamEntry)this.streamStack.pop();
            this.value = streamEntry.value;
            this.osc = streamEntry.osc;
            this.dfwoHandled = streamEntry.dfwoHandled;
            this.putFields = streamEntry.putFields;
            this.streamFormatState = streamEntry.streamFormatState;
            this.mark = streamEntry.mark;
        } else {
            this.value = null;
            this.osc = null;
        }
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            ObjectOutputStreamImpl.p("popCurrent(" + this.osc + ")");
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.handleOptionalData();
        this.delegate.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.handleOptionalData();
        this.delegate.write(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        this.handleOptionalData();
        this.delegate.write(n);
    }

    public void writeInt(int n) throws IOException {
        this.handleOptionalData();
        this.delegate.writeInt(n);
    }

    public void writeUTF(String string) throws IOException {
        this.handleOptionalData();
        this.delegate.writeUTF(string);
    }

    public void writeLong(long l) throws IOException {
        this.handleOptionalData();
        this.delegate.writeLong(l);
    }

    public void writeByte(int n) throws IOException {
        this.handleOptionalData();
        this.delegate.writeByte(n);
    }

    public void writeShort(int n) throws IOException {
        this.handleOptionalData();
        this.delegate.writeShort(n);
    }

    public void writeBytes(String string) throws IOException {
        this.handleOptionalData();
        this.delegate.writeBytes(string);
    }

    public void writeFloat(float f) throws IOException {
        this.handleOptionalData();
        this.delegate.writeFloat(f);
    }

    public void writeChar(int n) throws IOException {
        this.handleOptionalData();
        this.delegate.writeChar(n);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.handleOptionalData();
        this.delegate.writeBoolean(bl);
    }

    public void writeDouble(double d) throws IOException {
        this.handleOptionalData();
        this.delegate.writeDouble(d);
    }

    public void writeChars(String string) throws IOException {
        this.handleOptionalData();
        this.delegate.writeChars(string);
    }

    protected final void writeObjectOverride(Object object) throws IOException {
        this.handleOptionalData();
        this.delegate.writeObject(object);
    }

    public void writeUnshared(Object object) throws IOException {
        this.handleOptionalData();
        this.delegate.writeObject(object);
    }

    public void defaultWriteObject() throws IOException {
        if (this.value == null) {
            throw new NotActiveException("Not in writeObject()");
        }
        if (this.dfwoHandled) {
            throw new IOException("Called defaultWriteObject()/writeFields() twice or after writing optional data.");
        }
        this.delegate.write_octet((byte)1);
        this.dfwoHandled = true;
        this.osc.writeFields(this.value, (ObjectOutput)this.delegate);
    }

    public ObjectOutputStream.PutField putFields() throws IOException {
        if (this.value == null) {
            throw new NotActiveException("Not in writeObject()");
        }
        if (this.putFields == null) {
            this.putFields = new PutFieldImpl();
        }
        return this.putFields;
    }

    public void writeFields() throws IOException {
        if (this.value == null || this.putFields == null) {
            throw new NotActiveException("Not in writeObject()");
        }
        this.putFields.write();
    }

    private void handleOptionalData() {
        if (!this.dfwoHandled) {
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                ObjectOutputStreamImpl.p("handleOptionalData() at " + this.delegate.pos());
            }
            this.delegate.write_octet((byte)0);
            this.dfwoHandled = true;
        }
        if (this.streamFormatState == 1) {
            String string = new UnsyncStringBuffer("RMI:org.omg.custom.").append(ValueHandlerImpl.getRepositoryID(this.osc.forClass()).substring(4)).toString();
            this.delegate.start_value(string);
            this.streamFormatState = 2;
        }
    }

    public void reset() throws IOException {
        this.delegate.restoreMark(this.mark);
    }

    public void flush() throws IOException {
    }

    public void drain() throws IOException {
    }

    public void close() throws IOException {
        if (!this.dfwoHandled) {
            this.delegate.write_octet((byte)0);
        }
        if (this.streamFormatState == 1) {
            this.delegate.write_long(0);
        } else if (this.streamFormatState == 2) {
            this.delegate.end_value();
        }
        this.popCurrent();
    }

    private static void p(String string) {
        System.out.println("<ObjectOutputStreamImpl>: " + string);
    }

    private final class PutFieldImpl
    extends ObjectOutputStream.PutField {
        private final HashMap fieldMap = new HashMap();
        private final NumericValueHashMap primitiveFieldMap = new NumericValueHashMap();

        private PutFieldImpl() {
        }

        public void put(String string, boolean bl) {
            this.primitiveFieldMap.put((Object)string, (long)(bl ? 1 : 0));
        }

        public void put(String string, byte by) {
            this.primitiveFieldMap.put((Object)string, (long)by);
        }

        public void put(String string, char c) {
            this.primitiveFieldMap.put((Object)string, (long)c);
        }

        public void put(String string, short s) {
            this.primitiveFieldMap.put((Object)string, (long)s);
        }

        public void put(String string, int n) {
            this.primitiveFieldMap.put((Object)string, (long)n);
        }

        public void put(String string, long l) {
            this.primitiveFieldMap.put((Object)string, l);
        }

        public void put(String string, float f) {
            this.primitiveFieldMap.put((Object)string, (long)Float.floatToIntBits(f));
        }

        public void put(String string, double d) {
            this.primitiveFieldMap.put((Object)string, Double.doubleToLongBits(d));
        }

        public void put(String string, Object object) {
            this.fieldMap.put(string, object);
        }

        public void write(java.io.ObjectOutput objectOutput) throws IOException {
            throw new NotSerializableException("PutField.write() is not supported");
        }

        private void write() throws IOException {
            if (ObjectOutputStreamImpl.this.dfwoHandled) {
                throw new IOException("Called defaultWriteObject()/writeFields() twice or after writing optional data.");
            }
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                ObjectOutputStreamImpl.p("PutField.write() writing defaultWriteObject at " + ObjectOutputStreamImpl.this.delegate.pos());
            }
            ObjectOutputStreamImpl.this.delegate.write_octet((byte)1);
            ObjectOutputStreamImpl.this.dfwoHandled = true;
            ObjectStreamField[] objectStreamFieldArray = ObjectOutputStreamImpl.this.osc.getFields();
            block8: for (int i = 0; i < objectStreamFieldArray.length; ++i) {
                ObjectStreamField objectStreamField = objectStreamFieldArray[i];
                if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                    ObjectOutputStreamImpl.p("Writing: " + objectStreamField);
                }
                switch (objectStreamField.getTypeCode()) {
                    case 'B': 
                    case 'Z': {
                        ObjectOutputStreamImpl.this.delegate.writeByte((byte)this.primitiveFieldMap.get((Object)objectStreamField.getName()));
                        continue block8;
                    }
                    case 'C': {
                        ObjectOutputStreamImpl.this.delegate.writeChar((char)this.primitiveFieldMap.get((Object)objectStreamField.getName()));
                        continue block8;
                    }
                    case 'S': {
                        ObjectOutputStreamImpl.this.delegate.writeShort((short)this.primitiveFieldMap.get((Object)objectStreamField.getName()));
                        continue block8;
                    }
                    case 'F': 
                    case 'I': {
                        ObjectOutputStreamImpl.this.delegate.writeInt((int)this.primitiveFieldMap.get((Object)objectStreamField.getName()));
                        continue block8;
                    }
                    case 'D': 
                    case 'J': {
                        ObjectOutputStreamImpl.this.delegate.writeLong(this.primitiveFieldMap.get((Object)objectStreamField.getName()));
                        continue block8;
                    }
                    case 'L': 
                    case '[': {
                        ObjectOutputStreamImpl.this.delegate.writeObject(this.fieldMap.get(objectStreamField.getName()), objectStreamField.getType());
                        continue block8;
                    }
                    default: {
                        throw new IOException("Bad typecode: " + objectStreamField.getTypeCode());
                    }
                }
            }
        }
    }

    private final class StreamEntry {
        private final Object value;
        private final ObjectStreamClass osc;
        private final boolean dfwoHandled;
        private final PutFieldImpl putFields;
        private final int streamFormatState;
        private final IIOPOutputStream.Marker mark = new IIOPOutputStream.Marker();

        private StreamEntry() {
            this.value = ObjectOutputStreamImpl.this.value;
            this.osc = ObjectOutputStreamImpl.this.osc;
            this.dfwoHandled = ObjectOutputStreamImpl.this.dfwoHandled;
            this.putFields = ObjectOutputStreamImpl.this.putFields;
            this.streamFormatState = ObjectOutputStreamImpl.this.streamFormatState;
            this.mark.chunk = ((ObjectOutputStreamImpl)ObjectOutputStreamImpl.this).mark.chunk;
            this.mark.pos = ((ObjectOutputStreamImpl)ObjectOutputStreamImpl.this).mark.pos;
        }
    }
}

