/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.IOException;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import java.security.AccessController;
import weblogic.corba.j2ee.workarea.WorkAreaContext;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.EndPoint;
import weblogic.iiop.IDLMsgOutput;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IOR;
import weblogic.iiop.InboundResponseImpl;
import weblogic.iiop.ReplyMessage;
import weblogic.iiop.RequestMessage;
import weblogic.iiop.VendorInfoCluster;
import weblogic.iiop.VendorInfoTrace;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.ObjectIO;
import weblogic.rmi.spi.AsyncCallback;
import weblogic.rmi.spi.InboundResponse;
import weblogic.rmi.spi.MsgOutput;
import weblogic.rmi.spi.OutboundRequest;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.TransactionInterceptor;
import weblogic.transaction.TransactionManager;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.workarea.WorkContextHelper;
import weblogic.workarea.WorkContextOutput;
import weblogic.workarea.spi.WorkContextMapInterceptor;

public final class OutboundRequestImpl
implements OutboundRequest {
    MsgOutput msgOutput;
    private final EndPoint endPoint;
    private final RequestMessage request;
    private RuntimeMethodDescriptor md;
    private Object[] args;
    private boolean rmiType;
    private static final DebugCategory debugTransport = Debug.getCategory((String)"weblogic.iiop.transport");
    private static final DebugLogger debugIIOPTransport = DebugLogger.getDebugLogger((String)"DebugIIOPTransport");
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    OutboundRequestImpl(EndPoint endPoint, RequestMessage requestMessage, boolean bl, RuntimeMethodDescriptor runtimeMethodDescriptor) {
        this.rmiType = bl;
        this.msgOutput = bl ? requestMessage.getOutputStream() : new IDLMsgOutput(requestMessage.getOutputStream());
        this.endPoint = endPoint;
        this.request = requestMessage;
        endPoint.setSubject(requestMessage, SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId));
        this.md = runtimeMethodDescriptor;
    }

    OutboundRequestImpl(RemoteReference remoteReference, RuntimeMethodDescriptor runtimeMethodDescriptor) {
        throw new AssertionError("not implemented");
    }

    public MsgOutput getMsgOutput() {
        this.request.flush();
        return this.msgOutput;
    }

    public void marshalCustomCallData() throws IOException {
        this.flush();
    }

    public weblogic.rmi.spi.EndPoint getEndPoint() {
        return this.endPoint;
    }

    public void marshalArgs(Object[] objectArray) throws MarshalException {
        this.args = objectArray;
    }

    private void flush() throws MarshalException {
        try {
            Class[] classArray = this.md.getParameterTypes();
            short[] sArray = this.md.getParameterTypeAbbrevs();
            MsgOutput msgOutput = this.getMsgOutput();
            if (classArray.length == 0) {
                return;
            }
            for (int i = 0; i < this.args.length; ++i) {
                ObjectIO.writeObject((MsgOutput)msgOutput, (Object)this.args[i], (Class)classArray[i], (short)sArray[i]);
            }
        }
        catch (IOException iOException) {
            throw new MarshalException("failed to marshal " + this.md.getSignature(), iOException);
        }
    }

    public void sendOneWay() throws RemoteException {
        if (debugTransport.isEnabled() || debugIIOPTransport.isDebugEnabled()) {
            IIOPLogger.logDebugTransport((String)("REQUEST(" + this.request.getRequestID() + "): oneway invoke " + this.request.getOperationName() + "()"));
        }
        this.request.setOneWay();
        this.flush();
        this.endPoint.send(this.request.getOutputStream());
    }

    public InboundResponse sendReceive() throws Throwable {
        this.request.setTimeout(this.md.getTimeOut());
        if (debugTransport.isEnabled() || debugIIOPTransport.isDebugEnabled()) {
            IIOPLogger.logDebugTransport((String)("REQUEST(" + this.request.getRequestID() + "): timeout " + this.md.getTimeOut() + "ms : remote invoke " + this.request.getOperationName() + "()"));
        }
        this.flush();
        ReplyMessage replyMessage = (ReplyMessage)this.endPoint.sendReceive(this.request, this.request.getFlags());
        IOR iOR = this.request.getIOR();
        InboundResponseImpl inboundResponseImpl = new InboundResponseImpl(this.endPoint, replyMessage, this.rmiType, this.md, this.args, iOR == null ? null : iOR.getCodebase());
        OutboundRequestImpl.receivedTxResponse(inboundResponseImpl.getTxContext());
        return inboundResponseImpl;
    }

    public void sendAsync(AsyncCallback asyncCallback) throws RemoteException {
        this.flush();
    }

    public void transferThreadLocalContext() throws IOException {
        WorkContextMapInterceptor workContextMapInterceptor = WorkContextHelper.getWorkContextHelper().getLocalInterceptor();
        if (workContextMapInterceptor != null) {
            WorkContextOutput workContextOutput = WorkAreaContext.createOutputStream(this.endPoint);
            workContextMapInterceptor.sendRequest(workContextOutput, 4);
            this.endPoint.setMessageServiceContext(this.request, new WorkAreaContext(workContextOutput));
        }
    }

    public void setTimeOut(int n) {
        this.request.setTimeout(n);
    }

    static void receivedTxResponse(Object object) throws RemoteException {
        TransactionManager transactionManager = (TransactionManager)TransactionHelper.getTransactionHelper().getTransactionManager();
        TransactionInterceptor transactionInterceptor = transactionManager.getInterceptor();
        transactionInterceptor.receiveResponse(object);
    }

    public void setTxContext(Object object) {
        this.endPoint.setOutboundRequestTxContext(this.request, object);
    }

    public void setReplicaInfo(Object object) throws IOException {
        if (object != null) {
            this.endPoint.setMessageServiceContext(this.request, new VendorInfoCluster(object));
        }
    }

    public void setActivationID(Object object) throws IOException {
    }

    public void setContext(int n, Object object) throws IOException {
        if (object == null) {
            return;
        }
        switch (n) {
            case 4: {
                this.endPoint.setMessageServiceContext(this.request, new VendorInfoTrace((byte[])object));
                break;
            }
        }
    }

    public void setRuntimeMethodDescriptor(RuntimeMethodDescriptor runtimeMethodDescriptor) throws IOException {
    }

    public RequestMessage getRequest() {
        return this.request;
    }

    public void close() throws IOException {
        this.msgOutput.close();
    }
}

