/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import weblogic.corba.j2ee.workarea.WorkAreaContext;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.EndPoint;
import weblogic.iiop.IDLMsgOutput;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.InboundRequest;
import weblogic.iiop.OutboundResponse;
import weblogic.iiop.ReplyMessage;
import weblogic.iiop.ReplyStatusConstants;
import weblogic.iiop.UnknownExceptionInfo;
import weblogic.iiop.Utils;
import weblogic.iiop.VendorInfoCluster;
import weblogic.kernel.Kernel;
import weblogic.rmi.RMILogger;
import weblogic.rmi.spi.MsgOutput;
import weblogic.transaction.TxHelper;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.workarea.WorkContextHelper;
import weblogic.workarea.WorkContextOutput;
import weblogic.workarea.spi.WorkContextMapInterceptor;

final class OutboundResponseImpl
implements ReplyStatusConstants,
OutboundResponse,
ResponseHandler {
    private static final int TYPE_SYSTEM_EXCEPTION = 0;
    private static final int TYPE_USER_EXCEPTION = 1;
    private static final int TYPE_UNCHECKED_EXCEPTION = 2;
    private static final int TYPE_REMOTE_EXCEPTION = 3;
    private static final int TYPE_CHECKED_EXCEPTION = 4;
    private static final DebugCategory debugTransport = Debug.getCategory((String)"weblogic.iiop.transport");
    private static final DebugCategory debugMarshal = Debug.getCategory((String)"weblogic.iiop.marshal");
    private static final DebugLogger debugIIOPTransport = DebugLogger.getDebugLogger((String)"DebugIIOPTransport");
    private static final DebugLogger debugIIOPMarshal = DebugLogger.getDebugLogger((String)"DebugIIOPMarshal");
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");
    private final EndPoint endPoint;
    private ReplyMessage reply;
    private final Method replyingTo;
    private MsgOutput msgOutput;
    private boolean pending = false;
    private boolean contextsMarshaled = false;
    private InboundRequest requestForReponseHandler;

    public OutboundResponseImpl(EndPoint endPoint, ReplyMessage replyMessage, Method method, boolean bl, boolean bl2) {
        this.msgOutput = bl ? replyMessage.getOutputStream() : new IDLMsgOutput(replyMessage.getOutputStream());
        this.endPoint = endPoint;
        this.reply = replyMessage;
        this.replyingTo = method;
        this.pending = bl2;
    }

    public OutboundResponseImpl(EndPoint endPoint, ReplyMessage replyMessage) {
        this.endPoint = endPoint;
        this.reply = replyMessage;
        this.msgOutput = replyMessage.getOutputStream();
        this.replyingTo = null;
    }

    static void p(String string) {
        System.err.println("<OutboundResponseImpl> " + string);
    }

    public MsgOutput getMsgOutput() {
        this.reply.flush();
        return this.msgOutput;
    }

    public void send() throws RemoteException {
        try {
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled() || debugTransport.isEnabled() || debugIIOPTransport.isDebugEnabled()) {
                IIOPLogger.logDebugTransport((String)("REPLY(" + this.reply.getRequestID() + "): sending"));
            }
            this.reply.flush();
            if (this.pending) {
                this.endPoint.decrementPendingRequests();
            }
            this.endPoint.send(this.reply.getOutputStream());
        }
        catch (IOException iOException) {
            throw new MarshalException("IOException while sending", iOException);
        }
        finally {
            try {
                this.close();
            }
            catch (IOException iOException) {
                throw new MarshalException("IOException while closing", iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendThrowable(Throwable throwable) {
        this.reply.flush();
        if (this.pending) {
            this.endPoint.decrementPendingRequests();
        }
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled() || debugTransport.isEnabled() || debugIIOPTransport.isDebugEnabled()) {
            IIOPLogger.logDebugTransport((String)("REPLY(" + this.reply.getRequestID() + "): sending EXCEPTION(" + throwable.getClass().getName() + ")"));
        }
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled() || debugMarshal.isEnabled() || debugIIOPMarshal.isDebugEnabled()) {
            RMILogger.logException((String)"sending exception", (Throwable)throwable);
        }
        try {
            switch (this.getExceptionType(throwable)) {
                case 0: {
                    if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                        OutboundResponseImpl.p("writeSystemException " + throwable.getClass());
                    }
                    this.writeSystemException((SystemException)throwable);
                    break;
                }
                case 3: {
                    SystemException systemException = Utils.mapRemoteToCORBAException((RemoteException)throwable);
                    if (systemException != null) {
                        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                            OutboundResponseImpl.p("writeSystemException (re) " + throwable.getClass() + " mapped to " + ((Object)((Object)systemException)).getClass());
                        }
                        this.writeSystemException(systemException);
                        break;
                    }
                }
                case 2: {
                    if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                        OutboundResponseImpl.p("writeUncheckedException " + throwable.getClass());
                    }
                    this.writeUncheckedException(throwable);
                    break;
                }
                case 1: {
                    if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                        OutboundResponseImpl.p("writeUserException " + throwable.getClass());
                    }
                    this.writeUserException((UserException)throwable);
                    break;
                }
                case 4: {
                    if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                        OutboundResponseImpl.p("writeCheckedException " + throwable.getClass());
                    }
                    this.writeCheckedException((Exception)throwable);
                    break;
                }
            }
        }
        catch (SystemException systemException) {
            IIOPLogger.logMarshalExceptionFailure((String)throwable.getClass().toString(), (Throwable)systemException);
            try {
                this.writeMarshalException();
            }
            catch (Throwable throwable2) {
                IIOPLogger.logCompleteMarshalExceptionFailure((String)throwable.getClass().toString(), (Throwable)throwable2);
                try {
                    this.close();
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
        }
        try {
            this.endPoint.send(this.reply.getOutputStream());
        }
        catch (Throwable throwable3) {
            try {
                try {
                    if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                        OutboundResponseImpl.p("failed endPoint.send (writeMarshalException)");
                    }
                    this.writeMarshalException();
                    if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                        OutboundResponseImpl.p("failed endPoint.send (send)");
                    }
                    this.endPoint.send(this.reply.getOutputStream());
                    if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                        OutboundResponseImpl.p("failed endPoint.send (done)");
                    }
                    IIOPLogger.logSendExceptionFailed((String)throwable.getClass().toString(), (Throwable)throwable3);
                    return;
                }
                catch (Throwable throwable4) {
                    IIOPLogger.logSendExceptionCompletelyFailed((String)throwable.getClass().toString(), (Throwable)throwable4);
                    try {
                        this.close();
                        return;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
            }
            catch (Throwable throwable5) {
                throw throwable5;
            }
            finally {
                try {
                    this.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            this.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void transferThreadLocalContext(weblogic.rmi.spi.InboundRequest inboundRequest) throws IOException {
        if (this.contextsMarshaled) {
            return;
        }
        this.contextsMarshaled = true;
        this.setTxContext(TxHelper.getTransactionManager().getInterceptor().sendResponse(inboundRequest.getTxContext()));
        WorkContextMapInterceptor workContextMapInterceptor = WorkContextHelper.getWorkContextHelper().getLocalInterceptor();
        if (workContextMapInterceptor != null) {
            WorkContextOutput workContextOutput = WorkAreaContext.createOutputStream(this.endPoint);
            workContextMapInterceptor.sendResponse(workContextOutput, 4);
            this.endPoint.setMessageServiceContext(this.reply, new WorkAreaContext(workContextOutput));
        }
    }

    public void setTxContext(Object object) {
        this.endPoint.setOutboundResponseTxContext(this.reply, object);
    }

    public void setContext(int n, Object object) {
    }

    public void setReplicaInfo(Object object) {
        if (object != null) {
            this.endPoint.setMessageServiceContext(this.reply, new VendorInfoCluster(object));
        } else {
            this.reply.removeServiceContext(1111834883);
        }
    }

    private int getExceptionType(Throwable throwable) {
        if (throwable instanceof SystemException) {
            return 0;
        }
        if (throwable instanceof UserException) {
            return 1;
        }
        if (throwable instanceof RuntimeException || throwable instanceof Error) {
            return 2;
        }
        if (throwable instanceof RemoteException) {
            return 3;
        }
        return 4;
    }

    private void writeUserException(UserException userException) {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            OutboundResponseImpl.p("writeUserException(" + ((Object)((Object)userException)).getClass().getName() + ")");
        }
        IIOPOutputStream iIOPOutputStream = (IIOPOutputStream)this.createExceptionReply();
        iIOPOutputStream.write_IDLEntity((Object)userException, ((Object)((Object)userException)).getClass());
    }

    private Class getDeclaredException(Class clazz) {
        if (this.replyingTo == null) {
            return clazz;
        }
        Class<?>[] classArray = this.replyingTo.getExceptionTypes();
        Class<?> clazz2 = null;
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].isAssignableFrom(clazz) || classArray[i].equals(RemoteException.class) || clazz2 != null && !clazz2.isAssignableFrom(classArray[i])) continue;
            clazz2 = classArray[i];
        }
        if (clazz2 == null) {
            clazz2 = clazz;
        }
        return clazz2;
    }

    private void writeCheckedException(Exception exception) {
        this.reply = this.createReplyForUserException();
        this.reply.flush();
        IIOPOutputStream iIOPOutputStream = this.reply.getOutputStream();
        Class clazz = this.getDeclaredException(exception.getClass());
        String string = Utils.getIDFromException(clazz);
        iIOPOutputStream.write_string(string);
        iIOPOutputStream.write_value((Serializable)exception, clazz);
    }

    private void writeUncheckedException(Throwable throwable) {
        this.reply = this.createReplyForSystemException();
        this.reply.addExceptionServiceContext(new UnknownExceptionInfo(throwable));
        this.reply.flush();
        IIOPOutputStream iIOPOutputStream = this.reply.getOutputStream();
        iIOPOutputStream.write_string(Utils.getRepositoryID(UNKNOWN.class));
        iIOPOutputStream.write_long(0);
        iIOPOutputStream.write_long(CompletionStatus.COMPLETED_MAYBE.value());
    }

    private void writeSystemException(SystemException systemException) {
        this.reply = this.createReplyForSystemException();
        this.reply.flush();
        IIOPOutputStream iIOPOutputStream = this.reply.getOutputStream();
        String string = Utils.getRepositoryID(((Object)((Object)systemException)).getClass());
        iIOPOutputStream.write_string(string);
        iIOPOutputStream.write_long(systemException.minor);
        iIOPOutputStream.write_long(systemException.completed.value());
    }

    private void writeMarshalException() {
        this.reply = this.createReplyForSystemException();
        this.reply.flush();
        IIOPOutputStream iIOPOutputStream = this.reply.getOutputStream();
        String string = Utils.getRepositoryID(MARSHAL.class);
        iIOPOutputStream.write_string(string);
        iIOPOutputStream.write_long(0);
        iIOPOutputStream.write_long(CompletionStatus.COMPLETED_MAYBE.value());
    }

    public void close() throws IOException {
        this.msgOutput.close();
    }

    public ResponseHandler createResponseHandler(InboundRequest inboundRequest) {
        this.requestForReponseHandler = inboundRequest;
        return this;
    }

    public OutputStream createExceptionReply() {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            OutboundResponseImpl.p("createExceptionReply()");
        }
        this.reply = this.createReplyForUserException();
        try {
            this.transferThreadLocalContext(this.requestForReponseHandler);
        }
        catch (IOException iOException) {
            throw Utils.mapToCORBAException(iOException);
        }
        this.reply.flush();
        return this.reply.getOutputStream();
    }

    public OutputStream createReply() {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            OutboundResponseImpl.p("createReply()");
        }
        try {
            this.transferThreadLocalContext(this.requestForReponseHandler);
        }
        catch (IOException iOException) {
            throw Utils.mapToCORBAException(iOException);
        }
        this.reply.flush();
        return this.reply.getOutputStream();
    }

    private ReplyMessage createReplyForUserException() {
        return new ReplyMessage(this.endPoint, this.reply, 1);
    }

    private ReplyMessage createReplyForSystemException() {
        return new ReplyMessage(this.endPoint, this.reply, 2);
    }
}

