/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.IOException;
import java.net.ProtocolException;
import java.net.Socket;
import weblogic.iiop.MuxableSocketIIOP;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolHandler;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.server.channels.ServerChannelImpl;
import weblogic.socket.MuxableSocket;
import weblogic.socket.SocketLogger;
import weblogic.utils.io.Chunk;

public class ProtocolHandlerIIOP
implements ProtocolHandler {
    protected static final String PROTOCOL_NAME = "GIOP";
    private static final ProtocolHandler theOne = new ProtocolHandlerIIOP();
    public static final Protocol PROTOCOL_IIOP = ProtocolManager.createProtocol((byte)4, (String)"iiop", (String)"iiop", (boolean)false, (ProtocolHandler)ProtocolHandlerIIOP.getProtocolHandler());

    public static ProtocolHandler getProtocolHandler() {
        return theOne;
    }

    public ServerChannel getDefaultServerChannel() {
        return ChannelInitializer.CHANNEL;
    }

    protected ProtocolHandlerIIOP() {
    }

    public int getHeaderLength() {
        return PROTOCOL_NAME.length();
    }

    public int getPriority() {
        return 0;
    }

    public Protocol getProtocol() {
        return PROTOCOL_IIOP;
    }

    public MuxableSocket createSocket(Chunk chunk, Socket socket, ServerChannel serverChannel) throws IOException {
        if (!MuxableSocketIIOP.isEnabled()) {
            SocketLogger.logConnectionRejectedProtocol((String)serverChannel.getChannelName(), (String)serverChannel.getConfiguredProtocol());
            throw new ProtocolException("IIOP is disabled");
        }
        MuxableSocketIIOP muxableSocketIIOP = new MuxableSocketIIOP(chunk, socket, serverChannel);
        return muxableSocketIIOP;
    }

    public boolean claimSocket(Chunk chunk) {
        return this.claimSocket(chunk, PROTOCOL_NAME);
    }

    protected boolean claimSocket(Chunk chunk, String string) {
        int n = string.length();
        if (chunk.end < n) {
            return false;
        }
        byte[] byArray = chunk.buf;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static final class ChannelInitializer {
        private static final ServerChannel CHANNEL = ServerChannelImpl.createDefaultServerChannel(PROTOCOL_IIOP);

        private ChannelInitializer() {
        }
    }
}

