/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.IOException;
import java.net.ProtocolException;
import java.net.Socket;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.MuxableSocketIIOP;
import weblogic.iiop.MuxableSocketIIOPS;
import weblogic.iiop.ProtocolHandlerIIOP;
import weblogic.protocol.Protocol;
import weblogic.protocol.ProtocolHandler;
import weblogic.protocol.ProtocolManager;
import weblogic.protocol.ServerChannel;
import weblogic.server.channels.ServerChannelImpl;
import weblogic.socket.MuxableSocket;
import weblogic.utils.io.Chunk;

public class ProtocolHandlerIIOPS
extends ProtocolHandlerIIOP {
    private static final ProtocolHandler theOne = new ProtocolHandlerIIOPS();
    public static final Protocol PROTOCOL_IIOPS = ProtocolManager.createProtocol((byte)5, (String)"iiops", (String)"iiops", (boolean)true, (ProtocolHandler)ProtocolHandlerIIOPS.getProtocolHandler());

    public static ProtocolHandler getProtocolHandler() {
        return theOne;
    }

    private ProtocolHandlerIIOPS() {
    }

    public final ServerChannel getDefaultServerChannel() {
        return ChannelInitializer.CHANNEL;
    }

    public MuxableSocket createSocket(Chunk chunk, Socket socket, ServerChannel serverChannel) throws IOException {
        if (!MuxableSocketIIOP.isEnabled()) {
            IIOPLogger.logConnectionRejected();
            throw new ProtocolException("IIOPS is disabled");
        }
        MuxableSocketIIOPS muxableSocketIIOPS = new MuxableSocketIIOPS(chunk, socket, serverChannel);
        return muxableSocketIIOPS.getSocketFilter();
    }

    public Protocol getProtocol() {
        return PROTOCOL_IIOPS;
    }

    public boolean claimSocket(Chunk chunk) {
        return this.claimSocket(chunk, "GIOP");
    }

    private static final class ChannelInitializer {
        private static final ServerChannel CHANNEL = ServerChannelImpl.createDefaultServerChannel(PROTOCOL_IIOPS);

        private ChannelInitializer() {
        }
    }
}

