/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.IDLEntity;
import weblogic.corba.utils.RepositoryId;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.CodeSet;
import weblogic.iiop.EndPoint;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.IOR;
import weblogic.iiop.Message;
import weblogic.iiop.MessageHeader;
import weblogic.iiop.MessageTypeConstants;
import weblogic.iiop.RequestMessage;
import weblogic.iiop.SendingContextRunTime;
import weblogic.iiop.ServiceContext;
import weblogic.iiop.ServiceContextList;
import weblogic.iiop.UnknownExceptionInfo;
import weblogic.iiop.Utils;
import weblogic.iiop.VendorInfo;
import weblogic.iiop.csi.SASServiceContext;
import weblogic.kernel.Kernel;

public final class ReplyMessage
extends Message
implements MessageTypeConstants {
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");
    private int reply_status;
    private RepositoryId exceptionId;
    private int minorCode;
    private CompletionStatus completionStatus;
    private Throwable throwable;
    private IOR ior;

    public ReplyMessage(EndPoint endPoint, MessageHeader messageHeader, IIOPInputStream iIOPInputStream) {
        this.endPoint = endPoint;
        this.msgHdr = messageHeader;
        this.inputStream = iIOPInputStream;
        if (!this.isFragmented()) {
            this.flush();
        } else {
            this.request_id = iIOPInputStream.peek_long();
        }
    }

    public ReplyMessage(EndPoint endPoint, MessageHeader messageHeader) {
        this.endPoint = endPoint;
        this.msgHdr = messageHeader;
        this.addContexts();
    }

    public ReplyMessage(EndPoint endPoint, RequestMessage requestMessage, ServiceContextList serviceContextList, IOR iOR) {
        this(endPoint, requestMessage, serviceContextList, 3);
        this.ior = iOR;
    }

    private final void addContexts() {
        if (!this.endPoint.getFlag(2)) {
            this.addServiceContext(SendingContextRunTime.getSendingContextRuntime());
            this.endPoint.setFlag(2);
        }
        if (!this.endPoint.getFlag(4)) {
            this.addServiceContext(VendorInfo.VENDOR_INFO);
            this.endPoint.setFlag(4);
        }
    }

    public ReplyMessage(EndPoint endPoint, RequestMessage requestMessage, ServiceContextList serviceContextList, int n) {
        this(endPoint, requestMessage.getRequestID(), requestMessage.getMinorVersion(), serviceContextList, n, requestMessage.getMaxStreamFormatVersion());
    }

    public ReplyMessage(EndPoint endPoint, ReplyMessage replyMessage, int n) {
        this(endPoint, replyMessage.getRequestID(), replyMessage.getMinorVersion(), replyMessage.getServiceContexts(), n, replyMessage.getMaxStreamFormatVersion());
    }

    private ReplyMessage(EndPoint endPoint, int n, int n2, ServiceContextList serviceContextList, int n3, byte by) {
        super(serviceContextList);
        this.endPoint = endPoint;
        this.msgHdr = new MessageHeader(1, n2);
        this.request_id = n;
        this.reply_status = n3;
        this.setMaxStreamFormatVersion(by);
        this.addContexts();
    }

    public IOR getIOR() {
        return this.ior;
    }

    public final int getReplyStatus() {
        return this.reply_status;
    }

    void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public Throwable getThrowable() {
        if (this.throwable != null) {
            return this.throwable;
        }
        switch (this.reply_status) {
            case 2: {
                try {
                    SystemException systemException = (SystemException)((Object)Utils.getClassFromID(this.exceptionId).newInstance());
                    systemException.minor = this.minorCode;
                    systemException.completed = this.completionStatus;
                    this.throwable = systemException;
                }
                catch (Exception exception) {
                    this.throwable = new INTERNAL("Bad SystemException: " + this.exceptionId, 0, CompletionStatus.COMPLETED_MAYBE);
                }
                break;
            }
            case 1: {
                IIOPInputStream iIOPInputStream = this.getInputStream();
                Class clazz = Utils.getClassFromID(this.exceptionId);
                if (clazz == null) {
                    this.throwable = new INTERNAL("Bad UserException: " + this.exceptionId, 0, CompletionStatus.COMPLETED_MAYBE);
                    break;
                }
                if (IDLEntity.class.isAssignableFrom(clazz)) {
                    this.throwable = (Throwable)iIOPInputStream.read_IDLEntity(clazz);
                    break;
                }
                iIOPInputStream.read_string();
                this.throwable = (Throwable)iIOPInputStream.read_value(clazz);
                break;
            }
        }
        return this.throwable;
    }

    public Throwable getMappedThrowable() {
        Throwable throwable = this.getThrowable();
        if (throwable instanceof SystemException) {
            return this.mapSystemException((SystemException)throwable);
        }
        return throwable;
    }

    public String getStatusAsString() {
        switch (this.reply_status) {
            case 2: {
                return "SYSTEM_EXCEPTION(" + this.exceptionId + ")";
            }
            case 1: {
                return "USER_EXCEPTION(" + this.exceptionId + ")";
            }
            case 3: {
                return "LOCATION_FORWARD";
            }
            case 4: {
                return "LOCATION_FORWARD_PERM";
            }
            case 5: {
                return "NEEDS_ADDRESSING_MODE";
            }
        }
        return "SUCCESS";
    }

    public final RepositoryId getExceptionId() {
        return this.exceptionId;
    }

    private final Throwable mapSystemException(SystemException systemException) {
        UnknownExceptionInfo unknownExceptionInfo;
        if (systemException instanceof UNKNOWN && (unknownExceptionInfo = (UnknownExceptionInfo)this.getServiceContext(9)) != null && unknownExceptionInfo.getNestedThrowable() != null) {
            Throwable throwable = unknownExceptionInfo.getNestedThrowable();
            if (throwable instanceof Error) {
                return new ServerError("Error occurred in server thread", (Error)throwable);
            }
            if (throwable instanceof RemoteException) {
                return new ServerException("RemoteException occurred in server thread", (Exception)throwable);
            }
            if (throwable instanceof RuntimeException) {
                return throwable;
            }
        }
        return Utils.mapSystemException(systemException);
    }

    public void write(IIOPOutputStream iIOPOutputStream) {
        this.msgHdr.write(iIOPOutputStream);
        switch (this.getMinorVersion()) {
            case 0: 
            case 1: {
                this.writeServiceContexts(iIOPOutputStream);
                iIOPOutputStream.write_long(this.request_id);
                iIOPOutputStream.write_long(this.reply_status);
                break;
            }
            case 2: {
                iIOPOutputStream.write_long(this.request_id);
                iIOPOutputStream.write_long(this.reply_status);
                this.writeServiceContexts(iIOPOutputStream);
            }
        }
        this.alignOnEightByteBoundry(iIOPOutputStream);
        if (this.reply_status == 3 && this.ior != null) {
            this.ior.write(iIOPOutputStream);
        }
    }

    public void read(IIOPInputStream iIOPInputStream) {
        switch (this.getMinorVersion()) {
            case 0: 
            case 1: {
                this.readServiceContexts(iIOPInputStream);
                this.request_id = iIOPInputStream.read_long();
                this.reply_status = iIOPInputStream.read_long();
                break;
            }
            case 2: {
                this.request_id = iIOPInputStream.read_long();
                this.reply_status = iIOPInputStream.read_long();
                this.readServiceContexts(iIOPInputStream);
            }
        }
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            ReplyMessage.p("request_id = " + this.request_id + ", reply_status = " + this.reply_status);
        }
        this.alignOnEightByteBoundry(iIOPInputStream);
        block4 : switch (this.reply_status) {
            case 2: {
                this.exceptionId = iIOPInputStream.read_repository_id();
                this.minorCode = iIOPInputStream.read_long();
                int n = iIOPInputStream.read_long();
                switch (n) {
                    case 0: {
                        this.completionStatus = CompletionStatus.COMPLETED_YES;
                        break block4;
                    }
                    case 1: {
                        this.completionStatus = CompletionStatus.COMPLETED_NO;
                        break block4;
                    }
                    case 2: {
                        this.completionStatus = CompletionStatus.COMPLETED_MAYBE;
                        break block4;
                    }
                }
                throw new INTERNAL("BAD completion status: " + n, 0, CompletionStatus.COMPLETED_MAYBE);
            }
            case 1: {
                iIOPInputStream.mark(0);
                this.exceptionId = iIOPInputStream.read_repository_id();
                iIOPInputStream.reset();
                if (!Kernel.DEBUG || !debugIIOPDetail.isDebugEnabled()) break;
                ReplyMessage.p("exceptionId = " + this.exceptionId);
                break;
            }
            case 3: 
            case 4: {
                if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                    ReplyMessage.p("reading ior");
                }
                this.ior = new IOR(iIOPInputStream, true);
                if (!Kernel.DEBUG || !debugIIOPDetail.isDebugEnabled()) break;
                ReplyMessage.p("ior = " + this.ior);
            }
        }
    }

    protected final void readServiceContexts(IIOPInputStream iIOPInputStream) {
        VendorInfo vendorInfo;
        SASServiceContext sASServiceContext;
        SendingContextRunTime sendingContextRunTime;
        this.serviceContexts.read(iIOPInputStream);
        CodeSet codeSet = (CodeSet)this.serviceContexts.getServiceContext(1);
        if (codeSet != null) {
            iIOPInputStream.setCodeSets(codeSet.getCharCodeSet(), codeSet.getWcharCodeSet());
        }
        if ((sendingContextRunTime = (SendingContextRunTime)this.serviceContexts.getServiceContext(6)) != null) {
            this.endPoint.setRemoteCodeBase(sendingContextRunTime.getCodeBase());
        }
        if ((sASServiceContext = (SASServiceContext)this.serviceContexts.getServiceContext(15)) != null) {
            sASServiceContext.handleSASReply(this.endPoint);
        }
        if (this.endPoint != null && this.endPoint.getPeerInfo() == null && (vendorInfo = (VendorInfo)this.serviceContexts.getServiceContext(1111834880)) != null) {
            this.endPoint.setPeerInfo(vendorInfo.getPeerInfo());
        }
    }

    public final void addExceptionServiceContext(ServiceContext serviceContext) {
        this.addServiceContext(serviceContext);
    }

    public boolean needsForwarding() {
        switch (this.reply_status) {
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    protected static void p(String string) {
        System.err.println("<ReplyMessage> " + string);
    }
}

