/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.IOException;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Principal;
import org.omg.CORBA.SystemException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.BiDirIIOPContextImpl;
import weblogic.iiop.CodeSet;
import weblogic.iiop.EndPoint;
import weblogic.iiop.EndPointManager;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.IOR;
import weblogic.iiop.MessageHeader;
import weblogic.iiop.MessageTypeConstants;
import weblogic.iiop.ObjectKey;
import weblogic.iiop.SendingContextRunTime;
import weblogic.iiop.SequencedRequestMessage;
import weblogic.iiop.ServiceContextList;
import weblogic.iiop.TargetAddress;
import weblogic.iiop.VendorInfo;
import weblogic.iiop.csi.CompoundSecMechList;
import weblogic.kernel.Kernel;
import weblogic.security.subject.AbstractSubject;

public final class RequestMessage
extends SequencedRequestMessage
implements MessageTypeConstants {
    private boolean response_expected;
    private IOR ior;
    private TargetAddress target;
    private ObjectKey object_key;
    private String operation;
    private Principal requesting_principal;
    private CompoundSecMechList mechList;
    private boolean isForeign;
    private static final Object NULL = new Object();
    private Object subject = NULL;
    private Object cachedTxContext;
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");

    public RequestMessage(EndPoint endPoint, MessageHeader messageHeader, IIOPInputStream iIOPInputStream) {
        this.msgHdr = messageHeader;
        this.endPoint = endPoint;
        this.inputStream = iIOPInputStream;
        if (endPoint != null) {
            iIOPInputStream.setCodeSets(endPoint.getCharCodeSet(), endPoint.getWcharCodeSet());
        }
        if (!this.isFragmented()) {
            this.flush();
        } else {
            this.request_id = iIOPInputStream.peek_long();
        }
    }

    public RequestMessage(EndPoint endPoint, IOR iOR, String string, boolean bl) {
        this.msgHdr = new MessageHeader(0, endPoint.getMinorVersion());
        this.endPoint = endPoint;
        this.ior = iOR;
        boolean bl2 = true;
        switch (iOR.getProfile().getMinorVersion()) {
            case 2: {
                if (!endPoint.getFlag(8)) {
                    this.addServiceContext(BiDirIIOPContextImpl.getContext());
                    this.flags |= 8;
                }
            }
            case 0: 
            case 1: {
                if (!endPoint.getFlag(4)) {
                    this.addServiceContext(VendorInfo.VENDOR_INFO);
                    this.flags |= 4;
                }
                if (!endPoint.getFlag(1) && iOR.isRemote()) {
                    if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                        RequestMessage.p("Using negotiated char codeset = " + Integer.toHexString(endPoint.getCharCodeSet()) + ", negotiated wchar codeset = " + Integer.toHexString(endPoint.getWcharCodeSet()));
                    }
                    this.addServiceContext(new CodeSet(endPoint.getCharCodeSet(), endPoint.getWcharCodeSet()));
                    this.flags |= 1;
                }
                if (endPoint.getFlag(2)) break;
                this.addServiceContext(SendingContextRunTime.getSendingContextRuntime());
                endPoint.setFlag(2);
            }
        }
        this.request_id = endPoint.getNextRequestID();
        this.response_expected = !bl;
        this.object_key = iOR.getProfile().getObjectKey();
        this.target = iOR.getProfile().getTargetAddress();
        this.operation = string;
        this.requesting_principal = null;
        this.mechList = (CompoundSecMechList)iOR.getProfile().getComponent(33);
        this.isForeign = iOR.isRemote();
        this.setMaxStreamFormatVersion(iOR.getProfile().getMaxStreamFormatVersion());
    }

    public final ServiceContextList getOutboundServiceContexts() {
        return this.serviceContexts.generateOutboundContexts();
    }

    public final ObjectKey getObjectKey() {
        return this.object_key;
    }

    public final IOR getIOR() {
        return this.ior;
    }

    public final String getOperationName() {
        return this.operation;
    }

    public final Principal getPrincipal() {
        return this.requesting_principal;
    }

    public boolean isOneWay() {
        return !this.response_expected;
    }

    public void setOneWay() {
        this.response_expected = false;
    }

    public AbstractSubject getSubject() {
        if (this.subject == NULL) {
            this.subject = this.endPoint.getSubject(this);
        }
        return (AbstractSubject)this.subject;
    }

    public void write(IIOPOutputStream iIOPOutputStream) throws SystemException {
        this.msgHdr.write(iIOPOutputStream);
        switch (this.getMinorVersion()) {
            case 0: 
            case 1: {
                this.writeServiceContexts(iIOPOutputStream);
                iIOPOutputStream.write_ulong(this.request_id);
                iIOPOutputStream.write_boolean(this.response_expected);
                if (this.getMinorVersion() == 1) {
                    this.produceMinorVersion1Padding(iIOPOutputStream);
                }
                this.object_key.write(iIOPOutputStream);
                iIOPOutputStream.write_string(this.operation);
                this.writeRequestingPrincipal(iIOPOutputStream);
                break;
            }
            case 2: {
                iIOPOutputStream.write_ulong(this.request_id);
                if (this.response_expected) {
                    iIOPOutputStream.write_octet((byte)3);
                } else {
                    iIOPOutputStream.write_octet((byte)0);
                }
                this.produceMinorVersion1Padding(iIOPOutputStream);
                this.target.write(iIOPOutputStream);
                iIOPOutputStream.write_string(this.operation);
                this.writeServiceContexts(iIOPOutputStream);
            }
        }
        this.alignOnEightByteBoundry(iIOPOutputStream);
    }

    private void produceMinorVersion1Padding(IIOPOutputStream iIOPOutputStream) {
        iIOPOutputStream.write_octet((byte)0);
        iIOPOutputStream.write_octet((byte)0);
        iIOPOutputStream.write_octet((byte)0);
    }

    private void writeRequestingPrincipal(IIOPOutputStream iIOPOutputStream) {
        if (this.requesting_principal != null) {
            iIOPOutputStream.write_Principal(this.requesting_principal);
        } else {
            iIOPOutputStream.write_long(0);
        }
    }

    public void read(IIOPInputStream iIOPInputStream) throws SystemException {
        switch (this.getMinorVersion()) {
            case 0: {
                this.readServiceContexts(iIOPInputStream);
                this.request_id = iIOPInputStream.read_ulong();
                this.response_expected = iIOPInputStream.read_boolean();
                this.object_key = new ObjectKey(iIOPInputStream);
                this.operation = iIOPInputStream.read_string();
                this.requesting_principal = iIOPInputStream.read_Principal();
                break;
            }
            case 1: {
                this.readServiceContexts(iIOPInputStream);
                this.request_id = iIOPInputStream.read_ulong();
                this.response_expected = iIOPInputStream.read_boolean();
                iIOPInputStream.read_octet();
                iIOPInputStream.read_octet();
                iIOPInputStream.read_octet();
                this.object_key = new ObjectKey(iIOPInputStream);
                this.operation = iIOPInputStream.read_string();
                this.requesting_principal = iIOPInputStream.read_Principal();
                break;
            }
            case 2: {
                this.request_id = iIOPInputStream.read_ulong();
                byte by = iIOPInputStream.read_octet();
                switch (by) {
                    case 0: {
                        this.response_expected = false;
                        break;
                    }
                    case 3: {
                        this.response_expected = true;
                        break;
                    }
                    default: {
                        throw new MARSHAL("Unknown response_expected flags: " + by);
                    }
                }
                iIOPInputStream.read_octet();
                iIOPInputStream.read_octet();
                iIOPInputStream.read_octet();
                this.target = new TargetAddress(iIOPInputStream);
                this.object_key = this.target.object_key;
                this.operation = iIOPInputStream.read_string();
                if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                    RequestMessage.p("operation= " + this.operation);
                }
                this.readServiceContexts(iIOPInputStream);
            }
        }
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            RequestMessage.p("request_id = " + this.request_id + " response_expected = " + this.response_expected + " operation = " + this.operation);
        }
        this.alignOnEightByteBoundry(iIOPInputStream);
    }

    public CompoundSecMechList getMechanismListForRequest() {
        return this.mechList;
    }

    public boolean isForeign() {
        return this.isForeign;
    }

    public final Object getCachedTxContext() {
        return this.cachedTxContext;
    }

    public final void setCachedTxContext(Object object) {
        this.cachedTxContext = object;
    }

    public void redirect(IOR iOR) throws IOException {
        this.endPoint = EndPointManager.findOrCreateEndPoint(iOR);
        this.object_key = iOR.getProfile().getObjectKey();
    }

    public final void close() {
        super.close();
        this.response_expected = false;
        this.target.reset();
        this.object_key = null;
        this.operation = null;
        this.requesting_principal = null;
        this.mechList = null;
        this.isForeign = false;
        this.cachedTxContext = null;
    }

    protected static void p(String string) {
        System.err.println("<RequestMessage> " + string);
    }
}

