/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.security.AccessController;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.TaggedComponent;
import weblogic.management.configuration.SSLMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class SSLSecTransComponent
extends TaggedComponent {
    private int port;
    private short supports;
    private short requires;
    private static SSLSecTransComponent singleton;
    public static final int TAG_SSL_SEC_TRANS = 20;
    public static final short IOPSEC_NOPROTECTION = 1;
    public static final short IOPSEC_INTEGRITY = 2;
    public static final short IOPSEC_CONFIDENTIALITY = 4;
    public static final short IOPSEC_DETECTREPLAY = 8;
    public static final short IOPSEC_DETECTMISORDERING = 16;
    public static final short IOPSEC_ESTABLISHTRUSTINTARGET = 32;
    public static final short IOPSEC_ESTABLISHTRUSTINCLIENT = 64;
    public static final short IOPSEC_NODELEGATION = 128;
    public static final short IOPSEC_SIMPLEDELEGATION = 256;
    public static final short IOPSEC_COMPOSITEDELEGATION = 512;
    public static final short IOPSEC_IDENTITYASSERTION = 1024;
    public static final short IOPSEC_DELEGATIONBYCLIENT = 2048;
    public static final short IOP_SIGNED_FLAGS = 314;
    public static final short IOP_SEALED_FLAGS = 318;

    public static SSLSecTransComponent getSingleton() {
        return singleton == null ? SSLSecTransComponent.createSingleton() : singleton;
    }

    private static synchronized SSLSecTransComponent createSingleton() {
        if (singleton == null) {
            singleton = new SSLSecTransComponent();
        }
        return singleton;
    }

    private SSLSecTransComponent() {
        super(20);
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        SSLMBean sSLMBean = ManagementService.getRuntimeAccess(authenticatedSubject).getServer().getSSL();
        this.port = sSLMBean.getListenPort();
        boolean bl = false;
        boolean bl2 = false;
        String[] stringArray = sSLMBean.getCiphersuites();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                if (stringArray[i].indexOf("WITH_NULL") != -1) {
                    bl2 = true;
                    continue;
                }
                bl = true;
            }
        }
        this.supports = (short)318;
        this.requires = (short)314;
        if (!bl && stringArray != null) {
            this.supports = (short)314;
        }
        if (!bl2 && bl) {
            this.requires = (short)318;
        }
        if (sSLMBean.isClientCertificateEnforced()) {
            this.supports = (short)(this.supports | 0x40);
            this.requires = (short)(this.requires | 0x40);
        }
    }

    public SSLSecTransComponent(IIOPInputStream iIOPInputStream) {
        super(20);
        this.read(iIOPInputStream);
    }

    public final int getPort() {
        return this.port;
    }

    public final short getSupports() {
        return this.supports;
    }

    public final short getRequires() {
        return this.requires;
    }

    public final void read(IIOPInputStream iIOPInputStream) {
        long l = iIOPInputStream.startEncapsulation();
        this.supports = iIOPInputStream.read_short();
        this.requires = iIOPInputStream.read_short();
        this.port = iIOPInputStream.read_unsigned_short();
        iIOPInputStream.endEncapsulation(l);
    }

    public final void write(IIOPOutputStream iIOPOutputStream) {
        iIOPOutputStream.write_long(this.tag);
        long l = iIOPOutputStream.startEncapsulation();
        iIOPOutputStream.write_short(this.supports);
        iIOPOutputStream.write_short(this.requires);
        iIOPOutputStream.write_unsigned_short(this.port);
        iIOPOutputStream.endEncapsulation(l);
    }
}

