/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import weblogic.iiop.Message;
import weblogic.rmi.extensions.RequestTimeoutException;

public abstract class SequencedRequestMessage
extends Message {
    private Message reply;
    private Throwable t;
    protected int flags = 0;
    private static final int DEFAULT_TIMEOUT = Integer.getInteger("weblogic.iiop.requestTimeout", 0);
    private long timeout = DEFAULT_TIMEOUT;

    public final void setTimeout(long l) {
        if (l > 0L) {
            this.timeout = l;
        }
    }

    public final Message getReply() {
        return this.reply;
    }

    public final int getFlags() {
        return this.flags;
    }

    public final synchronized void notify(Message message) {
        this.reply = message;
        this.notify();
    }

    public final synchronized void notify(Throwable throwable) {
        this.t = throwable;
        this.notify();
    }

    public final synchronized void waitForData() throws Throwable {
        while (this.noReply()) {
            try {
                this.wait(this.timeout);
                if (!this.noReply()) continue;
                this.t = new RequestTimeoutException("Response timed out after: '" + this.timeout + "' milliseconds.");
                this.endPoint.removePendingResponse(this.request_id);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.t != null) {
            throw this.t;
        }
    }

    public final synchronized boolean pollResponse() {
        return !this.noReply();
    }

    private final boolean noReply() {
        return this.reply == null && this.t == null;
    }

    public void close() {
        super.close();
        this.reply = null;
        this.t = null;
    }
}

