/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import weblogic.corba.cos.transactions.PropagationContextImpl;
import weblogic.corba.idl.poa.MessagingPolicy;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.BiDirIIOPContextImpl;
import weblogic.iiop.CodeSet;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.SFVContext;
import weblogic.iiop.SendingContextRunTime;
import weblogic.iiop.UnknownExceptionInfo;
import weblogic.iiop.VendorInfo;
import weblogic.iiop.csi.SASServiceContext;
import weblogic.kernel.Kernel;

public class ServiceContext {
    public static final int TransactionService = 0;
    public static final int CodeSets = 1;
    public static final int ChainBypassCheck = 2;
    public static final int ChainBypassInfo = 3;
    public static final int LogicalThreadId = 4;
    public static final int BI_DIR_IIOP = 5;
    public static final int SendingContextRunTime = 6;
    public static final int INVOCATION_POLICIES = 7;
    public static final int FORWARDED_IDENTITY = 8;
    public static final int UnknownExceptionInfo = 9;
    public static final int SecurityAttributeService = 15;
    public static final int RMICustomMaxStreamFormat = 17;
    int context_id;
    protected byte[] context_data;
    protected static final boolean DEBUG = false;
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");

    public String toString() {
        return "ServiceContext: ContextId = " + ServiceContext.VMCIDToString(this.context_id);
    }

    public static String VMCIDToString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n >> 24 & 0xFF;
        stringBuffer.append(n2 < 32 || n2 > 126 ? "\\" + Integer.toString(n2) : Character.toString((char)n2));
        n2 = n >> 16 & 0xFF;
        stringBuffer.append(n2 < 32 || n2 > 126 ? "\\" + Integer.toString(n2) : Character.toString((char)n2));
        n2 = n >> 8 & 0xFF;
        stringBuffer.append(n2 < 32 || n2 > 126 ? "\\" + Integer.toString(n2) : Character.toString((char)n2));
        n2 = n & 0xFF;
        stringBuffer.append(n2 < 32 || n2 > 126 ? "\\" + Integer.toString(n2) : Character.toString((char)n2));
        return stringBuffer.toString();
    }

    protected ServiceContext(int n, IIOPInputStream iIOPInputStream) {
        this.context_id = n;
        this.read(iIOPInputStream);
    }

    public ServiceContext(int n, byte[] byArray) {
        this.context_id = n;
        this.context_data = byArray;
    }

    public ServiceContext(int n) {
        this(n, (byte[])null);
    }

    public ServiceContext() {
    }

    public int getContextId() {
        return this.context_id;
    }

    public byte[] getContextData() {
        return this.context_data;
    }

    public static ServiceContext readServiceContext(IIOPInputStream iIOPInputStream) {
        int n = iIOPInputStream.read_long();
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            ServiceContext.p("read(" + Integer.toHexString(n) + ")");
        }
        switch (n) {
            case 1: {
                return new CodeSet(iIOPInputStream);
            }
            case 9: {
                return new UnknownExceptionInfo(iIOPInputStream);
            }
            case 6: {
                return new SendingContextRunTime(iIOPInputStream);
            }
            case 15: {
                return new SASServiceContext(iIOPInputStream);
            }
            case 0: {
                return new PropagationContextImpl(iIOPInputStream);
            }
            case 5: {
                return new BiDirIIOPContextImpl(iIOPInputStream);
            }
            case 7: {
                return new MessagingPolicy(iIOPInputStream);
            }
            case 17: {
                return new SFVContext(iIOPInputStream);
            }
        }
        if ((n & 0xFFFFFF00) == 1111834880) {
            return VendorInfo.readServiceContext(n, iIOPInputStream);
        }
        return new ServiceContext(n, iIOPInputStream);
    }

    protected void readEncapsulation(IIOPInputStream iIOPInputStream) {
    }

    protected void writeEncapsulation(IIOPOutputStream iIOPOutputStream) {
    }

    public void write(IIOPOutputStream iIOPOutputStream) {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            ServiceContext.p("write(" + this.toString() + ")");
        }
        iIOPOutputStream.write_long(this.context_id);
        if (this.context_data == null) {
            iIOPOutputStream.write_long(0);
        } else {
            iIOPOutputStream.write_octet_sequence(this.context_data);
        }
    }

    public final void writeEncapsulatedContext(IIOPOutputStream iIOPOutputStream) {
        iIOPOutputStream.write_long(this.context_id);
        if (this.context_data != null) {
            iIOPOutputStream.write_octet_sequence(this.context_data);
        } else {
            long l = iIOPOutputStream.startEncapsulation();
            this.writeEncapsulation(iIOPOutputStream);
            iIOPOutputStream.endEncapsulation(l);
        }
    }

    public final void premarshal() {
        IIOPOutputStream iIOPOutputStream = new IIOPOutputStream();
        iIOPOutputStream.putEndian();
        this.writeEncapsulation(iIOPOutputStream);
        this.context_data = iIOPOutputStream.getBuffer();
        iIOPOutputStream.close();
    }

    protected final void read(IIOPInputStream iIOPInputStream) {
        this.context_data = iIOPInputStream.read_octet_sequence();
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            ServiceContext.p("read(" + this.toString() + ")");
        }
    }

    protected final void readEncapsulatedContext(IIOPInputStream iIOPInputStream) {
        long l = iIOPInputStream.startEncapsulation();
        if (l != 0L) {
            this.readEncapsulation(iIOPInputStream);
            iIOPInputStream.endEncapsulation(l);
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                ServiceContext.p("readEncapsulatedContext(" + this.toString() + ")");
            }
        }
    }

    protected static void p(String string) {
        System.err.println("<ServiceContext> " + string);
    }
}

