/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.ServiceContext;
import weblogic.iiop.csi.SASServiceContext;
import weblogic.kernel.Kernel;

public final class ServiceContextList {
    private static final int BASE_LIST_SIZE = 4;
    private static final int VI_FORWARD_OFFSET = 9;
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");
    private static final ServiceContext NULL_CONTEXT = new ServiceContext(-1);
    private long omgBitmask = 0L;
    private long beaBitmask = 0L;
    private int beaElems = 0;
    private int omgElems = 0;
    private int foreignElems = 0;
    private int size = 0;
    private ServiceContext[] beaContexts = new ServiceContext[4];
    private ServiceContext[] omgContexts = new ServiceContext[4];
    private ServiceContext[] foreignContexts;

    public void write(IIOPOutputStream iIOPOutputStream) {
        int n;
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            ServiceContextList.p("writing " + this.size + " ServiceContexts");
        }
        iIOPOutputStream.write_ulong(this.size);
        for (n = 0; n < this.omgElems; ++n) {
            if (this.omgContexts[n] == NULL_CONTEXT) continue;
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                ServiceContextList.p("write(" + this.omgContexts[n].toString() + ")");
            }
            this.omgContexts[n].write(iIOPOutputStream);
        }
        for (n = 0; n < this.beaElems; ++n) {
            if (this.beaContexts[n] == NULL_CONTEXT) continue;
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                ServiceContextList.p("write(" + this.beaContexts[n].toString() + ")");
            }
            this.beaContexts[n].write(iIOPOutputStream);
        }
        for (n = 0; n < this.foreignElems; ++n) {
            if (this.foreignContexts[n] == NULL_CONTEXT) continue;
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                ServiceContextList.p("write(" + this.foreignContexts[n].toString() + ")");
            }
            this.foreignContexts[n].write(iIOPOutputStream);
        }
    }

    protected final void read(IIOPInputStream iIOPInputStream) {
        int n = iIOPInputStream.read_ulong();
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            ServiceContextList.p("reading " + n + " ServiceContexts");
        }
        for (int i = 0; i < n; ++i) {
            ServiceContext serviceContext = ServiceContext.readServiceContext(iIOPInputStream);
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                ServiceContextList.p("reading " + serviceContext.toString());
            }
            this.addServiceContext(serviceContext);
        }
    }

    public final ServiceContext getServiceContext(int n) {
        if (this.size == 0) {
            return null;
        }
        if (n < 64) {
            if (this.omgElems == 0 || (this.omgBitmask & (long)(1 << n)) == 0L) {
                return null;
            }
            for (int i = 0; i < this.omgElems; ++i) {
                if (this.omgContexts[i].context_id != n) continue;
                return this.omgContexts[i];
            }
        } else if (n > 1111834880 && n < 1111834944) {
            if (this.beaElems == 0 || (this.beaBitmask & (long)(1 << n - 1111834880)) == 0L) {
                return null;
            }
            for (int i = 0; i < this.beaElems; ++i) {
                if (this.beaContexts[i].context_id != n) continue;
                return this.beaContexts[i];
            }
        } else {
            if (this.foreignElems == 0) {
                return null;
            }
            for (int i = 0; i < this.foreignElems; ++i) {
                if (this.foreignContexts[i].context_id != n) continue;
                return this.foreignContexts[i];
            }
        }
        return null;
    }

    public final void removeServiceContext(int n) {
        if (n < 64) {
            if (this.omgElems == 0 || (this.omgBitmask & (long)(1 << n)) == 0L) {
                return;
            }
            for (int i = 0; i < this.omgElems; ++i) {
                if (this.omgContexts[i].context_id != n) continue;
                this.omgContexts[i] = NULL_CONTEXT;
                --this.size;
            }
        } else if (n >= 1111834880 && n < 1111834944) {
            if (this.beaElems == 0 || (this.beaBitmask & (long)(1 << n - 1111834880)) == 0L) {
                return;
            }
            for (int i = 0; i < this.beaElems; ++i) {
                if (this.beaContexts[i].context_id != n) continue;
                this.beaContexts[i] = NULL_CONTEXT;
                --this.size;
            }
        } else {
            if (this.foreignElems == 0) {
                return;
            }
            for (int i = 0; i < this.foreignElems; ++i) {
                if (this.foreignContexts[i].context_id != n) continue;
                this.foreignContexts[i] = NULL_CONTEXT;
                --this.size;
            }
        }
    }

    public final void addServiceContext(ServiceContext serviceContext) {
        int n = serviceContext.context_id;
        ++this.size;
        if (n < 64) {
            if (this.omgElems == this.omgContexts.length) {
                this.omgContexts = this.growList(this.omgContexts, this.omgElems);
            }
            this.omgBitmask |= (long)(1 << n);
            this.omgContexts[this.omgElems++] = serviceContext;
        } else if (n > 1111834880 && n < 1111834944) {
            if (this.beaElems == this.beaContexts.length) {
                this.beaContexts = this.growList(this.beaContexts, this.beaElems);
            }
            this.beaBitmask |= (long)(1 << n - 1111834880);
            this.beaContexts[this.beaElems++] = serviceContext;
        } else {
            if (this.foreignContexts == null) {
                this.foreignContexts = new ServiceContext[4];
            } else if (this.foreignElems == this.foreignContexts.length) {
                this.foreignContexts = this.growList(this.foreignContexts, this.foreignElems);
            }
            this.foreignContexts[this.foreignElems++] = serviceContext;
        }
    }

    public final ServiceContextList generateOutboundContexts() {
        SASServiceContext sASServiceContext;
        ServiceContextList serviceContextList = new ServiceContextList();
        if ((this.beaBitmask & 0x200L) != 0L) {
            serviceContextList.beaContexts[serviceContextList.beaElems++] = this.getServiceContext(1111834889);
            ++serviceContextList.size;
        }
        if ((this.omgBitmask & 0x8000L) != 0L && (sASServiceContext = (SASServiceContext)this.getServiceContext(15)).getMsgType() == 0) {
            serviceContextList.addServiceContext(sASServiceContext.getCompleteEstablishContext());
        }
        return serviceContextList;
    }

    private final ServiceContext[] growList(ServiceContext[] serviceContextArray, int n) {
        ServiceContext[] serviceContextArray2 = new ServiceContext[serviceContextArray.length * 2];
        System.arraycopy(serviceContextArray, 0, serviceContextArray2, 0, n);
        return serviceContextArray2;
    }

    protected static void p(String string) {
        System.err.println("<ServiceContextList> " + string);
    }

    public final void reset() {
        this.beaElems = 0;
        this.omgElems = 0;
        this.foreignElems = 0;
        this.size = 0;
        this.omgBitmask = 0L;
        this.beaBitmask = 0L;
    }

    public String toString() {
        return "ServiceContextList: " + this.size + " elements";
    }
}

