/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.security.AccessController;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.ConnectionKey;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.ProtocolHandlerIIOPS;
import weblogic.iiop.TaggedComponent;
import weblogic.kernel.Kernel;
import weblogic.management.configuration.SSLMBean;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.Protocol;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.protocol.ServerIdentity;
import weblogic.rmi.internal.RuntimeDescriptor;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class TLSSecTransComponent
extends TaggedComponent {
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");
    private ConnectionKey[] addrs;
    private short supports;
    private short requires;
    private ServerIdentity target;
    public static final int TAG_SSL_SEC_TRANS = 36;
    public static final short IOPSEC_NOPROTECTION = 1;
    public static final short IOPSEC_INTEGRITY = 2;
    public static final short IOPSEC_CONFIDENTIALITY = 4;
    public static final short IOPSEC_DETECTREPLAY = 8;
    public static final short IOPSEC_DETECTMISORDERING = 16;
    public static final short IOPSEC_ESTABLISHTRUSTINTARGET = 32;
    public static final short IOPSEC_ESTABLISHTRUSTINCLIENT = 64;
    public static final short IOPSEC_NODELEGATION = 128;
    public static final short IOPSEC_SIMPLEDELEGATION = 256;
    public static final short IOPSEC_COMPOSITEDELEGATION = 512;
    public static final short IOPSEC_IDENTITYASSERTION = 1024;
    public static final short IOPSEC_DELEGATIONBYCLIENT = 2048;
    public static final short IOP_SIGNED_FLAGS = 2;
    public static final short IOP_SEALED_FLAGS = 6;

    public TLSSecTransComponent(String string, ServerIdentity serverIdentity, RuntimeDescriptor runtimeDescriptor) {
        super(36);
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        SSLMBean sSLMBean = ManagementService.getRuntimeAccess(authenticatedSubject).getServer().getSSL();
        ServerChannel serverChannel = ServerChannelManager.findLocalServerChannel((Protocol)ProtocolHandlerIIOPS.PROTOCOL_IIOPS);
        this.addrs = string == null ? new ConnectionKey[]{new ConnectionKey(serverChannel.getPublicAddress(), serverChannel.getPublicPort())} : new ConnectionKey[]{new ConnectionKey(string, sSLMBean.getListenPort())};
        this.target = serverIdentity;
        boolean bl = true;
        boolean bl2 = false;
        String[] stringArray = sSLMBean.getCiphersuites();
        if (stringArray != null && stringArray.length > 0) {
            bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                    TLSSecTransComponent.p("cipher suite " + stringArray[i]);
                }
                if (stringArray[i].indexOf("WITH_NULL") != -1) {
                    bl2 = true;
                    continue;
                }
                bl = true;
            }
        }
        this.supports = (short)38;
        this.requires = (short)2;
        if (!bl && stringArray != null) {
            this.supports = (short)2;
        }
        if (!bl2 && bl) {
            this.requires = (short)6;
        }
        if (sSLMBean.isClientCertificateEnforced()) {
            this.supports = (short)(this.supports | 0x40);
            this.requires = (short)(this.requires | 0x40);
        }
        if (runtimeDescriptor != null) {
            String string2;
            String string3 = runtimeDescriptor.getClientCertAuthentication();
            if (string3 != null) {
                if (string3.equals("supported")) {
                    this.supports = (short)(this.supports | 0x40);
                } else if (string3.equals("required")) {
                    this.supports = (short)(this.supports | 0x40);
                    this.requires = (short)(this.requires | 0x40);
                }
            }
            if ((string2 = runtimeDescriptor.getConfidentiality()) != null && string2.equals("required") && bl2) {
                this.requires = (short)(this.requires | 6);
            }
        }
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            TLSSecTransComponent.p("TLS sec supports = " + this.supports + " requires = " + this.requires);
        }
    }

    public TLSSecTransComponent(IIOPInputStream iIOPInputStream, ServerIdentity serverIdentity) {
        super(36);
        this.target = serverIdentity;
        this.read(iIOPInputStream);
    }

    public final ConnectionKey[] getAddresses() {
        return this.addrs;
    }

    public final short getSupports() {
        return this.supports;
    }

    public final short getRequires() {
        return this.requires;
    }

    public final void read(IIOPInputStream iIOPInputStream) {
        long l = iIOPInputStream.startEncapsulation();
        this.supports = iIOPInputStream.read_short();
        this.requires = iIOPInputStream.read_short();
        int n = iIOPInputStream.read_long();
        this.addrs = new ConnectionKey[n];
        for (int i = 0; i < n; ++i) {
            this.addrs[i] = new ConnectionKey(iIOPInputStream);
        }
        iIOPInputStream.endEncapsulation(l);
    }

    public final void write(IIOPOutputStream iIOPOutputStream) {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            TLSSecTransComponent.p("write(" + this.toString() + ")");
        }
        iIOPOutputStream.write_long(this.tag);
        long l = iIOPOutputStream.startEncapsulation();
        iIOPOutputStream.write_short(this.supports);
        iIOPOutputStream.write_short(this.requires);
        int n = this.addrs != null ? this.addrs.length : 0;
        iIOPOutputStream.write_long(n);
        for (int i = 0; i < n; ++i) {
            if (iIOPOutputStream.isSecure() && this.target != null) {
                this.addrs[i].writeForChannel(iIOPOutputStream, this.target);
                continue;
            }
            this.addrs[i].write(iIOPOutputStream);
        }
        iIOPOutputStream.endEncapsulation(l);
    }

    public String toString() {
        String string = "TLSSecTrans (supports = " + this.supports + ",requires = " + this.requires;
        if (this.addrs != null) {
            string = string + " addresses{ ";
            for (int i = 0; i < this.addrs.length; ++i) {
                string = string + " " + this.addrs[i].getAddress() + ":" + this.addrs[i].getPort();
            }
            string = string + "} ";
        }
        return string;
    }
}

