/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import weblogic.corba.cos.transactions.TransactionPolicyComponent;
import weblogic.corba.idl.poa.MessagingPolicyComponent;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.ClusterComponent;
import weblogic.iiop.CodeSetsComponent;
import weblogic.iiop.CodebaseComponent;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.SFVComponent;
import weblogic.iiop.SSLSecTransComponent;
import weblogic.iiop.TLSSecTransComponent;
import weblogic.iiop.csi.CompoundSecMechList;
import weblogic.kernel.Kernel;
import weblogic.protocol.ServerIdentity;
import weblogic.utils.Hex;

public class TaggedComponent {
    static final int TAG_ORB_TYPE = 0;
    static final int TAG_CODE_SETS = 1;
    public static final int TAG_POLICIES = 2;
    public static final int TAG_SSL_SEC_TRANS = 20;
    static final int TAG_JAVA_CODEBASE = 25;
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");
    public static final int TAG_TRANSACTION_POLICY = 26;
    public static final int TAG_OTS_POLICY = 31;
    public static final int TAG_INV_POLICY = 32;
    public static final int TAG_CSI_SEC_MECH_LIST = 33;
    public static final int TAG_NULL_TAG = 34;
    public static final int TAG_TLS_SEC_TRANS = 36;
    public static final int TAG_RMI_CUSTOM_MAX_STREAM_FORMAT = 38;
    static final int TAG_WLS_VERSION = 1111834880;
    public static final int TAG_WLS_CLUSTER_KEY = 1111834883;
    protected final int tag;
    private byte[] component_data;

    public TaggedComponent(int n) {
        this.tag = n;
    }

    public TaggedComponent(int n, IIOPInputStream iIOPInputStream) {
        this.tag = n;
        this.read(iIOPInputStream);
    }

    final int getTag() {
        return this.tag;
    }

    static final TaggedComponent readComponent(IIOPInputStream iIOPInputStream, ServerIdentity serverIdentity) {
        int n = iIOPInputStream.read_long();
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            TaggedComponent.p("read(" + Integer.toHexString(n) + ") @" + iIOPInputStream.pos());
        }
        switch (n) {
            case 1: {
                return new CodeSetsComponent(iIOPInputStream);
            }
            case 25: {
                return new CodebaseComponent(iIOPInputStream);
            }
            case 20: {
                return new SSLSecTransComponent(iIOPInputStream);
            }
            case 1111834883: {
                return new ClusterComponent(iIOPInputStream);
            }
            case 33: {
                return new CompoundSecMechList(iIOPInputStream, serverIdentity);
            }
            case 31: 
            case 32: {
                return new TransactionPolicyComponent(iIOPInputStream, n);
            }
            case 36: {
                return new TLSSecTransComponent(iIOPInputStream, serverIdentity);
            }
            case 2: {
                return new MessagingPolicyComponent(iIOPInputStream);
            }
            case 38: {
                return new SFVComponent(iIOPInputStream);
            }
        }
        return new TaggedComponent(n, iIOPInputStream);
    }

    public void read(IIOPInputStream iIOPInputStream) {
        this.component_data = iIOPInputStream.read_octet_sequence();
    }

    public void write(IIOPOutputStream iIOPOutputStream) {
        iIOPOutputStream.write_ulong(this.tag);
        iIOPOutputStream.write_octet_sequence(this.component_data);
    }

    protected static void p(String string) {
        System.err.println("<TaggedComponent> " + string);
    }

    public String toString() {
        return Integer.toHexString(this.tag) + ": " + (this.component_data != null ? Hex.dump((byte[])this.component_data, (int)0, (int)this.component_data.length) : " ");
    }
}

