/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import org.omg.CORBA.MARSHAL;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.IOR;
import weblogic.iiop.IORAddressingInfo;
import weblogic.iiop.ObjectKey;
import weblogic.iiop.TaggedProfile;
import weblogic.kernel.Kernel;

public final class TargetAddress {
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");
    short addressingDisposition;
    ObjectKey object_key;
    IORAddressingInfo ior;
    TaggedProfile taggedProfile;

    TargetAddress(IOR iOR, int n) {
        this.addressingDisposition = (short)2;
        this.ior = new IORAddressingInfo(iOR, n);
    }

    TargetAddress(ObjectKey objectKey) {
        this.addressingDisposition = 0;
        this.object_key = objectKey;
    }

    TargetAddress(IIOPInputStream iIOPInputStream) {
        this.read(iIOPInputStream);
    }

    public final void reset() {
        this.object_key = null;
        this.ior = null;
        this.taggedProfile = null;
    }

    final void read(IIOPInputStream iIOPInputStream) {
        this.addressingDisposition = iIOPInputStream.read_short();
        switch (this.addressingDisposition) {
            case 0: {
                this.object_key = new ObjectKey(iIOPInputStream);
                if (!Kernel.DEBUG || !debugIIOPDetail.isDebugEnabled()) break;
                TargetAddress.p("read(ObjectKey)");
                break;
            }
            case 1: {
                if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                    TargetAddress.p("read(TaggedProfile)");
                }
                this.taggedProfile = new TaggedProfile(iIOPInputStream);
                break;
            }
            case 2: {
                if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                    TargetAddress.p("read(IORAddressingInfo)");
                }
                this.ior = new IORAddressingInfo(iIOPInputStream);
                this.object_key = this.ior.ior.getProfile().getObjectKey();
                break;
            }
            default: {
                throw new MARSHAL("Unknown addressing disposition: " + this.addressingDisposition);
            }
        }
    }

    final void write(IIOPOutputStream iIOPOutputStream) {
        iIOPOutputStream.write_short(this.addressingDisposition);
        switch (this.addressingDisposition) {
            case 0: {
                this.object_key.write(iIOPOutputStream);
                break;
            }
            case 1: {
                this.taggedProfile.write(iIOPOutputStream);
                break;
            }
            case 2: {
                this.ior.write(iIOPOutputStream);
                break;
            }
            default: {
                throw new MARSHAL("Unknown addressing disposition: " + this.addressingDisposition);
            }
        }
    }

    static void p(String string) {
        System.err.println("<TargetAddress> " + string);
    }
}

