/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.UtilDelegate;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.IIOPReplacer;
import weblogic.iiop.Utils;
import weblogic.iiop.spi.IORDelegate;
import weblogic.kernel.Kernel;

public final class UtilDelegateImpl
implements UtilDelegate {
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");
    private static UtilDelegate delegate;
    static final String[] delegateClassNames;

    public RemoteException mapSystemException(SystemException systemException) {
        return Utils.mapSystemException(systemException);
    }

    public void writeAny(org.omg.CORBA.portable.OutputStream outputStream, Object object) {
        if (outputStream instanceof IIOPOutputStream) {
            ((IIOPOutputStream)outputStream).writeAny(object);
        } else {
            delegate.writeAny(outputStream, object);
        }
    }

    public Object readAny(InputStream inputStream) {
        if (inputStream instanceof IIOPInputStream) {
            return ((IIOPInputStream)inputStream).readAny();
        }
        return delegate.readAny(inputStream);
    }

    public void writeRemoteObject(org.omg.CORBA.portable.OutputStream outputStream, Object object) {
        if (outputStream instanceof IIOPOutputStream) {
            try {
                IIOPReplacer.getIIOPReplacer().replaceRemote(object).write((IIOPOutputStream)outputStream);
            }
            catch (IOException iOException) {
                throw new MARSHAL("IOException writing RemoteObject " + iOException.getMessage());
            }
        } else {
            delegate.writeRemoteObject(outputStream, object);
        }
    }

    public void writeAbstractObject(org.omg.CORBA.portable.OutputStream outputStream, Object object) {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            UtilDelegateImpl.p("writeAbstractObject(OutputStream, " + object + ")");
        }
        try {
            ((OutputStream)outputStream).write_abstract_interface(IIOPReplacer.getIIOPReplacer().replaceObject(object));
        }
        catch (IOException iOException) {
            throw new MARSHAL("IOException writing AbstractObject " + iOException.getMessage());
        }
    }

    public void registerTarget(Tie tie, Remote remote) {
    }

    public void unexportObject(Remote remote) {
    }

    public Tie getTie(Remote remote) {
        return null;
    }

    public ValueHandler createValueHandler() {
        return delegate.createValueHandler();
    }

    public String getCodebase(Class clazz) {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            UtilDelegateImpl.p("getCodebase for " + clazz);
        }
        return delegate.getCodebase(clazz);
    }

    public Class loadClass(String string, String string2, ClassLoader classLoader) throws ClassNotFoundException {
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            UtilDelegateImpl.p("className = " + string + " remoteCodebase = " + string2 + " loadingContext = " + classLoader);
        }
        return Utils.loadClass(string, string2, classLoader);
    }

    public boolean isLocal(Stub stub) throws RemoteException {
        try {
            Delegate delegate = stub._get_delegate();
            if (delegate instanceof IORDelegate) {
                return ((IORDelegate)delegate).getIOR().isLocal();
            }
            return false;
        }
        catch (SystemException systemException) {
            throw Util.mapSystemException((SystemException)systemException);
        }
    }

    public RemoteException wrapException(Throwable throwable) {
        return delegate.wrapException(throwable);
    }

    public Object[] copyObjects(Object[] objectArray, ORB oRB) throws RemoteException {
        return delegate.copyObjects(objectArray, oRB);
    }

    public Object copyObject(Object object, ORB oRB) throws RemoteException {
        return delegate.copyObject(object, oRB);
    }

    private static void p(String string) {
        System.err.println("<UtilDelegateImpl>: " + string);
    }

    static {
        delegateClassNames = new String[]{"com.sun.corba.se.internal.POA.ShutdownUtilDelegate", "com.sun.corba.se.impl.javax.rmi.CORBA.Util", "com.sun.corba.se.internal.javax.rmi.CORBA.Util", "com.ibm.rmi.javax.rmi.CORBA.Util", "com.sun.corba.ee.internal.POA.ShutdownUtilDelegate", "com.sun.corba.ee.internal.javax.rmi.CORBA.Util", "com.sun.corba.ee.internal.POA.JavaxRmiCorbaUtil", "com.ibm.CORBA.iiop.Util", "com.ibm.CORBA.iiop.UtilDelegateImpl"};
        Class<?> clazz = null;
        for (int i = 0; i < delegateClassNames.length; ++i) {
            try {
                clazz = Class.forName(delegateClassNames[i]);
                if (clazz == null) continue;
                try {
                    delegate = (UtilDelegate)clazz.newInstance();
                    if (!Kernel.DEBUG || !debugIIOPDetail.isDebugEnabled()) break;
                    UtilDelegateImpl.p("delegating to " + clazz.getName());
                    break;
                }
                catch (InstantiationException instantiationException) {
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (delegate == null) {
            throw new RuntimeException("could not find or instantiate any UtilDelegate class");
        }
    }
}

