/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.InvalidTransactionException;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ValueBase;
import org.omg.CosNaming.NamingContextHelper;
import weblogic.corba.cos.naming.NamingContextAnyHelper;
import weblogic.corba.utils.RepositoryId;
import weblogic.corba.utils.ValueHandlerImpl;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.IDLUtils;
import weblogic.rmi.extensions.RemoteRuntimeException;
import weblogic.rmi.extensions.RequestTimeoutException;
import weblogic.rmi.extensions.server.ActivatableRemoteReference;
import weblogic.rmi.extensions.server.ActivatableServerReference;
import weblogic.rmi.extensions.server.CollocatedRemoteReference;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.internal.ServerReference;
import weblogic.rmi.internal.StubInfo;
import weblogic.rmi.utils.Utilities;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.collections.WeakConcurrentHashMap;

public final class Utils {
    private static ConcurrentHashMap repositoryIdMap = new ConcurrentHashMap();
    private static WeakConcurrentHashMap abstractInterfaceMap = new WeakConcurrentHashMap();
    private static ConcurrentHashMap helperMap = new ConcurrentHashMap();
    private static ConcurrentHashMap declaredMethodMap = new ConcurrentHashMap();
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");
    public static final String IDL_ENTITY_HELPER = "Helper";
    static final String IDL_ENTITY_HOLDER = "Holder";
    static final String VALUE_FACTORY_HELPER = "DefaultFactory";
    public static final String IDL_PREFIX = "IDL:";
    static final String WEBLOGIC_OMG_JAVA_PREFIX = "weblogic.corba.idl.";
    static final String OMG_STUB_PREFIX = "org.omg.stub.";
    public static final String OMG_JAVA_PREFIX = "org.omg.";
    public static final String OMG_IDL_PREFIX = "IDL:omg.org/";
    static final String OMG_UNKNOWN_EX = "IDL:omg.org/CORBA/UNKNOWN:1.0";
    static final String STRING_REP = "IDL:omg.org/CORBA/WStringValue:1.0";
    static final String NULL_REPID = "IDL:omg.org/CORBA/AbstractBase:1.0";
    static final String OBJECT_REPID = "IDL:omg.org/CORBA/Object:1.0";
    static final String NAMING_REPID = "IDL:omg.org/CosNaming/NamingContext:1.0";
    static final String EJB_EXCEPTION_REPID = "RMI:javax.ejb.EJBException:0E3E8C42D0E83868:0B0EB2FF36CB22F6";
    static final String OLD_EJB_EXCEPTION_REPID = "RMI:javax.ejb.EJBException:0E3E8C42D0E83868:800C4C7C598DF61F";
    static final String USER_EX = "Ex";
    public static final String WRITE_METHOD = "write";
    public static final String NARROW_METHOD = "narrow";
    public static final String READ_METHOD = "read";
    public static final Class[] READ_METHOD_ARGS = new Class[]{InputStream.class};
    static final Class[] NO_ARGS_METHOD = new Class[0];
    static final String CTOR = "<init>";
    static final String USER_EX_SUFFIX = "ception";
    static final String USER_EXCEPTION = "Exception";
    public static final String STUB_EXT = "_IIOP_WLStub";

    private static void addToMap(String string, String string2) {
        if (string2 != null && string != null) {
            repositoryIdMap.put(string, string2);
        }
    }

    public static final String getRepositoryID(Class clazz) {
        String string = (String)repositoryIdMap.get(clazz.getName());
        if (string != null) {
            return string;
        }
        if (Utilities.isARemote((Class)clazz)) {
            string = Utils.getIDFromRemote(clazz);
        } else if (Throwable.class.isAssignableFrom(clazz)) {
            string = Utils.getIDFromException(clazz);
        } else if (IDLEntity.class.isAssignableFrom(clazz)) {
            string = Utils.getIDFromIDLEntity(clazz);
        } else if (Serializable.class.isAssignableFrom(clazz)) {
            string = ValueHandlerImpl.getRepositoryID(clazz);
        }
        return string;
    }

    public static final boolean isIDLInterface(Class clazz) {
        return Object.class.isAssignableFrom(clazz) && IDLEntity.class.isAssignableFrom(clazz);
    }

    private static String getIDFromRemote(Class clazz) {
        String string = null;
        Class clazz2 = clazz;
        while (Utilities.isARemote((Class)clazz2)) {
            Class<?>[] classArray = clazz2.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                Class<?> clazz3 = classArray[i];
                if (!Utilities.isARemote(clazz3)) continue;
                string = IDLUtils.isIDLInterface(clazz3) ? Utils.getIDFromIDLEntity(clazz3) : IDLUtils.getTypeID(clazz3);
                if (string != null) {
                    repositoryIdMap.put(clazz.getName(), string);
                }
                return string;
            }
            clazz2 = clazz2.getSuperclass();
        }
        return null;
    }

    public static String createIDFromIDLEntity(Class clazz) {
        String string = clazz.getName();
        String string2 = string.startsWith(OMG_JAVA_PREFIX) ? OMG_IDL_PREFIX + string.substring(OMG_JAVA_PREFIX.length()).replace('.', '/') + ":1.0" : (string.startsWith(WEBLOGIC_OMG_JAVA_PREFIX) ? OMG_IDL_PREFIX + string.substring(WEBLOGIC_OMG_JAVA_PREFIX.length() + OMG_JAVA_PREFIX.length()).replace('.', '/') + ":1.0" : IDL_PREFIX + clazz.getName().replace('.', '/') + ":1.0");
        return string2;
    }

    private static String getIDFromIDLEntity(Class clazz) {
        String string = Utils.createIDFromIDLEntity(clazz);
        if (string != null) {
            repositoryIdMap.put(clazz.getName(), string);
        }
        return string;
    }

    public static String getRepositoryID(StubInfo stubInfo) {
        String string = stubInfo.getRepositoryId();
        if (string == null) {
            RemoteReference remoteReference;
            Class[] classArray = stubInfo.getInterfaces();
            Class[] classArray2 = new Class[classArray.length];
            int n = 0;
            int n2 = 0;
            block2: for (int i = 0; i < classArray.length; ++i) {
                if (!Utilities.isARemote((Class)classArray[i])) continue;
                for (int j = 0; j < n; ++j) {
                    if (classArray[i].isAssignableFrom(classArray2[j])) continue block2;
                }
                classArray2[n++] = classArray[i];
                if (!Remote.class.isAssignableFrom(classArray[i])) continue;
                ++n2;
            }
            if (n2 > 1 && (remoteReference = stubInfo.getRemoteRef()) instanceof CollocatedRemoteReference) {
                ServerReference serverReference = ((CollocatedRemoteReference)remoteReference).getServerReference();
                java.lang.Object object = serverReference.getImplementation();
                if (object == null) {
                    if (serverReference instanceof ActivatableServerReference && remoteReference instanceof ActivatableRemoteReference) {
                        try {
                            object = ((ActivatableServerReference)serverReference).getImplementation(((ActivatableRemoteReference)remoteReference).getActivationID());
                        }
                        catch (RemoteException remoteException) {
                            debugIIOPDetail.debug("Unable to get implementation: ServerReference=" + serverReference + "; RemoteReference=" + remoteReference, (Throwable)remoteException);
                            throw new RemoteRuntimeException("Unable to get implementation", (Throwable)remoteException);
                        }
                    } else {
                        debugIIOPDetail.debug("Unexptected error: Unable to get implementation: ServerReference=" + serverReference + "; RemoteReference=" + remoteReference);
                        throw new RemoteRuntimeException("Unexptected error: unable to get implementation");
                    }
                }
                string = IDLUtils.getTypeID(object.getClass());
            }
            if (string == null && (string = (String)repositoryIdMap.get(classArray2[0].getName())) == null) {
                string = Utils.getIDFromRemote(classArray2);
            }
            stubInfo.setRepositoryId(string);
        }
        return string;
    }

    private static String getIDFromRemote(Class[] classArray) {
        String string = null;
        Class[] classArray2 = classArray;
        for (int i = 0; i < classArray2.length - 1; ++i) {
            Class clazz = classArray2[i];
            if (!Utilities.isARemote((Class)clazz)) continue;
            string = IDLUtils.getTypeID(clazz);
            if (string != null) {
                repositoryIdMap.put(classArray2[i].getName(), string);
            }
            return string;
        }
        return null;
    }

    public static String getIDFromException(Class clazz) {
        if (SystemException.class.isAssignableFrom(clazz) || UserException.class.isAssignableFrom(clazz)) {
            return Utils.getIDFromIDLEntity(clazz);
        }
        if (RuntimeException.class.isAssignableFrom(clazz) || Error.class.isAssignableFrom(clazz)) {
            return OMG_UNKNOWN_EX;
        }
        String string = clazz.getName().replace('.', '/');
        if (string.endsWith(USER_EXCEPTION)) {
            string = string.substring(0, string.length() - USER_EX_SUFFIX.length());
        }
        String string2 = IDL_PREFIX + string + ":1.0";
        repositoryIdMap.put(clazz.getName(), string2);
        return string2;
    }

    public static final Class getClassFromID(RepositoryId repositoryId) {
        return Utils.getClassFromID(repositoryId, null);
    }

    public static final Class getClassFromID(RepositoryId repositoryId, String string) {
        Class clazz;
        block12: {
            clazz = (Class)RepositoryId.PRIMITIVE_MAP.get(repositoryId);
            if (clazz != null) {
                return clazz;
            }
            String string2 = repositoryId.getClassName();
            int n = 0;
            try {
                clazz = Utils.loadClass(string2, string, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (string2.endsWith(USER_EX) && (string2 = string2 + USER_EX_SUFFIX) != null) {
                    try {
                        clazz = Utils.loadClass(string2, string, null);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        string2 = string2.substring(0, string2.length() - USER_EXCEPTION.length());
                        try {
                            clazz = Utils.loadClass(string2, string, null);
                            break block12;
                        }
                        catch (ClassNotFoundException classNotFoundException3) {}
                    }
                }
                n = string2.lastIndexOf(46);
                if (n < 0) break block12;
                String string3 = string2.substring(0, n) + "Package" + string2.substring(n);
                try {
                    clazz = Utils.loadClass(string3, string, null);
                }
                catch (ClassNotFoundException classNotFoundException4) {
                    if (!string2.startsWith(OMG_JAVA_PREFIX) || (string2 = WEBLOGIC_OMG_JAVA_PREFIX + string2) == null) break block12;
                    try {
                        clazz = Utils.loadClass(string2);
                    }
                    catch (ClassNotFoundException classNotFoundException5) {
                        // empty catch block
                    }
                }
            }
        }
        return clazz;
    }

    public static Class getClassFromStub(Class clazz) {
        if (clazz.isInterface() && IDLEntity.class.isAssignableFrom(clazz) && Object.class.isAssignableFrom(clazz) && !IDLEntity.class.equals((java.lang.Object)clazz)) {
            return clazz;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!IDLEntity.class.isAssignableFrom(classArray[i]) || !Object.class.isAssignableFrom(classArray[i]) || IDLEntity.class.equals(classArray[i])) continue;
            return classArray[i];
        }
        return null;
    }

    public static Class getStubFromClass(Class clazz) {
        return Utils.getStubFromClass(clazz, null);
    }

    public static Class getStubFromClass(Class clazz, String string) {
        java.lang.Object object;
        String string2 = null;
        if (clazz.getPackage() != null) {
            object = clazz.getPackage().getName();
            string2 = (String)object + "._" + clazz.getName().substring(((String)object).length() + 1) + "Stub";
        } else {
            string2 = "_" + clazz.getName() + "Stub";
        }
        object = null;
        try {
            object = Utils.loadClass(string2, string, clazz.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return object;
    }

    public static String getClassNameFromStubName(String string) {
        int n = string.indexOf("_Stub.class");
        if (n >= 0) {
            int n2;
            if (string.startsWith(OMG_STUB_PREFIX)) {
                string = string.substring(OMG_STUB_PREFIX.length());
                n -= OMG_STUB_PREFIX.length();
            }
            string = (n2 = string.indexOf("._")) >= 0 ? string.substring(0, n2) + "." + string.substring(n2 + 2, n) : string.substring(1, n);
            return string;
        }
        return null;
    }

    public static boolean isStubName(String string) {
        return string.endsWith("_Stub.class") && (string.indexOf("/_") > 0 || string.startsWith("_"));
    }

    public static boolean isIDLException(Class clazz) {
        return !IDLEntity.class.equals((java.lang.Object)clazz) && IDLEntity.class.isAssignableFrom(clazz) && !ValueBase.class.isAssignableFrom(clazz) && Throwable.class.isAssignableFrom(clazz);
    }

    public static boolean isAbstractInterface(Class clazz) {
        Boolean bl = (Boolean)abstractInterfaceMap.get((java.lang.Object)clazz);
        if (bl != null) {
            return bl;
        }
        boolean bl2 = IDLUtils.isAbstractInterface(clazz);
        abstractInterfaceMap.put((java.lang.Object)clazz, (java.lang.Object)new Boolean(bl2));
        return bl2;
    }

    static Class findIDLInterface(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Class clazz2 = clazz.getSuperclass();
        if (IDLEntity.class.equals(clazz2)) {
            return clazz;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!IDLEntity.class.equals(classArray[i])) continue;
            return clazz;
        }
        Class clazz3 = null;
        if (clazz2 != null && clazz2.isInterface() && (clazz3 = Utils.findIDLInterface(clazz2)) != null) {
            return clazz3;
        }
        for (int i = 0; i < classArray.length; ++i) {
            clazz3 = Utils.findIDLInterface(classArray[i]);
            if (clazz3 == null) continue;
            return clazz3;
        }
        if (clazz2 != null && !clazz2.isInterface()) {
            clazz3 = Utils.findIDLInterface(clazz2);
        }
        return clazz3;
    }

    public static Class getHelper(Class clazz, String string) {
        ClassLoader classLoader = clazz.getClassLoader();
        Class clazz2 = (Class)helperMap.get(clazz);
        if (clazz2 != null) {
            return clazz2;
        }
        String string2 = clazz.getName() + string;
        try {
            clazz2 = Utils.loadClass(string2, null, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz2 = Utils.loadClass(string2);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                // empty catch block
            }
        }
        if (clazz2 != null) {
            helperMap.put(clazz, clazz2);
        }
        return clazz2;
    }

    public static Class getIDLHelper(Class clazz) {
        Class clazz2;
        Class clazz3 = Utils.getHelper(clazz, IDL_ENTITY_HELPER);
        if (clazz3 == null && (clazz2 = Utils.findIDLInterface(clazz)) != null) {
            clazz3 = Utils.getHelper(clazz2, IDL_ENTITY_HELPER);
        }
        return clazz3;
    }

    public static Class getIDLHolder(Class clazz) {
        Class clazz2 = Utils.getHelper(clazz, IDL_ENTITY_HOLDER);
        if (clazz2 == null) {
            Class clazz3 = Utils.findIDLInterface(clazz);
            clazz2 = Utils.getHelper(clazz3, IDL_ENTITY_HOLDER);
        }
        return clazz2;
    }

    public static Method getIDLWriter(Class clazz) {
        java.lang.Object var1_1 = null;
        Class clazz2 = clazz;
        Class clazz3 = Utils.getHelper(clazz, IDL_ENTITY_HELPER);
        if (clazz3 == null) {
            clazz2 = Utils.findIDLInterface(clazz);
            clazz3 = Utils.getHelper(clazz2, IDL_ENTITY_HELPER);
        }
        if (clazz3 == null) {
            return null;
        }
        return Utils.getDeclaredMethod(clazz3, WRITE_METHOD, new Class[]{OutputStream.class, clazz2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Member getDeclaredMember(Class clazz, String string, Class[] classArray) {
        Executable executable;
        ConcurrentHashMap<String, String> concurrentHashMap = (ConcurrentHashMap<String, String>)declaredMethodMap.get(clazz);
        if (concurrentHashMap == null) {
            executable = declaredMethodMap;
            synchronized (executable) {
                concurrentHashMap = (ConcurrentHashMap)declaredMethodMap.get(clazz);
                if (concurrentHashMap == null) {
                    concurrentHashMap = new ConcurrentHashMap<String, String>();
                    declaredMethodMap.put(clazz, concurrentHashMap);
                }
            }
        }
        try {
            executable = (AccessibleObject)concurrentHashMap.get(string);
            if (executable == null) {
                executable = string == CTOR ? clazz.getDeclaredConstructor(classArray) : clazz.getDeclaredMethod(string, classArray);
                if (!executable.isAccessible()) {
                    try {
                        executable.setAccessible(true);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
                concurrentHashMap.put(string, (String)((java.lang.Object)executable));
            }
            return executable;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            concurrentHashMap.put(string, string);
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public static Constructor getNoArgConstructor(Class clazz) {
        return (Constructor)Utils.getDeclaredMember(clazz, CTOR, NO_ARGS_METHOD);
    }

    public static Method getDeclaredMethod(Class clazz, String string, Class[] classArray) {
        return (Method)Utils.getDeclaredMember(clazz, string, classArray);
    }

    public static Constructor getDeclaredConstructor(Class clazz, Class[] classArray) {
        return (Constructor)Utils.getDeclaredMember(clazz, CTOR, classArray);
    }

    public static Object narrow(ObjectImpl objectImpl, Class clazz) throws InvocationTargetException, IllegalAccessException, ClassCastException {
        Class clazz2 = Utils.getIDLHelper(clazz);
        if (clazz2 == null) {
            throw new ClassCastException("Couldn't find helper for: " + clazz.getName());
        }
        Method method = Utils.getDeclaredMethod(clazz2, NARROW_METHOD, new Class[]{Object.class});
        if (method == null) {
            throw new ClassCastException("Couldn't find helper for: " + clazz.getName());
        }
        return (Object)method.invoke(null, objectImpl);
    }

    public static final IOException mapToRemoteException(IOException iOException) {
        if (iOException instanceof UnknownHostException) {
            return new java.rmi.UnknownHostException(iOException.getMessage(), iOException);
        }
        if (iOException instanceof ConnectException) {
            return new java.rmi.ConnectException(iOException.getMessage(), iOException);
        }
        if (iOException instanceof SocketException) {
            return new ConnectIOException(iOException.getMessage(), iOException);
        }
        return iOException;
    }

    public static final Class loadClass(String string) throws ClassNotFoundException {
        return Utils.loadClass(string, null, null);
    }

    public static final Class loadClass(String string, String string2, ClassLoader classLoader) throws ClassNotFoundException {
        return Utilities.loadClass((String)string, (String)string2, (ClassLoader)classLoader);
    }

    public static final String getAnnotation(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        String string = null;
        if (classLoader instanceof GenericClassLoader && (string = ((GenericClassLoader)classLoader).getAnnotation().getAnnotationString()).length() == 0) {
            string = null;
        }
        return string;
    }

    public static final SystemException mapRemoteToCORBAException(RemoteException remoteException) {
        java.lang.Object object = null;
        if (remoteException instanceof java.rmi.UnknownHostException) {
            object = new BAD_PARAM(remoteException.getMessage(), 1330446344, CompletionStatus.COMPLETED_NO);
        } else if (remoteException instanceof java.rmi.ConnectException) {
            object = new COMM_FAILURE(remoteException.getMessage(), 0, CompletionStatus.COMPLETED_NO);
        } else if (remoteException instanceof ConnectIOException) {
            object = new COMM_FAILURE(remoteException.getMessage(), 0, CompletionStatus.COMPLETED_NO);
        } else if (remoteException instanceof MarshalException) {
            object = new MARSHAL(remoteException.getMessage(), 0, CompletionStatus.COMPLETED_MAYBE);
        } else if (remoteException instanceof UnmarshalException) {
            object = new MARSHAL(remoteException.getMessage(), 0, CompletionStatus.COMPLETED_NO);
        } else if (remoteException instanceof NoSuchObjectException) {
            object = new OBJECT_NOT_EXIST(remoteException.getMessage(), 1330446337, CompletionStatus.COMPLETED_NO);
        } else if (remoteException instanceof AccessException) {
            object = new NO_PERMISSION(remoteException.getMessage(), 0, CompletionStatus.COMPLETED_MAYBE);
        } else if (remoteException instanceof TransactionRequiredException) {
            object = new TRANSACTION_REQUIRED(remoteException.getMessage(), 0, CompletionStatus.COMPLETED_MAYBE);
        } else if (remoteException instanceof TransactionRolledbackException) {
            object = new TRANSACTION_ROLLEDBACK(remoteException.getMessage(), 0, CompletionStatus.COMPLETED_MAYBE);
        } else if (remoteException instanceof InvalidTransactionException) {
            object = new INVALID_TRANSACTION(remoteException.getMessage(), 0, CompletionStatus.COMPLETED_MAYBE);
        } else if (remoteException instanceof RequestTimeoutException) {
            object = new TIMEOUT(remoteException.getMessage(), 0, CompletionStatus.COMPLETED_MAYBE);
        }
        if (object != null) {
            object.initCause((Throwable)remoteException);
        }
        return object;
    }

    public static final SystemException mapToCORBAException(IOException iOException) {
        if (iOException.getCause() instanceof SystemException) {
            return (SystemException)iOException.getCause();
        }
        Throwable throwable = null;
        if (iOException instanceof RemoteException && (throwable = Utils.mapRemoteToCORBAException((RemoteException)iOException)) != null) {
            return throwable;
        }
        throwable = iOException instanceof UnknownHostException ? new BAD_PARAM(iOException.getMessage(), 1330446344, CompletionStatus.COMPLETED_NO) : (iOException instanceof ConnectException ? new COMM_FAILURE(iOException.getMessage(), 0, CompletionStatus.COMPLETED_NO) : (iOException instanceof SocketException ? new COMM_FAILURE(iOException.getMessage(), 0, CompletionStatus.COMPLETED_NO) : new UNKNOWN(iOException.getMessage(), 0, CompletionStatus.COMPLETED_MAYBE)));
        throwable.initCause((Throwable)iOException);
        return throwable;
    }

    public static final MARSHAL wrapMARSHALWithCause(Throwable throwable) {
        MARSHAL mARSHAL = new MARSHAL(throwable.getMessage());
        mARSHAL.initCause(throwable);
        return mARSHAL;
    }

    public static final RemoteException mapSystemException(SystemException systemException) {
        java.lang.Object object = null;
        object = systemException instanceof COMM_FAILURE ? new MarshalException(Utils.createDetailMessage(systemException), (Exception)((java.lang.Object)systemException)) : (systemException instanceof INV_OBJREF || systemException instanceof OBJECT_NOT_EXIST ? new NoSuchObjectException(Utils.createDetailMessage(systemException)) : (systemException instanceof NO_PERMISSION ? new AccessException(Utils.createDetailMessage(systemException), (Exception)((java.lang.Object)systemException)) : (systemException instanceof MARSHAL ? (systemException.completed.value() == 1 ? new UnmarshalException(Utils.createDetailMessage(systemException), (Exception)((java.lang.Object)systemException)) : new MarshalException(Utils.createDetailMessage(systemException), (Exception)((java.lang.Object)systemException))) : (systemException instanceof TRANSACTION_REQUIRED ? new TransactionRequiredException(Utils.createDetailMessage(systemException)) : (systemException instanceof TRANSACTION_ROLLEDBACK ? new TransactionRolledbackException(Utils.createDetailMessage(systemException)) : (systemException instanceof INVALID_TRANSACTION ? new InvalidTransactionException(Utils.createDetailMessage(systemException)) : (systemException instanceof BAD_PARAM ? new MarshalException(Utils.createDetailMessage(systemException), (Exception)((java.lang.Object)systemException)) : new RemoteException(Utils.createDetailMessage(systemException), systemException))))))));
        ((RemoteException)object).detail = systemException;
        return object;
    }

    private static final String createDetailMessage(SystemException systemException) {
        StringBuffer stringBuffer = new StringBuffer("CORBA ");
        stringBuffer.append(((java.lang.Object)((java.lang.Object)systemException)).getClass().getName().substring("org.omg.CORBA.".length()));
        stringBuffer.append(" ");
        stringBuffer.append(Integer.toHexString(systemException.minor));
        switch (systemException.completed.value()) {
            case 0: {
                stringBuffer.append(" Yes");
                break;
            }
            case 1: {
                stringBuffer.append(" No");
                break;
            }
            case 2: {
                stringBuffer.append(" Maybe");
            }
        }
        return stringBuffer.toString();
    }

    private static void p(String string) {
        System.out.println("<Utils>: " + string);
    }

    static {
        Utils.addToMap("org.omg.CosNaming.NamingContext", "IDL:omg.org/CosNaming/NamingContextExt:1.0");
        Utils.addToMap("java.lang.String", STRING_REP);
        Utils.addToMap("weblogic.cos.naming.NamingContext_IIOP_WLStub", NamingContextAnyHelper.id());
        Utils.addToMap("weblogic.cos.naming.NamingContextImpl", NamingContextAnyHelper.id());
        Utils.addToMap("org.omg.CosNaming.NamingContext", NamingContextHelper.id());
        Utils.addToMap("weblogic.corba.cos.naming.NamingContextAny", NamingContextAnyHelper.id());
    }
}

