/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import weblogic.common.internal.PackageInfo;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.VersionInfo;
import weblogic.corba.client.Version;
import weblogic.corba.j2ee.workarea.WorkAreaContext;
import weblogic.iiop.ForwardingContext;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.RoutingContext;
import weblogic.iiop.ServiceContext;
import weblogic.iiop.VendorInfoCluster;
import weblogic.iiop.VendorInfoSecurity;
import weblogic.iiop.VendorInfoTrace;
import weblogic.iiop.VendorInfoTx;
import weblogic.kernel.Kernel;

public final class VendorInfo
extends ServiceContext
implements Version {
    public static final int VendorInfo = 1111834880;
    public static final int VendorInfoTx = 1111834881;
    public static final int VendorInfoSecurity = 1111834882;
    public static final int VendorInfoCluster = 1111834883;
    public static final int VendorInfoBEA04 = 1111834884;
    public static final int VendorInfoBEA05 = 1111834885;
    public static final int VendorInfoBEA06 = 1111834886;
    public static final int VendorInfoBEA07 = 1111834887;
    public static final int VendorInfoRoutingContext = 1111834888;
    public static final int VendorInfoForwardingContext = 1111834889;
    public static final int VendorInfoTrace = 1111834890;
    public static final int VendorRuntimeContext = 1111834891;
    public static final int VendorInfoEnd = 1111834943;
    protected byte majorVersion = (byte)10;
    protected byte minorVersion = (byte)3;
    protected byte minorServicePack = (byte)6;
    protected static PackageInfo pkgInfo;
    protected PeerInfo peerinfo;
    static final VendorInfo VENDOR_INFO;

    private VendorInfo() {
        super(1111834880);
        if (Kernel.isServer()) {
            this.majorVersion = (byte)pkgInfo.getMajor();
            this.minorVersion = (byte)pkgInfo.getMinor();
            this.minorServicePack = (byte)pkgInfo.getServicePack();
        }
    }

    public VendorInfo(byte by, byte by2, byte by3) {
        super(1111834880);
        this.majorVersion = by;
        this.minorVersion = by2;
        this.minorServicePack = by3;
    }

    protected VendorInfo(IIOPInputStream iIOPInputStream) {
        super(1111834880);
        this.readEncapsulatedContext(iIOPInputStream);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getServicePack() {
        return this.minorServicePack;
    }

    public PeerInfo getPeerInfo() {
        if (this.peerinfo == null) {
            this.peerinfo = new PeerInfo((int)this.majorVersion, (int)this.minorVersion, (int)this.minorServicePack, null);
        }
        return this.peerinfo;
    }

    static ServiceContext readServiceContext(int n, IIOPInputStream iIOPInputStream) {
        switch (n) {
            case 1111834880: {
                return new VendorInfo(iIOPInputStream);
            }
            case 1111834881: {
                return new VendorInfoTx(iIOPInputStream);
            }
            case 1111834882: {
                return new VendorInfoSecurity(iIOPInputStream);
            }
            case 1111834883: {
                return new VendorInfoCluster(iIOPInputStream);
            }
            case 1111834888: {
                return new RoutingContext(iIOPInputStream);
            }
            case 1111834889: {
                return new ForwardingContext(iIOPInputStream);
            }
            case 1111834890: {
                return new VendorInfoTrace(iIOPInputStream);
            }
            case 1111834891: {
                return new WorkAreaContext(iIOPInputStream);
            }
        }
        return new ServiceContext(n, iIOPInputStream);
    }

    public void write(IIOPOutputStream iIOPOutputStream) {
        this.writeEncapsulatedContext(iIOPOutputStream);
    }

    protected void readEncapsulation(IIOPInputStream iIOPInputStream) {
        this.majorVersion = iIOPInputStream.read_octet();
        this.minorVersion = iIOPInputStream.read_octet();
        this.minorServicePack = iIOPInputStream.read_octet();
    }

    protected void writeEncapsulation(IIOPOutputStream iIOPOutputStream) {
        iIOPOutputStream.write_octet(this.majorVersion);
        iIOPOutputStream.write_octet(this.minorVersion);
        iIOPOutputStream.write_octet(this.minorServicePack);
    }

    public String toString() {
        return "VendorInfo Context for " + this.majorVersion + "." + this.minorVersion + "." + this.minorServicePack;
    }

    static {
        if (Kernel.isServer()) {
            pkgInfo = VersionInfo.theOne().getPackages()[0];
        }
        VENDOR_INFO = new VendorInfo();
    }
}

