/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import org.omg.CORBA.MARSHAL;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.ClusterComponent;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.IIOPRemoteRef;
import weblogic.iiop.IIOPReplacer;
import weblogic.iiop.IOR;
import weblogic.iiop.ServiceContext;
import weblogic.iiop.Utils;
import weblogic.kernel.Kernel;
import weblogic.rjvm.JVMID;
import weblogic.rmi.cluster.ReplicaList;
import weblogic.rmi.cluster.Version;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.internal.OIDManager;
import weblogic.rmi.internal.ServerReference;
import weblogic.rmi.internal.StubInfo;
import weblogic.rmi.spi.HostID;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public final class VendorInfoCluster
extends ServiceContext
implements ReplicaList,
Externalizable {
    private static final long serialVersionUID = -5343036220579753659L;
    private ArrayList replicas;
    private ReplicaList replicaList;
    private Version version;
    private HashMap hostToReplicaMap;
    private IIOPRemoteRef localRef;
    private ClusterComponent clustInfo;
    private static final DebugLogger debugIIOPDetail = DebugLogger.getDebugLogger((String)"DebugIIOPDetail");
    private static final DebugCategory debugTransport = Debug.getCategory((String)"weblogic.iiop.transport");
    private static final DebugLogger debugIIOPTransport = DebugLogger.getDebugLogger((String)"DebugIIOPTransport");

    public VendorInfoCluster() {
        super(1111834883);
        this.replicaList = this;
    }

    VendorInfoCluster(Object object) {
        this();
        if (object instanceof Version) {
            this.version = (Version)object;
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                VendorInfoCluster.p("VendorInfoCluster(Version: " + object + ")");
            }
        } else if (object instanceof VendorInfoCluster) {
            this.reset((ReplicaList)object);
            this.replicas = new ArrayList(1);
            this.version = new Version(0L);
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                VendorInfoCluster.p("VendorInfoCluster(VendorInfoCluster: " + object + ")");
            }
        } else if (object instanceof ReplicaList) {
            this.replicaList = (ReplicaList)object;
            this.version = (Version)((ReplicaList)object).version();
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                VendorInfoCluster.p("VendorInfoCluster(ReplicaList: " + object + ")");
            }
        }
    }

    public VendorInfoCluster(Version version2) {
        this((Object)version2);
    }

    public VendorInfoCluster(IIOPRemoteRef iIOPRemoteRef) {
        this();
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            VendorInfoCluster.p("VendorInfoCluster(IIOPRemoteRef: " + iIOPRemoteRef + ")");
        }
        this.replicas = new ArrayList(1);
        this.version = new Version(0L);
        this.add((RemoteReference)iIOPRemoteRef);
    }

    public final ArrayList getReplicaList() {
        return this.replicas;
    }

    public void setClusterInfo(ClusterComponent clusterComponent) {
        this.clustInfo = new ClusterComponent(clusterComponent);
    }

    void setVersion(Version version2) {
        this.version = version2;
    }

    public ClusterComponent getClusterInfo() {
        if (this.clustInfo != null) {
            ArrayList<IOR> arrayList = new ArrayList<IOR>(this.replicas.size());
            for (IIOPRemoteRef iIOPRemoteRef : this.replicas) {
                arrayList.add(iIOPRemoteRef.getIOR());
            }
            this.clustInfo.setIORs(arrayList);
        }
        return this.clustInfo;
    }

    protected VendorInfoCluster(IIOPInputStream iIOPInputStream) {
        super(1111834883);
        this.readEncapsulatedContext(iIOPInputStream);
    }

    public void write(IIOPOutputStream iIOPOutputStream) {
        this.writeEncapsulatedContext(iIOPOutputStream);
    }

    protected void readEncapsulation(IIOPInputStream iIOPInputStream) {
        this.version = new Version(iIOPInputStream.read_longlong());
        int n = iIOPInputStream.read_long();
        if (n > 0) {
            this.replicas = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                this.replicas.add(new IIOPRemoteRef(new IOR(iIOPInputStream)));
            }
        }
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            VendorInfoCluster.p("readEncapsulation(version " + this.version.getVersion() + " " + n + " IORs)");
        }
    }

    protected void writeEncapsulation(IIOPOutputStream iIOPOutputStream) {
        int n;
        iIOPOutputStream.write_longlong(this.version.getVersion());
        int n2 = this.replicaList == null ? 0 : this.replicaList.size();
        IOR[] iORArray = new IOR[n2];
        int n3 = 0;
        IIOPReplacer iIOPReplacer = IIOPReplacer.getIIOPReplacer();
        for (n = 0; n < n2; ++n) {
            try {
                RemoteReference remoteReference = this.replicaList.get(n);
                Object object = iIOPReplacer.replaceObject(remoteReference);
                if (object instanceof IOR) {
                    iORArray[n] = (IOR)object;
                } else {
                    remoteReference = this.replicaList.findReplicaHostedBy((HostID)JVMID.localID());
                    ServerReference serverReference = OIDManager.getInstance().getServerReference(remoteReference.getObjectID());
                    StubInfo stubInfo = (StubInfo)serverReference.getStubReference();
                    String string = Utils.getRepositoryID(stubInfo);
                    iORArray[n] = iIOPReplacer.getIOR((RemoteReference)object, string, serverReference.getApplicationName(), null, serverReference.getDescriptor(), null);
                }
                ++n3;
                continue;
            }
            catch (MARSHAL mARSHAL) {
                if ((!Kernel.DEBUG || !debugIIOPDetail.isDebugEnabled()) && !debugTransport.isEnabled() && !debugIIOPTransport.isDebugEnabled()) continue;
                IIOPLogger.logDebugMarshalError((String)"Failed to export ClusterComponent member", (Throwable)mARSHAL);
                continue;
            }
            catch (IOException iOException) {
                if ((!Kernel.DEBUG || !debugIIOPDetail.isDebugEnabled()) && !debugTransport.isEnabled() && !debugIIOPTransport.isDebugEnabled()) continue;
                IIOPLogger.logDebugMarshalError((String)"Failed to export ClusterComponent member", (Throwable)iOException);
            }
        }
        iIOPOutputStream.write_long(n3);
        for (n = 0; n < n3; ++n) {
            iORArray[n].write(iIOPOutputStream);
        }
        if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
            VendorInfoCluster.p("writeEncapsulation(version " + this.version.getVersion() + ", " + n3 + " of " + n2 + " IORs)");
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        IIOPOutputStream iIOPOutputStream = new IIOPOutputStream();
        long l = iIOPOutputStream.startEncapsulation();
        this.writeEncapsulation(iIOPOutputStream);
        iIOPOutputStream.endEncapsulation(l);
        byte[] byArray = iIOPOutputStream.getBuffer();
        iIOPOutputStream.close();
        objectOutput.writeInt(byArray.length);
        objectOutput.write(byArray);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        byte[] byArray = new byte[n];
        objectInput.read(byArray);
        IIOPInputStream iIOPInputStream = new IIOPInputStream(byArray);
        long l = iIOPInputStream.startEncapsulation();
        this.readEncapsulation(iIOPInputStream);
        iIOPInputStream.endEncapsulation(l);
        iIOPInputStream.close();
    }

    public String toString() {
        return "VendorInfoCluster: version: " + Long.toHexString(this.version.getVersion()) + " " + (this.replicas == null ? 0 : this.replicas.size()) + " IORs";
    }

    public int size() {
        return this.replicas == null ? 0 : this.replicas.size();
    }

    public Object version() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(RemoteReference remoteReference) {
        if (remoteReference.getHostID().equals(JVMID.localID())) {
            this.localRef = (IIOPRemoteRef)remoteReference;
        }
        VendorInfoCluster vendorInfoCluster = this;
        synchronized (vendorInfoCluster) {
            this.replicas.add(remoteReference);
            if (remoteReference.getHostID() instanceof JVMID) {
                this.version.addServer(remoteReference.getHostID());
            }
        }
    }

    public RemoteReference get(int n) {
        Debug.assertion((this.replicas != null && this.replicas.size() > 0 ? 1 : 0) != 0);
        return (RemoteReference)this.replicas.get(n);
    }

    public RemoteReference getPrimary() {
        return this.get(0);
    }

    public void clear() {
        this.replicas.clear();
        this.version = new Version(0L);
        this.clearHostToReplicaMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(RemoteReference remoteReference) {
        Debug.assertion((remoteReference != null ? 1 : 0) != 0);
        VendorInfoCluster vendorInfoCluster = this;
        synchronized (vendorInfoCluster) {
            this.replicas.remove(remoteReference);
            if (this.hostToReplicaMap != null) {
                HostID hostID = remoteReference.getHostID();
                this.hostToReplicaMap.remove(hostID);
            }
            if (remoteReference.getHostID() instanceof JVMID) {
                this.version.removeServer(remoteReference.getHostID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteReference removeOne(HostID hostID) {
        VendorInfoCluster vendorInfoCluster = this;
        synchronized (vendorInfoCluster) {
            ListIterator listIterator = this.replicas.listIterator();
            while (listIterator.hasNext()) {
                RemoteReference remoteReference = (RemoteReference)listIterator.next();
                if (!remoteReference.getHostID().equals(hostID)) continue;
                listIterator.remove();
                if (this.hostToReplicaMap != null) {
                    this.hostToReplicaMap.remove(hostID);
                }
                this.version.removeServer(remoteReference.getHostID());
                return remoteReference;
            }
        }
        return null;
    }

    protected Iterator iterator() {
        return this.replicas.iterator();
    }

    public Object[] toArray() {
        return this.replicas.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteReference findReplicaHostedBy(HostID hostID) {
        RemoteReference remoteReference2 = null;
        VendorInfoCluster vendorInfoCluster = this;
        synchronized (vendorInfoCluster) {
            if (this.hostToReplicaMap != null) {
                remoteReference2 = (RemoteReference)this.hostToReplicaMap.get(hostID);
            }
            if (remoteReference2 == null) {
                for (RemoteReference remoteReference2 : this.replicas) {
                    if (!hostID.equals(remoteReference2.getHostID())) {
                        remoteReference2 = null;
                        continue;
                    }
                    if (this.hostToReplicaMap == null) {
                        this.hostToReplicaMap = new HashMap(5);
                    }
                    this.hostToReplicaMap.put(hostID, remoteReference2);
                    break;
                }
            }
        }
        if (remoteReference2 != null) {
            Debug.assertion((remoteReference2 == null || remoteReference2.getHostID().equals(hostID) ? 1 : 0) != 0, (String)("host ID of new replica (" + remoteReference2.getHostID() + ") " + "must equal " + hostID));
        }
        return remoteReference2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(ReplicaList replicaList) {
        if (replicaList instanceof VendorInfoCluster) {
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                VendorInfoCluster.p("reset(" + replicaList + ")");
            }
            VendorInfoCluster vendorInfoCluster = (VendorInfoCluster)replicaList;
            if (vendorInfoCluster.replicas == null || vendorInfoCluster.size() == 0) {
                throw new AssertionError("reset() called with null ReplicaList");
            }
            VendorInfoCluster vendorInfoCluster2 = this;
            synchronized (vendorInfoCluster2) {
                Collections.shuffle(vendorInfoCluster.replicas);
                this.replicas = vendorInfoCluster.replicas;
                this.version = vendorInfoCluster.version;
                this.clearHostToReplicaMap();
            }
        } else {
            throw new AssertionError("reset() called with foreign ReplicaList");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetWithoutShuffle(ReplicaList replicaList) {
        if (replicaList instanceof VendorInfoCluster) {
            if (Kernel.DEBUG && debugIIOPDetail.isDebugEnabled()) {
                VendorInfoCluster.p("resetWithoutShuffle(" + replicaList + ")");
            }
            VendorInfoCluster vendorInfoCluster = (VendorInfoCluster)replicaList;
            if (vendorInfoCluster.replicas == null || vendorInfoCluster.size() == 0) {
                throw new AssertionError("reset() called with null ReplicaList");
            }
            VendorInfoCluster vendorInfoCluster2 = this;
            synchronized (vendorInfoCluster2) {
                this.replicas = vendorInfoCluster.replicas;
                this.version = vendorInfoCluster.version;
                this.clearHostToReplicaMap();
            }
        } else {
            throw new AssertionError("reset() called with foreign ReplicaList");
        }
    }

    protected final void clearHostToReplicaMap() {
        if (this.hostToReplicaMap != null) {
            this.hostToReplicaMap.clear();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public ReplicaList getListWithRefHostedBy(HostID hostID) {
        return new VendorInfoCluster(this.localRef);
    }

    protected static void p(String string) {
        System.err.println("<VendorInfoCluster> " + string);
    }
}

