/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Properties;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA_2_3.portable.InputStream;
import weblogic.iiop.FragmentMessage;
import weblogic.iiop.IIOPClient;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.Message;
import weblogic.iiop.MessageHeader;
import weblogic.iiop.ReplyMessage;
import weblogic.iiop.RequestMessage;
import weblogic.utils.Getopt2;
import weblogic.utils.Hex;

public class codec {
    private static final String PROGRAM = "weblogic.iiop.codec";
    private static int fpos = 0;

    public static void main(String[] stringArray) throws Exception {
        Closeable closeable;
        Serializable serializable;
        Class<?> clazz = null;
        fpos = 0;
        Getopt2 getopt2 = new Getopt2();
        getopt2.addFlag("sun", "Decode/encode using Sun ORB");
        getopt2.addFlag("wls", "Decode/encode using WLS ORB");
        getopt2.addFlag("rewrite", "Rewrite message using WLS ORB");
        getopt2.addFlag("value", "Write valuetype");
        getopt2.addOption("o", "outfile", "Output file");
        getopt2.addOption("f", "infile", "Input file");
        getopt2.setUsageArgs("<filename> [<return type>]");
        if (stringArray.length == 0) {
            getopt2.usageAndExit(PROGRAM);
        }
        getopt2.grok(stringArray);
        String string = getopt2.getOption("f");
        String string2 = getopt2.getOption("o");
        if (string == null && getopt2.args().length > 0) {
            string = getopt2.args()[0];
        }
        if (getopt2.args().length > 1) {
            clazz = Class.forName(getopt2.args()[1]);
        }
        boolean bl = getopt2.hasOption("sun");
        boolean bl2 = getopt2.hasOption("wls");
        if (getopt2.hasOption("value")) {
            serializable = (Serializable)clazz.newInstance();
            closeable = new FileWriter(string);
            IIOPOutputStream iIOPOutputStream = null;
            if (bl) {
                iIOPOutputStream = (org.omg.CORBA_2_3.portable.OutputStream)ORB.init((String[])new String[0], null).create_output_stream();
            } else {
                IIOPClient.initialize();
                iIOPOutputStream = new IIOPOutputStream();
            }
            codec.writeValue(iIOPOutputStream, serializable, (FileWriter)closeable);
            ((OutputStreamWriter)closeable).close();
            System.exit(0);
        }
        if (!((File)(serializable = new File(string))).exists()) {
            codec.fatal("file " + string + " does not exist");
        }
        closeable = new FileReader((File)serializable);
        int n = 0;
        while (codec.skipTo((FileReader)closeable, "<BEA-002031>") > 0) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            codec.skipTo((FileReader)closeable, "\n");
            while (codec.readHexLine((FileReader)closeable, byteArrayOutputStream) > 0) {
                codec.skipTo((FileReader)closeable, "\n");
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (getopt2.hasOption("rewrite")) {
                if (string2 == null) {
                    string2 = "message" + n++ + ".msg";
                }
                FileWriter fileWriter = new FileWriter(string2 == null ? "message" + n++ + ".msg" : string2);
                if (bl) {
                    codec.rewriteWithCDR(byArray, clazz, fileWriter);
                } else {
                    codec.rewriteWithWLS(byArray, clazz, fileWriter);
                }
                fileWriter.close();
                continue;
            }
            if (bl2) {
                codec.readWithWLS(byArray, clazz);
                continue;
            }
            if (!bl) continue;
            codec.readWithCDR(byArray, clazz);
        }
        ((InputStreamReader)closeable).close();
    }

    private static void readWithWLS(byte[] byArray, Class clazz) {
        IIOPInputStream iIOPInputStream = new IIOPInputStream(byArray);
        Message message = codec.createMessage(iIOPInputStream);
        if (clazz != null && message instanceof ReplyMessage) {
            Serializable serializable = message.getInputStream().read_value(clazz);
            codec.debug("Read return value: " + serializable);
        }
        iIOPInputStream.close();
    }

    private static void rewriteWithWLS(byte[] byArray, Class clazz, FileWriter fileWriter) throws IOException {
        IIOPInputStream iIOPInputStream = new IIOPInputStream(byArray);
        IIOPOutputStream iIOPOutputStream = new IIOPOutputStream();
        codec.rewrite(iIOPInputStream, clazz, iIOPOutputStream, fileWriter);
    }

    private static void rewriteWithCDR(byte[] byArray, Class clazz, FileWriter fileWriter) throws IOException {
        IIOPInputStream iIOPInputStream = new IIOPInputStream(byArray);
        org.omg.CORBA_2_3.portable.OutputStream outputStream = codec.createCDROutputStream();
        codec.rewrite(iIOPInputStream, clazz, outputStream, fileWriter);
    }

    private static void rewrite(InputStream inputStream, Class clazz, org.omg.CORBA_2_3.portable.OutputStream outputStream, FileWriter fileWriter) throws IOException {
        byte[] byArray = codec.readMessage(inputStream);
        outputStream.write_octet_array(byArray, 0, byArray.length);
        if (byArray.length % 8 > 0) {
            for (int i = 0; i < 8 - byArray.length % 8; ++i) {
                inputStream.read_octet();
                outputStream.write_octet((byte)0);
            }
        }
        if (clazz != null) {
            Serializable serializable = inputStream.read_value(clazz);
            codec.debug("Read return value: " + serializable);
            outputStream.write_value(serializable);
        }
        codec.dumpBuffer(outputStream, fileWriter);
        inputStream.close();
    }

    private static byte[] readMessage(InputStream inputStream) throws IOException {
        int n;
        org.omg.CORBA_2_3.portable.OutputStream outputStream = (org.omg.CORBA_2_3.portable.OutputStream)inputStream.orb().create_output_stream();
        for (n = 0; n < 5; ++n) {
            outputStream.write_long(inputStream.read_long());
        }
        n = inputStream.read_long();
        outputStream.write_long(n);
        for (int i = 0; i < n; ++i) {
            outputStream.write_long(inputStream.read_long());
            int n2 = inputStream.read_long();
            byte[] byArray = new byte[n2];
            inputStream.read_octet_array(byArray, 0, n2);
            outputStream.write_long(n2);
            outputStream.write_octet_array(byArray, 0, n2);
        }
        byte[] byArray = codec.streamToBuf(outputStream);
        outputStream.close();
        return byArray;
    }

    private static void writeValue(org.omg.CORBA_2_3.portable.OutputStream outputStream, Serializable serializable, FileWriter fileWriter) throws IOException {
        outputStream.write_value(serializable);
        codec.dumpBuffer(outputStream, fileWriter);
    }

    private static void dumpBuffer(org.omg.CORBA_2_3.portable.OutputStream outputStream, FileWriter fileWriter) throws IOException {
        String string = "<BEA-002031>\n";
        fileWriter.write(string, 0, string.length());
        byte[] byArray = codec.streamToBuf(outputStream);
        String string2 = Hex.dump((byte[])byArray, (int)0, (int)byArray.length);
        fileWriter.write(string2, 0, string2.length());
        fileWriter.write(">\n", 0, 2);
        outputStream.close();
    }

    public static byte[] streamToBuf(org.omg.CORBA_2_3.portable.OutputStream outputStream) throws IOException {
        InputStream inputStream = (InputStream)outputStream.create_input_stream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            while (true) {
                byteArrayOutputStream.write(inputStream.read_octet() & 0xFF);
            }
        }
        catch (MARSHAL mARSHAL) {
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            inputStream.close();
            return byArray;
        }
    }

    public static void readWithCDR(byte[] byArray, Class clazz) throws IOException {
        InputStream inputStream = codec.createCDRStream(byArray);
        codec.readMessage(inputStream);
        codec.debug("Reading value");
        Serializable serializable = inputStream.read_value(clazz);
        codec.debug("Read return value: " + serializable);
    }

    public static InputStream createCDRStream(byte[] byArray) throws IOException {
        Properties properties = new Properties();
        properties.put("org.omg.CORBA.ORBClass", "com.sun.corba.se.internal.POA.POAORB");
        ORB oRB = ORB.init((String[])new String[0], (Properties)properties);
        org.omg.CORBA_2_3.portable.OutputStream outputStream = (org.omg.CORBA_2_3.portable.OutputStream)oRB.create_output_stream();
        outputStream.write_octet_array(byArray, 0, byArray.length);
        InputStream inputStream = (InputStream)outputStream.create_input_stream();
        outputStream.close();
        return inputStream;
    }

    public static org.omg.CORBA_2_3.portable.OutputStream createCDROutputStream() throws IOException {
        Properties properties = new Properties();
        ORB oRB = ORB.init((String[])new String[0], (Properties)properties);
        return (org.omg.CORBA_2_3.portable.OutputStream)oRB.create_output_stream();
    }

    private static int readHexLine(FileReader fileReader, OutputStream outputStream) throws IOException {
        if (!fileReader.ready() || fileReader.read() == 62) {
            return -1;
        }
        fileReader.skip(6L);
        for (int i = 0; i < 8; ++i) {
            byte[] byArray = new byte[4];
            for (int j = 0; j < 4; ++j) {
                byArray[j] = (byte)(0xFF & fileReader.read());
            }
            byte[] byArray2 = Hex.fromHexString((byte[])byArray, (int)4);
            outputStream.write(byArray2);
            fileReader.skip(1L);
        }
        return 1;
    }

    private static int skipTo(FileReader fileReader, String string) throws IOException {
        block0: while (fileReader.ready()) {
            while (fileReader.ready() && fileReader.read() != string.charAt(0)) {
                ++fpos;
            }
            for (int i = 1; i < string.length(); ++i) {
                ++fpos;
                if (fileReader.read() != string.charAt(i)) continue block0;
            }
            return fpos;
        }
        return -1;
    }

    public static Message createMessage(IIOPInputStream iIOPInputStream) {
        MessageHeader messageHeader = new MessageHeader(iIOPInputStream);
        iIOPInputStream.setSupportsJDK13Chunking(messageHeader.getMinorVersion() < 2);
        switch (messageHeader.getMsgType()) {
            case 0: {
                return new RequestMessage(null, messageHeader, iIOPInputStream);
            }
            case 1: {
                return new ReplyMessage(null, messageHeader, iIOPInputStream);
            }
            case 7: {
                return new FragmentMessage(null, messageHeader, iIOPInputStream);
            }
        }
        codec.fatal("Unknown message type: " + messageHeader.getMsgType());
        return null;
    }

    private static void fatal(String string) {
        System.out.println(string);
        System.exit(-1);
    }

    private static void debug(String string) {
        System.out.println(string);
    }

    private static void skip(InputStream inputStream, long l) {
        int n = 0;
        while ((long)n < l) {
            inputStream.read_octet();
            ++n;
        }
    }
}

