/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop.csi;

import weblogic.corba.cos.security.GSSUtil;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IIOPOutputStream;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.Hex;

public class ASContextSec {
    private static final DebugLogger debugIIOPSecurity = DebugLogger.getDebugLogger((String)"DebugIIOPSecurity");
    private static final DebugCategory debugSecurity = Debug.getCategory((String)"weblogic.iiop.security");
    private short supports;
    private short requires;
    private byte[] clientAuthenticationMech;
    private byte[] targetName;

    public ASContextSec(boolean bl, boolean bl2) {
        this.supports = 0;
        if (bl) {
            this.supports = (short)64;
        }
        this.requires = 0;
        if (bl2) {
            this.requires = (short)(this.requires | 0x40);
        }
        this.clientAuthenticationMech = GSSUtil.getGSSUPMech();
        String string = "weblogicDEFAULT";
        this.targetName = GSSUtil.createGSSUPGSSNTExportedName(string);
    }

    ASContextSec(IIOPInputStream iIOPInputStream) {
        this.read(iIOPInputStream);
    }

    public final void read(IIOPInputStream iIOPInputStream) {
        this.supports = iIOPInputStream.read_short();
        this.requires = iIOPInputStream.read_short();
        this.clientAuthenticationMech = iIOPInputStream.read_octet_sequence();
        this.targetName = iIOPInputStream.read_octet_sequence();
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            ASContextSec.p("read " + this);
        }
    }

    public final void write(IIOPOutputStream iIOPOutputStream) {
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            ASContextSec.p("writing " + this);
        }
        iIOPOutputStream.write_short(this.supports);
        iIOPOutputStream.write_short(this.requires);
        iIOPOutputStream.write_octet_sequence(this.clientAuthenticationMech);
        iIOPOutputStream.write_octet_sequence(this.targetName);
    }

    public final boolean hasGSSUP() {
        return this.supports != 0 && GSSUtil.isGSSUPMech(this.clientAuthenticationMech);
    }

    public final byte[] getGSSUPTarget() {
        return this.targetName;
    }

    public short getSupports() {
        return this.supports;
    }

    public short getRequires() {
        return this.requires;
    }

    public String toString() {
        return "ASContextSec (supports = " + this.supports + ",requires = " + this.requires + ",clientAuthMech = " + Hex.dump((byte[])this.clientAuthenticationMech) + ",targetName = " + Hex.dump((byte[])this.targetName) + ")";
    }

    private static void p(String string) {
        IIOPLogger.logDebugSecurity((String)("<ASContextSec>: " + string));
    }
}

