/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop.csi;

import weblogic.iiop.ServiceContext;
import weblogic.iiop.VendorInfoSecurity;
import weblogic.iiop.csi.SASServiceContext;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.acl.internal.AuthenticatedUser;
import weblogic.security.service.SecurityServiceManager;

public final class ClientSecurityContext {
    private long clientContextId;
    private ServiceContext messageInContext;
    private boolean needCredentials = false;
    private boolean contextEstablished = false;

    public ClientSecurityContext(long l, SASServiceContext sASServiceContext) {
        this.clientContextId = l;
        this.messageInContext = sASServiceContext;
        this.needCredentials = true;
    }

    public ClientSecurityContext(AuthenticatedSubject authenticatedSubject) {
        this.clientContextId = -1L;
        this.needCredentials = false;
        if (SubjectUtils.isUserAnonymous((AuthenticatedSubject)authenticatedSubject) || SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject)) {
            this.messageInContext = VendorInfoSecurity.ANONYMOUS;
        } else {
            AuthenticatedUser authenticatedUser = SecurityServiceManager.convertToAuthenticatedUser((AuthenticatedUser)authenticatedSubject);
            this.messageInContext = new VendorInfoSecurity(authenticatedUser);
        }
    }

    public long getClientContextId() {
        return this.clientContextId;
    }

    public boolean needCredentials() {
        return this.needCredentials;
    }

    public void setNeedCredentials(boolean bl) {
        this.needCredentials = bl;
    }

    public void contextEstablished() {
        if (!this.contextEstablished) {
            this.messageInContext = new SASServiceContext(this.clientContextId);
            this.messageInContext.premarshal();
            this.contextEstablished = true;
        }
    }

    public ServiceContext getMessageInContext() {
        return this.messageInContext;
    }

    public String toString() {
        if (this.clientContextId >= 0L) {
            return this.messageInContext.toString() + " (context id==" + this.clientContextId + ")";
        }
        return this.messageInContext.toString();
    }
}

