/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop.csi;

import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.csi.ContextBody;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.Hex;

public class CompleteEstablishContext
implements ContextBody {
    private static final DebugLogger debugIIOPSecurity = DebugLogger.getDebugLogger((String)"DebugIIOPSecurity");
    private static final DebugCategory debugSecurity = Debug.getCategory((String)"weblogic.iiop.security");
    private long clientContextId;
    private boolean contextStateful;
    private byte[] finalContextToken;

    public CompleteEstablishContext() {
    }

    public CompleteEstablishContext(long l, boolean bl, byte[] byArray) {
        this.clientContextId = l;
        this.contextStateful = bl;
        this.finalContextToken = byArray;
    }

    protected CompleteEstablishContext(IIOPInputStream iIOPInputStream) {
        this.clientContextId = iIOPInputStream.read_longlong();
        this.contextStateful = iIOPInputStream.read_boolean();
        this.finalContextToken = iIOPInputStream.read_octet_sequence();
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            CompleteEstablishContext.p("read " + this);
        }
    }

    public long getClientContextId() {
        return this.clientContextId;
    }

    public boolean getContextStateful() {
        return this.contextStateful;
    }

    public byte[] getFinalContextToken() {
        return this.finalContextToken;
    }

    public void write(IIOPOutputStream iIOPOutputStream) {
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            CompleteEstablishContext.p("writing " + this);
        }
        iIOPOutputStream.write_longlong(this.clientContextId);
        iIOPOutputStream.write_boolean(this.contextStateful);
        iIOPOutputStream.write_octet_sequence(this.finalContextToken);
    }

    public String toString() {
        return "CompleteEstablishContext (clientContext = " + this.clientContextId + ", contextStateful = " + this.contextStateful + ", finalContextToken = " + Hex.dump((byte[])this.finalContextToken) + ")";
    }

    private static void p(String string) {
        IIOPLogger.logDebugSecurity((String)("<CompleteEstablishContext>: " + string));
    }
}

