/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop.csi;

import java.security.AccessController;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.Connection;
import weblogic.iiop.ConnectionKey;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.TLSSecTransComponent;
import weblogic.iiop.TaggedComponent;
import weblogic.iiop.csi.ASContextSec;
import weblogic.iiop.csi.SASContextSec;
import weblogic.kernel.Kernel;
import weblogic.management.configuration.SSLMBean;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.ServerIdentity;
import weblogic.rmi.internal.RuntimeDescriptor;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public class CompoundSecMech {
    private static final DebugLogger debugIIOPSecurity = DebugLogger.getDebugLogger((String)"DebugIIOPSecurity");
    private static final DebugCategory debugSecurity = Debug.getCategory((String)"weblogic.iiop.security");
    private short requires;
    private TaggedComponent transportMech;
    private ASContextSec asContextMech;
    private SASContextSec sasContextMech;
    private boolean foreign = false;
    private boolean requiresSSL = false;

    public CompoundSecMech() {
    }

    CompoundSecMech(IIOPInputStream iIOPInputStream, ServerIdentity serverIdentity) {
        this.read(iIOPInputStream, serverIdentity);
        this.foreign = true;
    }

    public CompoundSecMech(boolean bl, String string, ServerIdentity serverIdentity, RuntimeDescriptor runtimeDescriptor) {
        String string2;
        String string3;
        if (bl) {
            this.transportMech = new TLSSecTransComponent(string, serverIdentity, runtimeDescriptor);
            this.requires = ((TLSSecTransComponent)this.transportMech).getRequires();
        } else {
            this.transportMech = null;
        }
        if (runtimeDescriptor != null && runtimeDescriptor.getIntegrity() != null && "required".equals(runtimeDescriptor.getIntegrity())) {
            this.requiresSSL = true;
        }
        SSLMBean sSLMBean = Kernel.getConfig().getSSL();
        boolean bl2 = sSLMBean.isClientCertificateEnforced();
        boolean bl3 = false;
        try {
            bl3 = Connection.isValidDefaultUser();
            if (!bl3) {
                AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                bl3 = !ManagementService.getRuntimeAccess(authenticatedSubject).getDomain().getSecurity().isGuestDisabled();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl4 = true;
        boolean bl5 = false;
        if (!(bl3 || bl && bl && bl2)) {
            bl5 = true;
        }
        if (runtimeDescriptor != null && (string3 = runtimeDescriptor.getClientAuthentication()) != null) {
            if (string3.equals("none")) {
                bl4 = false;
                bl5 = false;
            } else if (string3.equals("supported")) {
                bl4 = true;
                bl5 = false;
            } else if (string3.equals("required")) {
                bl4 = true;
                bl5 = true;
            }
        }
        boolean bl6 = true;
        boolean bl7 = false;
        if (runtimeDescriptor != null && (string2 = runtimeDescriptor.getIdentityAssertion()) != null) {
            if (string2.equals("none")) {
                bl6 = false;
                bl7 = false;
            } else if (string2.equals("supported")) {
                bl6 = true;
                bl7 = false;
            } else if (string2.equals("required")) {
                bl6 = true;
                bl7 = false;
            }
        }
        this.asContextMech = new ASContextSec(bl4, bl5);
        this.requires = (short)(this.requires | this.asContextMech.getRequires());
        this.sasContextMech = new SASContextSec(bl6, bl7);
        this.requires = (short)(this.requires | this.sasContextMech.getRequires());
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            CompoundSecMech.p("created " + this);
        }
    }

    public final TaggedComponent getTransportMech() {
        return this.transportMech;
    }

    public final ASContextSec getASContextMech() {
        return this.asContextMech;
    }

    public final SASContextSec getSASContextMech() {
        return this.sasContextMech;
    }

    public final boolean useSAS() {
        if (this.asContextMech != null && this.asContextMech.hasGSSUP()) {
            return true;
        }
        return this.sasContextMech != null && this.sasContextMech.hasGSSUPIdentity();
    }

    public final boolean hasGSSUP() {
        return this.asContextMech != null && this.asContextMech.hasGSSUP();
    }

    public final boolean hasGSSUPIdentity() {
        return this.sasContextMech != null && this.sasContextMech.hasGSSUPIdentity();
    }

    public final byte[] getGSSUPTarget() {
        if (this.asContextMech == null) {
            return null;
        }
        return this.asContextMech.getGSSUPTarget();
    }

    public final String getSecureHost() {
        TLSSecTransComponent tLSSecTransComponent;
        ConnectionKey[] connectionKeyArray;
        if (this.transportMech != null && this.transportMech instanceof TLSSecTransComponent && (connectionKeyArray = (tLSSecTransComponent = (TLSSecTransComponent)this.transportMech).getAddresses()) != null) {
            return connectionKeyArray[0].getAddress();
        }
        return null;
    }

    public final int getSecurePort() {
        TLSSecTransComponent tLSSecTransComponent;
        ConnectionKey[] connectionKeyArray;
        if (this.transportMech != null && this.transportMech instanceof TLSSecTransComponent && (connectionKeyArray = (tLSSecTransComponent = (TLSSecTransComponent)this.transportMech).getAddresses()) != null) {
            return connectionKeyArray[0].getPort();
        }
        return -1;
    }

    public final void read(IIOPInputStream iIOPInputStream, ServerIdentity serverIdentity) {
        this.requires = iIOPInputStream.read_short();
        int n = iIOPInputStream.read_long();
        switch (n) {
            case 34: {
                TaggedComponent taggedComponent = new TaggedComponent(n, iIOPInputStream);
                this.transportMech = null;
                break;
            }
            case 36: {
                this.transportMech = new TLSSecTransComponent(iIOPInputStream, serverIdentity);
                break;
            }
            default: {
                this.transportMech = new TaggedComponent(n, iIOPInputStream);
            }
        }
        this.asContextMech = new ASContextSec(iIOPInputStream);
        this.sasContextMech = new SASContextSec(iIOPInputStream);
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            CompoundSecMech.p("read " + this);
        }
    }

    public final void write(IIOPOutputStream iIOPOutputStream) {
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            CompoundSecMech.p("writing " + this);
        }
        iIOPOutputStream.write_short(this.requires);
        if (this.transportMech != null && (this.foreign || this.requiresSSL || iIOPOutputStream.getServerChannel() == null || iIOPOutputStream.getServerChannel().supportsTLS())) {
            this.transportMech.write(iIOPOutputStream);
        } else {
            if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
                CompoundSecMech.p("no TLS");
            }
            iIOPOutputStream.write_long(34);
            iIOPOutputStream.write_long(0);
        }
        this.asContextMech.write(iIOPOutputStream);
        this.sasContextMech.write(iIOPOutputStream);
    }

    public String toString() {
        return "CompoundSecMech (requires = " + this.requires + "\n  tranport = " + this.transportMech + "\n  ASContext = " + this.asContextMech + "\n  SASContext = " + this.sasContextMech + ")";
    }

    protected static void p(String string) {
        IIOPLogger.logDebugSecurity((String)("<CompoundSecMech>: " + string));
    }
}

