/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop.csi;

import java.security.AccessController;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.TaggedComponent;
import weblogic.iiop.csi.CompoundSecMech;
import weblogic.kernel.Kernel;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.ServerIdentity;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.rmi.internal.RuntimeDescriptor;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public class CompoundSecMechList
extends TaggedComponent {
    private static final DebugLogger debugIIOPSecurity = DebugLogger.getDebugLogger((String)"DebugIIOPSecurity");
    private static final DebugCategory debugSecurity = Debug.getCategory((String)"weblogic.iiop.security");
    private boolean statefulContext = true;
    private boolean validDefaultIIOPUser = false;
    private int numSecMechs = 0;
    private CompoundSecMech[] secMechs;

    public CompoundSecMechList(String string, ServerIdentity serverIdentity, RuntimeDescriptor runtimeDescriptor) {
        super(33);
        boolean bl = false;
        if (Kernel.isServer()) {
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            bl = ChannelHelper.isSSLChannelEnabled(ManagementService.getRuntimeAccess(authenticatedSubject).getServer());
        }
        if (bl && runtimeDescriptor != null && runtimeDescriptor.getIntegrity() != null && "none".equals(runtimeDescriptor.getIntegrity())) {
            bl = false;
        }
        boolean bl2 = true;
        if (runtimeDescriptor != null && runtimeDescriptor.getIntegrity() != null && "required".equals(runtimeDescriptor.getIntegrity())) {
            bl2 = false;
        }
        this.statefulContext = runtimeDescriptor != null ? runtimeDescriptor.getStatefulAuthentication() : Kernel.getConfig().getIIOP().getUseStatefulAuthentication();
        this.numSecMechs = 0;
        if (bl) {
            ++this.numSecMechs;
        }
        if (bl2) {
            ++this.numSecMechs;
        }
        this.secMechs = new CompoundSecMech[this.numSecMechs];
        int n = 0;
        if (bl) {
            this.secMechs[n++] = new CompoundSecMech(true, string, serverIdentity, runtimeDescriptor);
        }
        if (bl2) {
            this.secMechs[n++] = new CompoundSecMech(false, string, serverIdentity, runtimeDescriptor);
        }
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            CompoundSecMechList.p("created " + this);
        }
    }

    public CompoundSecMechList(IIOPInputStream iIOPInputStream, ServerIdentity serverIdentity) {
        super(33);
        this.read(iIOPInputStream, serverIdentity);
    }

    public final CompoundSecMech[] getCompoundSecMechs() {
        return this.secMechs;
    }

    public final boolean useSAS() {
        for (int i = 0; i < this.numSecMechs; ++i) {
            if (!this.secMechs[i].useSAS()) continue;
            if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
                CompoundSecMechList.p("useSAS returns true");
            }
            return true;
        }
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            CompoundSecMechList.p("useSAS returns false " + this);
        }
        return false;
    }

    public final boolean hasGSSUP() {
        for (int i = 0; i < this.numSecMechs; ++i) {
            if (!this.secMechs[i].hasGSSUP()) continue;
            if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
                CompoundSecMechList.p("hasGSSUP returns true");
            }
            return true;
        }
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            CompoundSecMechList.p("hasGSSUP returns false " + this);
        }
        return false;
    }

    public final boolean hasGSSUPIdentity() {
        for (int i = 0; i < this.numSecMechs; ++i) {
            if (!this.secMechs[i].hasGSSUPIdentity()) continue;
            if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
                CompoundSecMechList.p("hasGSSUPIdentity returns true");
            }
            return true;
        }
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            CompoundSecMechList.p("hasGSSUPIdentity returns false " + this);
        }
        return false;
    }

    public final byte[] getGSSUPTarget() {
        for (int i = 0; i < this.numSecMechs; ++i) {
            byte[] byArray;
            if (!this.secMechs[i].hasGSSUP() || (byArray = this.secMechs[i].getGSSUPTarget()) == null) continue;
            if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
                CompoundSecMechList.p("getGSSUPTarget returns " + byArray);
            }
            return byArray;
        }
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            CompoundSecMechList.p("getGSSUPTarget returns null");
        }
        return null;
    }

    public final boolean isGSSUPTargetStateful() {
        return this.statefulContext;
    }

    public final String getSecureHost() {
        for (int i = 0; i < this.numSecMechs; ++i) {
            String string = this.secMechs[i].getSecureHost();
            if (string == null) continue;
            if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
                CompoundSecMechList.p("getSecureHost returns " + string);
            }
            return string;
        }
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            CompoundSecMechList.p("getSecureHost returns null");
        }
        return null;
    }

    public final int getSecurePort() {
        for (int i = 0; i < this.numSecMechs; ++i) {
            int n = this.secMechs[i].getSecurePort();
            if (n == -1) continue;
            if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
                CompoundSecMechList.p("getSecurePort returns " + n);
            }
            return n;
        }
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            CompoundSecMechList.p("getSecurePort returns -1");
        }
        return -1;
    }

    public final void read(IIOPInputStream iIOPInputStream, ServerIdentity serverIdentity) {
        long l = iIOPInputStream.startEncapsulation();
        this.statefulContext = iIOPInputStream.read_boolean();
        this.numSecMechs = iIOPInputStream.read_long();
        this.secMechs = new CompoundSecMech[this.numSecMechs];
        for (int i = 0; i < this.numSecMechs; ++i) {
            this.secMechs[i] = new CompoundSecMech(iIOPInputStream, serverIdentity);
        }
        iIOPInputStream.endEncapsulation(l);
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            CompoundSecMechList.p("read  " + this);
        }
    }

    public final void write(IIOPOutputStream iIOPOutputStream) {
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            CompoundSecMechList.p("writing " + this);
        }
        iIOPOutputStream.write_long(this.tag);
        long l = iIOPOutputStream.startEncapsulation();
        iIOPOutputStream.write_boolean(this.statefulContext);
        iIOPOutputStream.write_long(this.numSecMechs);
        for (int i = 0; i < this.numSecMechs; ++i) {
            this.secMechs[i].write(iIOPOutputStream);
        }
        iIOPOutputStream.endEncapsulation(l);
    }

    public String toString() {
        String string = "CompoundSecMechList (stateful = " + this.statefulContext + ",numSecMechs = " + this.numSecMechs + ", secMechs = ";
        for (int i = 0; i < this.numSecMechs; ++i) {
            string = string + this.secMechs[i];
        }
        return string + ")";
    }

    protected static void p(String string) {
        IIOPLogger.logDebugSecurity((String)("<CompoundSecMechList>: " + string));
    }
}

