/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop.csi;

import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.csi.ContextBody;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.Hex;

public class ContextError
implements ContextBody {
    private static final DebugLogger debugIIOPSecurity = DebugLogger.getDebugLogger((String)"DebugIIOPSecurity");
    private static final DebugCategory debugSecurity = Debug.getCategory((String)"weblogic.iiop.security");
    private long clientContextId;
    private int majorStatus;
    private int minorStatus;
    private byte[] errorToken;

    public ContextError() {
    }

    public ContextError(long l, int n, int n2, byte[] byArray) {
        this.clientContextId = l;
        this.majorStatus = n;
        this.minorStatus = n2;
        this.errorToken = byArray;
    }

    protected ContextError(IIOPInputStream iIOPInputStream) {
        this.clientContextId = iIOPInputStream.read_longlong();
        this.majorStatus = iIOPInputStream.read_long();
        this.minorStatus = iIOPInputStream.read_long();
        this.errorToken = iIOPInputStream.read_octet_sequence();
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            ContextError.p("read " + this);
        }
    }

    public long getClientContextId() {
        return this.clientContextId;
    }

    public int getMajorStatus() {
        return this.majorStatus;
    }

    public int getMinorStatus() {
        return this.minorStatus;
    }

    public byte[] getErrorToken() {
        return this.errorToken;
    }

    public void write(IIOPOutputStream iIOPOutputStream) {
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            ContextError.p("writing " + this);
        }
        iIOPOutputStream.write_longlong(this.clientContextId);
        iIOPOutputStream.write_long(this.majorStatus);
        iIOPOutputStream.write_long(this.minorStatus);
        iIOPOutputStream.write_octet_sequence(this.errorToken);
    }

    public String toString() {
        return "ContextError (clientContext = " + this.clientContextId + ", major = " + this.majorStatus + ", minor = " + this.minorStatus + ", errorToken = " + Hex.dump((byte[])this.errorToken) + ")";
    }

    private static void p(String string) {
        IIOPLogger.logDebugSecurity((String)("<ContextError>: " + string));
    }
}

