/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop.csi;

import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.csi.ContextBody;
import weblogic.iiop.csi.IdentityToken;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public class EstablishContext
implements ContextBody {
    private static final DebugLogger debugIIOPSecurity = DebugLogger.getDebugLogger((String)"DebugIIOPSecurity");
    private static final DebugCategory debugSecurity = Debug.getCategory((String)"weblogic.iiop.security");
    private long clientContextId;
    private IdentityToken identityToken;
    private byte[] clientAuthenticationToken;

    public EstablishContext() {
    }

    public EstablishContext(long l, byte[] byArray, IdentityToken identityToken) {
        this.clientContextId = l;
        this.identityToken = identityToken;
        this.clientAuthenticationToken = byArray;
    }

    protected EstablishContext(IIOPInputStream iIOPInputStream) {
        this.clientContextId = iIOPInputStream.read_longlong();
        this.skipAuthorizationToken(iIOPInputStream);
        this.identityToken = new IdentityToken(iIOPInputStream);
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            EstablishContext.p("read " + this);
        }
        this.clientAuthenticationToken = iIOPInputStream.read_octet_sequence();
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            EstablishContext.p("read " + this);
        }
    }

    public long getClientContextId() {
        return this.clientContextId;
    }

    public IdentityToken getIdentityToken() {
        return this.identityToken;
    }

    public byte[] getClientAuthenticationToken() {
        return this.clientAuthenticationToken;
    }

    public void write(IIOPOutputStream iIOPOutputStream) {
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            EstablishContext.p("writing " + this);
        }
        iIOPOutputStream.write_longlong(this.clientContextId);
        iIOPOutputStream.write_long(0);
        if (this.identityToken == null) {
            iIOPOutputStream.write_long(0);
            iIOPOutputStream.write_boolean(true);
        } else {
            this.identityToken.write(iIOPOutputStream);
        }
        iIOPOutputStream.write_octet_sequence(this.clientAuthenticationToken);
    }

    protected void skipAuthorizationToken(IIOPInputStream iIOPInputStream) {
        int n = iIOPInputStream.read_long();
        for (int i = 0; i < n; ++i) {
            iIOPInputStream.read_long();
            iIOPInputStream.read_octet_sequence();
        }
    }

    public String toString() {
        return "EstablishContext (clientContext = " + this.clientContextId + "\n   identityToken = " + this.identityToken + ")";
    }

    private static void p(String string) {
        IIOPLogger.logDebugSecurity((String)("<EstablishContext>: " + string));
    }
}

