/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop.csi;

import java.io.UnsupportedEncodingException;
import weblogic.corba.cos.security.GSSUtil;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.csi.GSSUPDecodeException;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public class GSSUPImpl {
    private static final DebugLogger debugIIOPSecurity = DebugLogger.getDebugLogger((String)"DebugIIOPSecurity");
    private static final DebugCategory debugSecurity = Debug.getCategory((String)"weblogic.iiop.security");
    private String userName;
    private String userNameScope;
    private String password;
    private String targetName;

    public GSSUPImpl(byte[] byArray) throws GSSUPDecodeException {
        byte[] byArray2 = GSSUtil.getGSSUPInnerToken(byArray);
        if (byArray2 == null) {
            throw new GSSUPDecodeException("Invalid or unsupported GSS Token");
        }
        IIOPInputStream iIOPInputStream = new IIOPInputStream(byArray2);
        iIOPInputStream.consumeEndian();
        byte[] byArray3 = iIOPInputStream.read_octet_sequence();
        byte[] byArray4 = iIOPInputStream.read_octet_sequence();
        byte[] byArray5 = iIOPInputStream.read_octet_sequence();
        try {
            this.userName = new String(byArray3, "UTF8");
            int n = this.userName.lastIndexOf(64);
            if (n == 0) {
                this.userName = "";
                this.userNameScope = this.userName.substring(n + 1);
            } else if (n > 0) {
                if (this.userName.charAt(n - 1) != '\\') {
                    this.userNameScope = this.userName.substring(n + 1);
                    this.userName = GSSUtil.getUnquotedGSSUserName(this.userName.substring(0, n));
                } else {
                    this.userName = GSSUtil.getUnquotedGSSUserName(this.userName);
                }
            }
            this.password = byArray4 != null && byArray4.length > 0 ? new String(byArray4, "UTF8") : "";
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new GSSUPDecodeException("Error decoding UTF8 user and password", unsupportedEncodingException);
        }
        this.targetName = GSSUtil.extractGSSUPGSSNTExportedName(byArray5);
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            GSSUPImpl.p("created " + this);
        }
    }

    public GSSUPImpl(String string, String string2, String string3, String string4) {
        this.userName = GSSUtil.getQuotedGSSUserName(string);
        this.userNameScope = string2;
        this.password = string3;
        this.targetName = string4;
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            GSSUPImpl.p("created from strings " + this);
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserNameScope() {
        return this.userNameScope;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public byte[] getBytes() {
        try {
            String string = this.userName;
            if (this.userNameScope != null) {
                string = string + "@" + this.userNameScope;
            }
            byte[] byArray = string.getBytes("UTF8");
            byte[] byArray2 = this.password.getBytes("UTF8");
            byte[] byArray3 = GSSUtil.createGSSUPGSSNTExportedName(this.targetName);
            IIOPOutputStream iIOPOutputStream = new IIOPOutputStream();
            iIOPOutputStream.putEndian();
            iIOPOutputStream.write_octet_sequence(byArray);
            iIOPOutputStream.write_octet_sequence(byArray2);
            iIOPOutputStream.write_octet_sequence(byArray3);
            byte[] byArray4 = iIOPOutputStream.getBuffer();
            return GSSUtil.getGSSUPToken(byArray4);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public String toString() {
        return "GSSUPImpl (user= " + this.userName + ", scope=" + this.userNameScope + ", target= " + this.targetName + ")";
    }

    private static void p(String string) {
        IIOPLogger.logDebugSecurity((String)("<GSSUPImpl>: " + string));
    }
}

