/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop.csi;

import java.util.Arrays;
import org.omg.CORBA.MARSHAL;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IIOPOutputStream;
import weblogic.utils.ArrayUtils;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.Hex;

public class IdentityToken {
    private static final DebugLogger debugIIOPSecurity = DebugLogger.getDebugLogger((String)"DebugIIOPSecurity");
    private static final DebugCategory debugSecurity = Debug.getCategory((String)"weblogic.iiop.security");
    private int identityType;
    private boolean absent;
    private boolean anonymous;
    private byte[] principalName;
    private byte[] certChain;
    private byte[] distinguishedName;
    private int hash;

    public IdentityToken() {
    }

    public IdentityToken(int n, boolean bl, byte[] byArray) {
        this.identityType = n;
        switch (this.identityType) {
            case 0: {
                this.absent = bl;
                break;
            }
            case 1: {
                this.anonymous = bl;
                break;
            }
            case 2: {
                this.principalName = byArray;
                break;
            }
            case 4: {
                this.certChain = byArray;
                break;
            }
            case 8: {
                this.distinguishedName = byArray;
                break;
            }
            default: {
                throw new MARSHAL("Unsupported Identity Type.");
            }
        }
        this.hash = n ^ ArrayUtils.hashCode((byte[])byArray);
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            IdentityToken.p("created " + this);
        }
    }

    protected IdentityToken(IIOPInputStream iIOPInputStream) {
        this.identityType = iIOPInputStream.read_long();
        switch (this.identityType) {
            case 0: {
                this.absent = iIOPInputStream.read_boolean();
                this.hash = this.identityType ^ 0;
                break;
            }
            case 1: {
                this.anonymous = iIOPInputStream.read_boolean();
                this.hash = this.identityType ^ 0;
                break;
            }
            case 2: {
                long l = iIOPInputStream.startEncapsulation();
                this.principalName = iIOPInputStream.read_octet_sequence();
                iIOPInputStream.endEncapsulation(l);
                this.hash = this.identityType ^ ArrayUtils.hashCode((byte[])this.principalName);
                break;
            }
            case 4: {
                long l = iIOPInputStream.startEncapsulation();
                this.certChain = iIOPInputStream.read_octet_sequence();
                iIOPInputStream.endEncapsulation(l);
                this.hash = this.identityType ^ ArrayUtils.hashCode((byte[])this.certChain);
                break;
            }
            case 8: {
                long l = iIOPInputStream.startEncapsulation();
                this.distinguishedName = iIOPInputStream.read_octet_sequence();
                iIOPInputStream.endEncapsulation(l);
                this.hash = this.identityType ^ ArrayUtils.hashCode((byte[])this.distinguishedName);
                break;
            }
            default: {
                throw new MARSHAL("Unsupported Identity Type.");
            }
        }
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            IdentityToken.p("read " + this);
        }
    }

    public int getIdentityType() {
        return this.identityType;
    }

    public boolean getAbsent() {
        return this.absent;
    }

    public boolean getAnonymous() {
        return this.anonymous;
    }

    public byte[] getPrincipalName() {
        return this.principalName;
    }

    public byte[] getCertChain() {
        return this.certChain;
    }

    public byte[] getDistinguishedName() {
        return this.distinguishedName;
    }

    public void write(IIOPOutputStream iIOPOutputStream) {
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            IdentityToken.p("writing " + this);
        }
        iIOPOutputStream.write_long(this.identityType);
        switch (this.identityType) {
            case 0: {
                iIOPOutputStream.write_boolean(this.absent);
                break;
            }
            case 1: {
                iIOPOutputStream.write_boolean(this.anonymous);
                break;
            }
            case 2: {
                long l = iIOPOutputStream.startEncapsulation();
                iIOPOutputStream.write_octet_sequence(this.principalName);
                iIOPOutputStream.endEncapsulation(l);
                break;
            }
            case 4: {
                long l = iIOPOutputStream.startEncapsulation();
                iIOPOutputStream.write_octet_sequence(this.certChain);
                iIOPOutputStream.endEncapsulation(l);
                break;
            }
            case 8: {
                long l = iIOPOutputStream.startEncapsulation();
                iIOPOutputStream.write_octet_sequence(this.distinguishedName);
                iIOPOutputStream.endEncapsulation(l);
                break;
            }
            default: {
                throw new MARSHAL("Unsupported Identity Type.");
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof IdentityToken) {
            IdentityToken identityToken = (IdentityToken)object;
            if (this.identityType != identityToken.identityType) {
                return false;
            }
            switch (this.identityType) {
                case 0: 
                case 1: {
                    return true;
                }
                case 2: {
                    return Arrays.equals(this.principalName, identityToken.principalName);
                }
                case 4: {
                    return Arrays.equals(this.certChain, identityToken.certChain);
                }
                case 8: {
                    return Arrays.equals(this.distinguishedName, identityToken.distinguishedName);
                }
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        String string = "IdentityToken (IdentityType = " + this.identityType;
        switch (this.identityType) {
            case 0: {
                string = string + ", absent = " + this.absent;
                break;
            }
            case 1: {
                string = string + ", anonymous = " + this.anonymous;
                break;
            }
            case 2: {
                string = string + ", principal = " + Hex.dump((byte[])this.principalName);
                break;
            }
            case 4: {
                string = string + ", certChain = " + Hex.dump((byte[])this.certChain);
                break;
            }
            case 8: {
                string = string + ", distinguished = " + Hex.dump((byte[])this.distinguishedName);
                break;
            }
            default: {
                string = string + "Unsupported Identity Type.";
            }
        }
        return string;
    }

    private static void p(String string) {
        IIOPLogger.logDebugSecurity((String)("<IdentityToken>: " + string));
    }
}

