/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop.csi;

import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.csi.ContextBody;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public class MessageInContext
implements ContextBody {
    private static final DebugLogger debugIIOPSecurity = DebugLogger.getDebugLogger((String)"DebugIIOPSecurity");
    private static final DebugCategory debugSecurity = Debug.getCategory((String)"weblogic.iiop.security");
    private long clientContextId;
    private boolean discardContext;

    public MessageInContext() {
    }

    public MessageInContext(long l, boolean bl) {
        this.clientContextId = l;
        this.discardContext = bl;
    }

    protected MessageInContext(IIOPInputStream iIOPInputStream) {
        this.clientContextId = iIOPInputStream.read_longlong();
        this.discardContext = iIOPInputStream.read_boolean();
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            MessageInContext.p("read " + this);
        }
    }

    public long getClientContextId() {
        return this.clientContextId;
    }

    public boolean getDiscardContext() {
        return this.discardContext;
    }

    public void write(IIOPOutputStream iIOPOutputStream) {
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            MessageInContext.p("writing " + this);
        }
        iIOPOutputStream.write_longlong(this.clientContextId);
        iIOPOutputStream.write_boolean(this.discardContext);
    }

    public String toString() {
        return "MessageInContext (clientContext = " + this.clientContextId + ", discardContext = " + this.discardContext + ")";
    }

    private static void p(String string) {
        IIOPLogger.logDebugSecurity((String)("<MessageInContext>: " + string));
    }
}

