/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop.csi;

import java.security.AccessController;
import weblogic.corba.cos.security.GSSUtil;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IIOPOutputStream;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public class SASContextSec {
    private static final DebugLogger debugIIOPSecurity = DebugLogger.getDebugLogger((String)"DebugIIOPSecurity");
    private static final DebugCategory debugSecurity = Debug.getCategory((String)"weblogic.iiop.security");
    private static final int SupportedTypes = 15;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private short supports = 0;
    private short requires = 0;
    private int supportedIdentityTypes = 0;
    private int numAuthorities = 0;
    private int numOIDs = 0;
    private byte[][] oidSequences;

    public SASContextSec(boolean bl, boolean bl2) {
        this.supportedIdentityTypes = this.getSupportedTypes();
        this.supports = 0;
        if (bl && this.supportedIdentityTypes != 0) {
            this.supports = (short)1024;
        }
        this.requires = 0;
        if (bl2 && this.supportedIdentityTypes != 0) {
            this.requires = (short)1024;
        }
        this.numOIDs = 1;
        this.oidSequences = new byte[this.numOIDs][];
        this.oidSequences[0] = GSSUtil.getGSSUPMech();
    }

    SASContextSec(IIOPInputStream iIOPInputStream) {
        this.read(iIOPInputStream);
    }

    public final void read(IIOPInputStream iIOPInputStream) {
        int n;
        this.supports = iIOPInputStream.read_short();
        this.requires = iIOPInputStream.read_short();
        this.numAuthorities = iIOPInputStream.read_long();
        for (n = 0; n < this.numAuthorities; ++n) {
            iIOPInputStream.read_long();
            iIOPInputStream.read_octet_sequence();
        }
        this.numOIDs = iIOPInputStream.read_long();
        if (this.numOIDs > 0) {
            this.oidSequences = new byte[this.numOIDs][];
        }
        for (n = 0; n < this.numOIDs; ++n) {
            this.oidSequences[n] = iIOPInputStream.read_octet_sequence();
        }
        this.supportedIdentityTypes = iIOPInputStream.read_long();
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            SASContextSec.p("read " + this);
        }
    }

    public final void write(IIOPOutputStream iIOPOutputStream) {
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            SASContextSec.p("writing " + this);
        }
        iIOPOutputStream.write_short(this.supports);
        iIOPOutputStream.write_short(this.requires);
        iIOPOutputStream.write_long(0);
        if (this.supports != 0) {
            iIOPOutputStream.write_long(this.numOIDs);
            for (int i = 0; i < this.numOIDs; ++i) {
                iIOPOutputStream.write_octet_sequence(this.oidSequences[i]);
            }
            iIOPOutputStream.write_long(this.supportedIdentityTypes);
        } else {
            iIOPOutputStream.write_long(0);
            iIOPOutputStream.write_long(0);
        }
    }

    public short getSupports() {
        return this.supports;
    }

    public short getRequires() {
        return this.requires;
    }

    public final boolean hasGSSUPIdentity() {
        if ((this.supports & 0x400) == 0) {
            return false;
        }
        if ((this.supportedIdentityTypes & 0xF) == 0) {
            return false;
        }
        for (int i = 0; i < this.numOIDs; ++i) {
            if (!GSSUtil.isGSSUPMech(this.oidSequences[i])) continue;
            return true;
        }
        return false;
    }

    private int getSupportedTypes() {
        int n = 0;
        String string = "weblogicDEFAULT";
        PrincipalAuthenticator principalAuthenticator = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)kernelId, (String)string, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
        if (principalAuthenticator.isTokenTypeSupported("CSI.ITTAnonymous")) {
            n |= 1;
        }
        if (principalAuthenticator.isTokenTypeSupported("CSI.PrincipalName")) {
            n |= 2;
        }
        if (principalAuthenticator.isTokenTypeSupported("CSI.X509CertChain")) {
            n |= 4;
        }
        if (principalAuthenticator.isTokenTypeSupported("CSI.DistinguishedName")) {
            n |= 8;
        }
        return n;
    }

    public String toString() {
        return "SASContextSec (supports = " + this.supports + ",requires = " + this.requires + ")";
    }

    private static void p(String string) {
        IIOPLogger.logDebugSecurity((String)("<SASContextSec>: " + string));
    }
}

