/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop.csi;

import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import weblogic.corba.cos.security.GSSUtil;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.EndPoint;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.ReplyMessage;
import weblogic.iiop.RequestMessage;
import weblogic.iiop.ServiceContext;
import weblogic.iiop.ServiceContextList;
import weblogic.iiop.csi.ClientSecurityContext;
import weblogic.iiop.csi.CompleteEstablishContext;
import weblogic.iiop.csi.CompoundSecMechList;
import weblogic.iiop.csi.ContextBody;
import weblogic.iiop.csi.ContextError;
import weblogic.iiop.csi.EstablishContext;
import weblogic.iiop.csi.GSSUPDecodeException;
import weblogic.iiop.csi.GSSUPImpl;
import weblogic.iiop.csi.IdentityToken;
import weblogic.iiop.csi.MessageInContext;
import weblogic.iiop.csi.SecurityContext;
import weblogic.kernel.Kernel;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.security.SimpleCallbackHandler;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.auth.login.PasswordCredential;
import weblogic.security.service.CredentialManager;
import weblogic.security.service.InvalidParameterException;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.RemoteResource;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.spi.Resource;
import weblogic.security.subject.AbstractSubject;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public class SASServiceContext
extends ServiceContext {
    private short ctxMsgType;
    private ContextBody ctxBody;
    private AuthenticatedSubject subject;
    private static final DebugCategory debugSecurity = Debug.getCategory((String)"weblogic.iiop.security");
    private static final DebugLogger debugIIOPSecurity = DebugLogger.getDebugLogger((String)"DebugIIOPSecurity");
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public SASServiceContext() {
        super(15);
    }

    public SASServiceContext(short s, ContextBody contextBody, AuthenticatedSubject authenticatedSubject) {
        super(15);
        this.ctxMsgType = s;
        this.ctxBody = contextBody;
        this.subject = authenticatedSubject;
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            SASServiceContext.log("created " + this);
        }
    }

    public SASServiceContext(CompoundSecMechList compoundSecMechList, AuthenticatedSubject authenticatedSubject, EndPoint endPoint) {
        super(15);
        Object object;
        this.ctxMsgType = 0;
        long l = 0L;
        if (compoundSecMechList.isGSSUPTargetStateful()) {
            l = endPoint.getNextClientContextId();
        }
        byte[] byArray = null;
        IdentityToken identityToken = null;
        PasswordCredential passwordCredential = SASServiceContext.getPasswordCredential(authenticatedSubject, endPoint);
        String string = null;
        boolean bl = compoundSecMechList.hasGSSUP();
        boolean bl2 = compoundSecMechList.hasGSSUPIdentity();
        if (bl) {
            object = compoundSecMechList.getGSSUPTarget();
            string = GSSUtil.extractGSSUPGSSNTExportedName(object);
        }
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            SASServiceContext.log("create sasservice target: " + string + " hasGSSUP: " + bl + " hasIdentity: " + bl2 + " pc: " + passwordCredential);
        }
        if (bl && passwordCredential != null) {
            object = new GSSUPImpl(passwordCredential.getUsername(), string, passwordCredential.getPassword(), string);
            byArray = object.getBytes();
            identityToken = new IdentityToken(0, true, null);
        } else if (bl2) {
            if (authenticatedSubject == null || SubjectUtils.isUserAnonymous((AuthenticatedSubject)authenticatedSubject) || SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject)) {
                identityToken = new IdentityToken(1, true, null);
            } else {
                object = SubjectUtils.getUsername((AuthenticatedSubject)authenticatedSubject);
                if (string != null) {
                    object = (String)object + "@" + string;
                }
                byte[] byArray2 = GSSUtil.createGSSUPGSSNTExportedName((String)object);
                identityToken = new IdentityToken(2, true, byArray2);
            }
        }
        this.ctxBody = new EstablishContext(l, byArray, identityToken);
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            SASServiceContext.log("created " + this);
        }
    }

    public SASServiceContext(long l) {
        super(15);
        this.ctxMsgType = (short)5;
        this.ctxBody = new MessageInContext(l, false);
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            SASServiceContext.log("created " + this);
        }
    }

    public SASServiceContext(IIOPInputStream iIOPInputStream) {
        super(15);
        this.readEncapsulatedContext(iIOPInputStream);
    }

    protected void readEncapsulation(IIOPInputStream iIOPInputStream) {
        short s = iIOPInputStream.read_short();
        switch (s) {
            case 0: {
                this.ctxBody = new EstablishContext(iIOPInputStream);
                break;
            }
            case 1: {
                this.ctxBody = new CompleteEstablishContext(iIOPInputStream);
                break;
            }
            case 4: {
                this.ctxBody = new ContextError(iIOPInputStream);
                break;
            }
            case 5: {
                this.ctxBody = new MessageInContext(iIOPInputStream);
                break;
            }
            default: {
                throw new MARSHAL("Unsupported CSI MsgType.");
            }
        }
        this.ctxMsgType = s;
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            SASServiceContext.log("read " + this);
        }
    }

    public short getMsgType() {
        return this.ctxMsgType;
    }

    public ContextBody getBody() {
        return this.ctxBody;
    }

    public void write(IIOPOutputStream iIOPOutputStream) {
        this.writeEncapsulatedContext(iIOPOutputStream);
    }

    public void writeEncapsulation(IIOPOutputStream iIOPOutputStream) {
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            SASServiceContext.log("writing " + this);
        }
        iIOPOutputStream.write_short(this.ctxMsgType);
        this.ctxBody.write(iIOPOutputStream);
    }

    public void handleSASReply(EndPoint endPoint) {
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            SASServiceContext.log("handle SAS Reply " + this);
        }
        switch (this.ctxMsgType) {
            case 1: {
                CompleteEstablishContext completeEstablishContext = (CompleteEstablishContext)this.ctxBody;
                if (completeEstablishContext.getContextStateful()) {
                    endPoint.establishSASClientContext(completeEstablishContext.getClientContextId());
                    if (!debugSecurity.isEnabled() && !debugIIOPSecurity.isDebugEnabled()) break;
                    IIOPLogger.logDebugSecurity((String)"stateful CSIv2 session established.");
                    break;
                }
                endPoint.removeSASClientContext(completeEstablishContext.getClientContextId());
                if (!debugSecurity.isEnabled() && !debugIIOPSecurity.isDebugEnabled()) break;
                IIOPLogger.logDebugSecurity((String)"stateful CSIv2 session reset.");
                break;
            }
            case 4: {
                ContextError contextError = (ContextError)this.ctxBody;
                endPoint.removeSASClientContext(contextError.getClientContextId());
                if (!debugSecurity.isEnabled() && !debugIIOPSecurity.isDebugEnabled()) break;
                IIOPLogger.logDebugSecurity((String)("received ContextError(" + contextError.getMajorStatus() + ", " + contextError.getMinorStatus() + ") for context " + contextError.getClientContextId()));
                break;
            }
            default: {
                throw new MARSHAL("Unsupported Reply CSI MsgType.");
            }
        }
    }

    public boolean handleSASRequest(RequestMessage requestMessage, EndPoint endPoint) {
        Object object;
        Object object2;
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            SASServiceContext.log("handle SAS Request ");
        }
        boolean bl = false;
        ContextError contextError = null;
        switch (this.ctxMsgType) {
            case 0: {
                contextError = this.handleEstablishContext(endPoint);
                break;
            }
            case 5: {
                object2 = (MessageInContext)this.ctxBody;
                object = endPoint.getSecurityContext(((MessageInContext)object2).getClientContextId());
                if (object != null) {
                    this.subject = ((SecurityContext)object).getSubject();
                    if (!((MessageInContext)object2).getDiscardContext()) break;
                    endPoint.removeSecurityContext(((MessageInContext)object2).getClientContextId());
                    break;
                }
                contextError = new ContextError(((MessageInContext)object2).getClientContextId(), 4, 1, null);
                break;
            }
            default: {
                throw new MARSHAL("Unsupported Request CSI MsgType.");
            }
        }
        if (contextError != null) {
            if (debugSecurity.isEnabled() || debugIIOPSecurity.isDebugEnabled()) {
                IIOPLogger.logDebugSecurity((String)"CSIv2 context error.");
            }
            object2 = new SASServiceContext(4, contextError, null);
            object = new ServiceContextList();
            ((ServiceContextList)object).addServiceContext((ServiceContext)object2);
            ReplyMessage replyMessage = new ReplyMessage(endPoint, requestMessage, (ServiceContextList)object, 2);
            IIOPOutputStream iIOPOutputStream = replyMessage.getOutputStream();
            replyMessage.write(iIOPOutputStream);
            iIOPOutputStream.write_string("IDL:omg.org/CORBA/NO_PERMISSION:1.0");
            iIOPOutputStream.write_long(0);
            iIOPOutputStream.write_long(CompletionStatus.COMPLETED_NO.value());
            try {
                endPoint.send(iIOPOutputStream);
            }
            catch (RemoteException remoteException) {
                throw new MARSHAL("Sending reply on SAS failure");
            }
            bl = true;
        }
        return bl;
    }

    public AuthenticatedSubject getSubject() {
        return this.subject;
    }

    public ClientSecurityContext getClientContext() {
        return new ClientSecurityContext(((EstablishContext)this.getBody()).getClientContextId(), this);
    }

    public SASServiceContext getCompleteEstablishContext() {
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            SASServiceContext.log("getCompleteEstablishContexst");
        }
        EstablishContext establishContext = (EstablishContext)this.ctxBody;
        CompleteEstablishContext completeEstablishContext = new CompleteEstablishContext(establishContext.getClientContextId(), establishContext.getClientContextId() != 0L, null);
        return new SASServiceContext(1, completeEstablishContext, this.subject);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private ContextError handleEstablishContext(EndPoint var1_1) {
        block48: {
            if (SASServiceContext.debugIIOPSecurity.isDebugEnabled() || SASServiceContext.debugSecurity.isEnabled()) {
                SASServiceContext.log("handleEstablishContext");
            }
            var2_2 = (EstablishContext)this.ctxBody;
            var3_3 = null;
            var4_4 = null;
            var5_5 = var2_2.getClientAuthenticationToken();
            var6_6 = var2_2.getIdentityToken();
            if (var2_2.getClientContextId() != 0L && (var3_3 = var1_1.getSecurityContext(var2_2.getClientContextId())) != null) {
                if (var6_6 != null && !var6_6.equals(var3_3.getEstablishContext().getIdentityToken())) {
                    if (SASServiceContext.debugSecurity.isEnabled() || SASServiceContext.debugIIOPSecurity.isDebugEnabled()) {
                        IIOPLogger.logDebugSecurity((String)"Invalid CSIv2 context token");
                    }
                    return new ContextError(var2_2.getClientContextId(), 3, 1, null);
                }
                if (var5_5 != null && !Arrays.equals(var5_5, var7_7 = var3_3.getEstablishContext().getClientAuthenticationToken())) {
                    if (SASServiceContext.debugSecurity.isEnabled() || SASServiceContext.debugIIOPSecurity.isDebugEnabled()) {
                        IIOPLogger.logDebugSecurity((String)"Invalid CSIv2 auth token");
                    }
                    return new ContextError(var2_2.getClientContextId(), 3, 1, null);
                }
                this.subject = var3_3.getSubject();
                return null;
            }
            if (var5_5 != null) {
                try {
                    var7_8 = new GSSUPImpl(var5_5);
                    if (SASServiceContext.debugIIOPSecurity.isDebugEnabled() || SASServiceContext.debugSecurity.isEnabled()) {
                        SASServiceContext.log("Handle establish username: " + var7_8.getUserName());
                    }
                    var8_11 /* !! */  = "weblogicDEFAULT";
                    var9_12 = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)SASServiceContext.kernelId, (String)var8_11 /* !! */ , (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
                    var10_14 /* !! */  = new SimpleCallbackHandler(var7_8.getUserName(), var7_8.getPassword());
                    this.subject = var9_12.authenticate((CallbackHandler)var10_14 /* !! */ , var1_1.getConnection().getContextHandler());
                    var11_16 = new PasswordCredential(var7_8.getUserName(), var7_8.getPassword());
                    this.subject.getPrivateCredentials((AbstractSubject)SASServiceContext.kernelId).add(var11_16);
                    if (ChannelHelper.isLocalAdminChannelEnabled() && SubjectUtils.isUserAnAdministrator((AuthenticatedSubject)this.subject) && !ChannelHelper.isAdminChannel((ServerChannel)var1_1.getServerChannel())) {
                        return new ContextError(var2_2.getClientContextId(), 1, 1, null);
                    }
                    if (SASServiceContext.debugIIOPSecurity.isDebugEnabled() || SASServiceContext.debugSecurity.isEnabled()) {
                        SASServiceContext.log("Created subject for username: " + var7_8.getUserName() + " subject: " + this.subject);
                    }
                }
                catch (GSSUPDecodeException var7_9) {
                    if (SASServiceContext.debugSecurity.isEnabled() || SASServiceContext.debugIIOPSecurity.isDebugEnabled()) {
                        IIOPLogger.logDebugSecurity((String)("Error decoding CSIv2 GSS token: " + var7_9.getMessage()));
                    }
                    return new ContextError(var2_2.getClientContextId(), 2, 1, null);
                }
                catch (LoginException var7_10) {
                    if (SASServiceContext.debugSecurity.isEnabled() || SASServiceContext.debugIIOPSecurity.isDebugEnabled()) {
                        IIOPLogger.logDebugSecurity((String)("CSIv2 login error: " + var7_10.getMessage()));
                    }
                    return new ContextError(var2_2.getClientContextId(), 1, 1, null);
                }
            }
            if (var6_6 == null) break block48;
            var7_8 = "weblogicDEFAULT";
            var8_11 /* !! */  = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)SASServiceContext.kernelId, (String)var7_8, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
            var9_13 = var6_6.getIdentityType();
            var4_4 = this.getAssertAsSubject();
            switch (var9_13) {
                case 0: {
                    break;
                }
                case 1: {
                    try {
                        var10_14 /* !! */  = var8_11 /* !! */ ;
                        var11_16 = var6_6;
                        var12_17 = var1_1;
                        this.subject = (AuthenticatedSubject)SecurityServiceManager.runAs((AuthenticatedSubject)SASServiceContext.kernelId, (AuthenticatedSubject)var4_4, (PrivilegedExceptionAction)new PrivilegedExceptionAction((IdentityToken)var11_16, var12_17){
                            final /* synthetic */ IdentityToken val$tok;
                            final /* synthetic */ EndPoint val$ep;
                            {
                                this.val$tok = identityToken;
                                this.val$ep = endPoint;
                            }

                            public Object run() throws LoginException {
                                return var10_14.assertIdentity("CSI.ITTAnonymous", (Object)new Boolean(this.val$tok.getAnonymous()), this.val$ep.getConnection().getContextHandler());
                            }
                        });
                    }
                    catch (PrivilegedActionException var10_15) {
                        var11_16 = (LoginException)var10_15.getException();
                        if (SASServiceContext.debugIIOPSecurity.isDebugEnabled() || SASServiceContext.debugSecurity.isEnabled()) {
                            SASServiceContext.log("failed identity assertion - use connection subject " + var11_16);
                        }
                        this.subject = null;
                    }
                    break;
                }
                case 2: {
                    var10_14 /* !! */  = (PrincipalAuthenticator)var6_6.getPrincipalName();
                    var11_16 = GSSUtil.extractGSSUPGSSNTExportedName((byte[])var10_14 /* !! */ );
                    var12_18 = null;
                    if (var11_16 == null) {
                        if (SASServiceContext.debugSecurity.isEnabled() || SASServiceContext.debugIIOPSecurity.isDebugEnabled()) {
                            IIOPLogger.logDebugSecurity((String)"Unsupported CSIv2 mechanism");
                        }
                        return new ContextError(var2_2.getClientContextId(), 2, 1, null);
                    }
                    var13_19 = var11_16.indexOf(64);
                    if (var13_19 < 0) ** GOTO lbl88
                    var12_18 = "weblogicDEFAULT";
                    var11_16 = var11_16.substring(0, var13_19);
                    try {
                        var8_11 /* !! */  = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)SASServiceContext.kernelId, (String)var12_18, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
                    }
                    catch (InvalidParameterException var14_20) {
                        if (!SASServiceContext.debugIIOPSecurity.isDebugEnabled() && !SASServiceContext.debugSecurity.isEnabled()) ** GOTO lbl88
                        SASServiceContext.log("Assert identity realm not found: " + var12_18);
                    }
lbl88:
                    // 4 sources

                    if (SASServiceContext.debugIIOPSecurity.isDebugEnabled() || SASServiceContext.debugSecurity.isEnabled()) {
                        SASServiceContext.log("Assert identity: " + (String)var11_16);
                    }
                    try {
                        var14_21 /* !! */  = var8_11 /* !! */ ;
                        var15_24 = var11_16;
                        var16_29 = var1_1;
                        this.subject = (AuthenticatedSubject)SecurityServiceManager.runAs((AuthenticatedSubject)SASServiceContext.kernelId, (AuthenticatedSubject)var4_4, (PrivilegedExceptionAction)new PrivilegedExceptionAction((String)var15_24, var16_29){
                            final /* synthetic */ String val$user;
                            final /* synthetic */ EndPoint val$ep;
                            {
                                this.val$user = string;
                                this.val$ep = endPoint;
                            }

                            public Object run() throws LoginException {
                                return var14_21.assertIdentity("CSI.PrincipalName", (Object)this.val$user, this.val$ep.getConnection().getContextHandler());
                            }
                        });
                        break;
                    }
                    catch (PrivilegedActionException var14_22) {
                        var15_25 = (LoginException)var14_22.getException();
                        if (SASServiceContext.debugSecurity.isEnabled() || SASServiceContext.debugIIOPSecurity.isDebugEnabled()) {
                            SASServiceContext.log("failed identity assertion prin " + var15_25);
                        }
                        return new ContextError(var2_2.getClientContextId(), 2, 1, null);
                    }
                }
                case 8: {
                    var14_23 = var6_6.getDistinguishedName();
                    if (var14_23 == null) {
                        if (SASServiceContext.debugSecurity.isEnabled() || SASServiceContext.debugIIOPSecurity.isDebugEnabled()) {
                            IIOPLogger.logDebugSecurity((String)"CSIv2 distinguished name not found");
                        }
                        return new ContextError(var2_2.getClientContextId(), 2, 1, null);
                    }
                    if (SASServiceContext.debugIIOPSecurity.isDebugEnabled() || SASServiceContext.debugSecurity.isEnabled()) {
                        SASServiceContext.log("Assert identity distinguished: " + var14_23);
                    }
                    try {
                        var15_26 /* !! */  = var8_11 /* !! */ ;
                        var16_30 = var14_23;
                        var17_33 = var1_1;
                        this.subject = (AuthenticatedSubject)SecurityServiceManager.runAs((AuthenticatedSubject)SASServiceContext.kernelId, (AuthenticatedSubject)var4_4, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                            public Object run() throws LoginException {
                                return var15_26.assertIdentity("CSI.DistinguishedName", (Object)var16_30, var17_33.getConnection().getContextHandler());
                            }
                        });
                        break;
                    }
                    catch (PrivilegedActionException var15_27) {
                        var16_31 = (LoginException)var15_27.getException();
                        if (SASServiceContext.debugSecurity.isEnabled() || SASServiceContext.debugIIOPSecurity.isDebugEnabled()) {
                            SASServiceContext.log("failed identity assertion dist name " + var16_31);
                        }
                        return new ContextError(var2_2.getClientContextId(), 2, 1, null);
                    }
                }
                case 4: {
                    var15_28 = var6_6.getCertChain();
                    var16_32 = GSSUtil.getX509CertChain(var15_28);
                    if (var16_32 == null) {
                        if (SASServiceContext.debugSecurity.isEnabled() || SASServiceContext.debugIIOPSecurity.isDebugEnabled()) {
                            IIOPLogger.logDebugSecurity((String)"CSIv2 certification chain not found");
                        }
                        return new ContextError(var2_2.getClientContextId(), 1, 1, null);
                    }
                    if (SASServiceContext.debugIIOPSecurity.isDebugEnabled() || SASServiceContext.debugSecurity.isEnabled()) {
                        SASServiceContext.log("Assert identity chain: " + var16_32);
                    }
                    try {
                        var17_34 /* !! */  = var8_11 /* !! */ ;
                        var18_36 = var16_32;
                        var19_38 = var1_1;
                        this.subject = (AuthenticatedSubject)SecurityServiceManager.runAs((AuthenticatedSubject)SASServiceContext.kernelId, (AuthenticatedSubject)var4_4, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                            public Object run() throws LoginException {
                                return var17_34.assertIdentity("CSI.X509CertChain", (Object)var18_36, var19_38.getConnection().getContextHandler());
                            }
                        });
                        break;
                    }
                    catch (PrivilegedActionException var17_35) {
                        var18_37 = (LoginException)var17_35.getException();
                        if (SASServiceContext.debugSecurity.isEnabled() || SASServiceContext.debugIIOPSecurity.isDebugEnabled()) {
                            SASServiceContext.log("failed identity assertion cert chain " + var18_37);
                        }
                        return new ContextError(var2_2.getClientContextId(), 2, 1, null);
                    }
                }
                default: {
                    if (SASServiceContext.debugSecurity.isEnabled() || SASServiceContext.debugIIOPSecurity.isDebugEnabled()) {
                        IIOPLogger.logDebugSecurity((String)"Unsupported CSIv2 mechanism");
                    }
                    return new ContextError(var2_2.getClientContextId(), 1, 1, null);
                }
            }
        }
        if (var2_2.getClientContextId() != 0L && var3_3 == null) {
            if (this.subject == null) {
                this.subject = SubjectUtils.getAnonymousSubject();
            }
            var3_3 = new SecurityContext(var2_2.getClientContextId(), var2_2, this.subject);
            var1_1.putSecurityContext(var2_2.getClientContextId(), var3_3);
        }
        return null;
    }

    private static final PasswordCredential getPasswordCredential(AuthenticatedSubject authenticatedSubject, EndPoint endPoint) {
        if (authenticatedSubject == null || SubjectUtils.isUserAnonymous((AuthenticatedSubject)authenticatedSubject)) {
            return null;
        }
        PasswordCredential passwordCredential = null;
        Set set = authenticatedSubject.getPrivateCredentials((AbstractSubject)kernelId, PasswordCredential.class);
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            passwordCredential = (PasswordCredential)iterator.next();
        }
        if (!Kernel.isServer()) {
            return passwordCredential;
        }
        if (authenticatedSubject.getPrincipals(UserInfo.class).size() > 0) {
            return passwordCredential;
        }
        CredentialManager credentialManager = (CredentialManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)kernelId, (String)"weblogicDEFAULT", (SecurityService.ServiceType)SecurityService.ServiceType.CREDENTIALMANAGER);
        if (credentialManager == null) {
            return passwordCredential;
        }
        Object[] objectArray = credentialManager.getCredentials(kernelId, authenticatedSubject, (Resource)new RemoteResource(endPoint.getConnection().getRemoteChannel().getProtocolPrefix(), endPoint.getConnection().getRemoteChannel().getPublicAddress(), Integer.toString(endPoint.getConnection().getRemoteChannel().getPublicPort()), null, null), endPoint.getConnection().getContextHandler(), "weblogic.Password");
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof PasswordCredential)) continue;
            if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
                SASServiceContext.log("Mapped subject: " + authenticatedSubject + " to " + object);
            }
            return (PasswordCredential)object;
        }
        if (debugIIOPSecurity.isDebugEnabled() || debugSecurity.isEnabled()) {
            SASServiceContext.log("No credential mapping for: " + authenticatedSubject + ",  will use defaults: " + passwordCredential);
        }
        return passwordCredential;
    }

    public String toString() {
        return "SASServiceContext Context (msgType = " + this.ctxMsgType + ", body = " + this.ctxBody + ", subject = " + this.subject + ")";
    }

    private static void log(String string) {
        IIOPLogger.logDebugSecurity((String)("<SASServiceContext>: " + string));
    }

    private AuthenticatedSubject getAssertAsSubject() {
        AuthenticatedSubject authenticatedSubject = null;
        authenticatedSubject = null != this.subject ? (this.subject.equals((Object)kernelId) ? SubjectUtils.getAnonymousSubject() : this.subject) : SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
        return authenticatedSubject;
    }
}

