/*
 * Decompiled with CFR 0.152.
 */
package weblogic.io.common.internal;

import java.io.IOException;

class CommandResponse {
    private boolean signaled = false;
    private boolean cancelled = false;
    private String error = "";
    private static final int CLIENT_TIMEOUT_MILLSECS = 120000;

    CommandResponse() {
    }

    public synchronized void waitAround() throws IOException {
        if (this.cancelled) {
            throw new IOException(this.error);
        }
        if (!this.signaled) {
            try {
                this.wait(120000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.signaled && !this.cancelled) {
            this.cancel("Timed out or interrupted waiting for command response");
        }
        if (this.cancelled) {
            throw new IOException(this.error);
        }
        this.signaled = false;
    }

    public synchronized void signal() {
        if (this.signaled) {
            throw new AssertionError((Object)"Signaled should be false!");
        }
        this.signaled = true;
        this.notify();
    }

    public synchronized void cancel(String string) {
        this.error = string;
        this.cancelled = true;
        this.notify();
    }
}

