/*
 * Decompiled with CFR 0.152.
 */
package weblogic.io.common.internal;

import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.common.T3MiscLogger;
import weblogic.io.common.internal.T3FileSystemProxyImpl;
import weblogic.jndi.Environment;
import weblogic.logging.LogOutputStream;
import weblogic.management.DeploymentException;
import weblogic.management.UndeploymentException;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.FileT3MBean;
import weblogic.management.internal.DeploymentHandler;
import weblogic.management.internal.DeploymentHandlerContext;
import weblogic.management.internal.DeploymentHandlerHome;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.utils.AssertionError;

public final class FileService
extends AbstractServerService
implements DeploymentHandler {
    private static FileService singleton = null;
    private Context context;
    private LogOutputStream log;

    public FileService() {
        if (singleton != null) {
            throw new AssertionError("File server module singleton already set");
        }
        singleton = this;
        this.log = new LogOutputStream("FileSystem");
    }

    public void start() throws ServiceFailureException {
        DeploymentHandlerHome.addDeploymentHandler(this);
        this.context = this.getContext();
    }

    protected boolean isFileSystemMounted(String string) {
        Context context = this.getContext();
        if (context == null) {
            return false;
        }
        try {
            context.lookup(string);
            return true;
        }
        catch (NamingException namingException) {
            return false;
        }
    }

    private void mountFileSystem(FileT3MBean fileT3MBean) {
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        String string = fileT3MBean.getName();
        String string2 = fileT3MBean.getPath();
        try {
            context.bind(string, (Object)new T3FileSystemProxyImpl(string, string2));
        }
        catch (NamingException namingException) {
            T3MiscLogger.logMount((String)fileT3MBean.getName(), (Exception)namingException);
        }
    }

    private void unmountFileSystem(FileT3MBean fileT3MBean) {
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        try {
            context.unbind(fileT3MBean.getName());
        }
        catch (NamingException namingException) {
            T3MiscLogger.logUnmount((String)fileT3MBean.getName(), (Exception)namingException);
        }
    }

    private Context getContext() {
        if (this.context == null) {
            try {
                Environment environment = new Environment();
                environment.setCreateIntermediateContexts(true);
                environment.setReplicateBindings(false);
                this.context = environment.getInitialContext().createSubcontext("weblogic.fileSystem");
                return this.context;
            }
            catch (NamingException namingException) {
                T3MiscLogger.logGetRoot((Exception)namingException);
            }
        }
        return this.context;
    }

    public void prepareDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws DeploymentException {
    }

    public void activateDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws DeploymentException {
        if (deploymentMBean instanceof FileT3MBean) {
            try {
                this.mountFileSystem((FileT3MBean)deploymentMBean);
            }
            catch (Exception exception) {
                throw new DeploymentException("error creating connection pool", exception);
            }
        }
    }

    public void deactivateDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) {
        if (deploymentMBean instanceof FileT3MBean) {
            this.unmountFileSystem((FileT3MBean)deploymentMBean);
        }
    }

    public void unprepareDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws UndeploymentException {
    }

    static FileService getFileService() {
        return singleton;
    }
}

