/*
 * Decompiled with CFR 0.152.
 */
package weblogic.io.common.internal;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import weblogic.common.T3Client;
import weblogic.common.T3Exception;
import weblogic.common.T3ServicesDef;
import weblogic.io.common.IOServicesDef;
import weblogic.io.common.T3File;
import weblogic.io.common.T3FileInputStream;
import weblogic.io.common.T3FileOutputStream;
import weblogic.io.common.T3FileSystem;
import weblogic.io.common.internal.T3FileSystemLocal;
import weblogic.io.common.internal.T3FileSystemProxy;
import weblogic.io.common.internal.T3FileSystemRemote;

public class IOServicesImpl
implements IOServicesDef {
    private T3Client t3;
    private T3ServicesDef svc;
    private Context ctxFile;
    private Vector fileSystemList = null;
    private Hashtable remoteFileSystemCache;
    public T3FileSystem localFileSystem;

    public IOServicesImpl(T3ServicesDef t3ServicesDef, T3Client t3Client) throws T3Exception {
        this.t3 = t3Client;
        this.svc = t3ServicesDef;
        this.localFileSystem = new T3FileSystemLocal();
        this.remoteFileSystemCache = new Hashtable();
        try {
            this.ctxFile = (Context)t3ServicesDef.name().getInitialContext().lookup("weblogic.fileSystem");
        }
        catch (Exception exception) {
            throw new T3Exception("Unable to JNDI-lookup file services on the server", (Throwable)exception);
        }
    }

    public T3FileSystem getFileSystem(String string) throws T3Exception {
        if (string == null || string.equals("")) {
            return this.localFileSystem;
        }
        T3FileSystem t3FileSystem = (T3FileSystem)this.remoteFileSystemCache.get(string);
        if (t3FileSystem == null) {
            T3FileSystemProxy t3FileSystemProxy;
            try {
                t3FileSystemProxy = (T3FileSystemProxy)this.ctxFile.lookup(string);
            }
            catch (NamingException namingException) {
                throw new T3Exception("Unknown file system " + string);
            }
            t3FileSystem = new T3FileSystemRemote(this.svc, t3FileSystemProxy);
            this.remoteFileSystemCache.put(string, t3FileSystem);
        }
        return t3FileSystem;
    }

    public Enumeration listFileSystems() throws T3Exception {
        if (this.fileSystemList == null) {
            NamingEnumeration<NameClassPair> namingEnumeration;
            try {
                namingEnumeration = this.ctxFile.list("");
            }
            catch (NamingException namingException) {
                throw new T3Exception("Unable to list file systems", (Throwable)namingException);
            }
            this.fileSystemList = new Vector();
            while (namingEnumeration.hasMoreElements()) {
                this.fileSystemList.addElement(((NameClassPair)namingEnumeration.nextElement()).getName());
            }
        }
        return this.fileSystemList.elements();
    }

    public T3File getFile(String string) throws T3Exception {
        String string2 = null;
        if (string != null && string.length() > 2) {
            char c = string.charAt(0);
            int n = string.indexOf(c, 2);
            if ((c == '/' || c == '\\') && string.charAt(1) == c && n != -1) {
                string2 = string.substring(2, n);
                string = string.substring(n + 1);
            }
        }
        return this.getFileSystem(string2).getFile(string);
    }

    public T3FileInputStream getFileInputStream(T3File t3File) throws T3Exception {
        return t3File.getFileInputStream();
    }

    public T3FileInputStream getFileInputStream(T3File t3File, int n, int n2) throws T3Exception {
        return t3File.getFileInputStream(n, n2);
    }

    public T3FileOutputStream getFileOutputStream(T3File t3File) throws T3Exception {
        return t3File.getFileOutputStream();
    }

    public T3FileOutputStream getFileOutputStream(T3File t3File, int n, int n2) throws T3Exception {
        return t3File.getFileOutputStream(n, n2);
    }

    public T3FileInputStream getFileInputStream(String string) throws T3Exception {
        return this.getFile(string).getFileInputStream();
    }

    public T3FileInputStream getFileInputStream(String string, int n, int n2) throws T3Exception {
        return this.getFile(string).getFileInputStream(n, n2);
    }

    public T3FileOutputStream getFileOutputStream(String string) throws T3Exception {
        return this.getFile(string).getFileOutputStream();
    }

    public T3FileOutputStream getFileOutputStream(String string, int n, int n2) throws T3Exception {
        return this.getFile(string).getFileOutputStream(n, n2);
    }
}

