/*
 * Decompiled with CFR 0.152.
 */
package weblogic.io.common.internal;

import java.io.IOException;

class SkipResponse {
    private Object result = null;
    private boolean cancelled = false;
    private String error = "";
    private static final int CLIENT_TIMEOUT_MILLSECS = 120000;

    SkipResponse() {
    }

    public synchronized Object waitAround() throws IOException {
        if (this.cancelled) {
            throw new IOException(this.error);
        }
        if (this.result == null) {
            try {
                this.wait(120000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.result == null && !this.cancelled) {
            this.cancel("Timed out or interrupted waiting for skip response");
        }
        if (this.cancelled) {
            throw new IOException(this.error);
        }
        Object object = this.result;
        this.result = null;
        return object;
    }

    public synchronized void signal(Object object) {
        if (this.result != null) {
            throw new AssertionError((Object)"Result should have been null!");
        }
        this.result = object;
        this.notify();
    }

    public synchronized void cancel(String string) {
        this.error = string;
        this.cancelled = true;
        this.notify();
    }
}

