/*
 * Decompiled with CFR 0.152.
 */
package weblogic.io.common.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import weblogic.common.T3Exception;
import weblogic.io.common.T3File;
import weblogic.io.common.T3FileInputStream;
import weblogic.io.common.T3FileOutputStream;
import weblogic.io.common.internal.T3FileInputStreamLocal;
import weblogic.io.common.internal.T3FileOutputStreamLocal;

public final class T3FileLocal
extends File
implements T3File {
    private static final long serialVersionUID = 5975049963833859248L;
    private static final boolean debug = false;
    private File javaFile;
    private String pathFromMP;

    public T3FileLocal(String string) {
        super(string);
        this.pathFromMP = string;
        try {
            this.javaFile = new File(this.getCanonicalPath());
        }
        catch (IOException iOException) {
            this.javaFile = new File(string);
        }
    }

    public T3FileLocal(String string, String string2) {
        super(string, string2);
        try {
            this.javaFile = new File(this.getCanonicalPath());
        }
        catch (IOException iOException) {
            this.javaFile = new File(string, string2);
        }
    }

    private File getTryFile() {
        File file = this.javaFile == null ? this : this.javaFile;
        return file;
    }

    public T3FileInputStream getFileInputStream() throws T3Exception {
        return new T3FileInputStreamLocal(this);
    }

    public T3FileInputStream getFileInputStream(int n, int n2) throws T3Exception {
        return new T3FileInputStreamLocal(this);
    }

    public T3FileOutputStream getFileOutputStream() throws T3Exception {
        return new T3FileOutputStreamLocal(this);
    }

    public T3FileOutputStream getFileOutputStream(int n, int n2) throws T3Exception {
        return new T3FileOutputStreamLocal(this);
    }

    public T3File extend(String string) {
        return new T3FileLocal(this.pathFromMP + File.separator + string);
    }

    public String getName() {
        return this.getTryFile().getName();
    }

    public String getPath() {
        return this.pathFromMP;
    }

    public String getAbsolutePath() {
        return this.getTryFile().getAbsolutePath();
    }

    public String getParent() {
        return super.getParent();
    }

    public boolean exists() {
        return this.getTryFile().exists();
    }

    public boolean canWrite() {
        return this.getTryFile().canWrite();
    }

    public boolean canRead() {
        return this.getTryFile().canRead();
    }

    public boolean isFile() {
        return this.getTryFile().isFile();
    }

    public boolean isDirectory() {
        return this.getTryFile().isDirectory();
    }

    public long lastModified() {
        return this.getTryFile().lastModified();
    }

    public long length() {
        return this.getTryFile().length();
    }

    public boolean mkdir() {
        return this.getTryFile().mkdir();
    }

    public boolean mkdirs() {
        return this.getTryFile().mkdirs();
    }

    public String[] list() {
        return this.getTryFile().list();
    }

    public String[] list(FilenameFilter filenameFilter) {
        return this.getTryFile().list(filenameFilter);
    }

    public boolean delete() {
        return this.getTryFile().delete();
    }

    public int hashCode() {
        return this.getTryFile().hashCode();
    }

    public String toString() {
        return this.getTryFile().toString();
    }

    public boolean renameTo(T3File t3File) {
        if (t3File instanceof T3FileLocal) {
            return this.getTryFile().renameTo(((T3FileLocal)t3File).javaFile);
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof T3FileLocal) {
            return this.getTryFile().equals(((T3FileLocal)object).javaFile);
        }
        return false;
    }
}

