/*
 * Decompiled with CFR 0.152.
 */
package weblogic.io.common.internal;

import java.security.AccessController;
import weblogic.common.T3Exception;
import weblogic.io.common.T3File;
import weblogic.io.common.T3FileInputStream;
import weblogic.io.common.T3FileOutputStream;
import weblogic.io.common.internal.FileService;
import weblogic.io.common.internal.T3FileLocal;
import weblogic.io.common.internal.T3FileSystemLocal;
import weblogic.management.configuration.FileT3MBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class T3FileSystemLocalMountPoint
extends T3FileSystemLocal {
    private String fileSystemName = null;
    private String mountPoint = null;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static String getFileSystemName(String string) {
        if (string != null && string.length() > 2) {
            char c = string.charAt(0);
            int n = string.indexOf(92, 2);
            int n2 = string.indexOf(47, 2);
            if ((c == '/' || c == '\\') && string.charAt(1) == c) {
                if (n != -1) {
                    return string.substring(2, n);
                }
                if (n2 != -1) {
                    return string.substring(2, n2);
                }
                return "";
            }
            return "";
        }
        return "";
    }

    public static String getFileName(String string) {
        if (string != null && string.length() > 2) {
            char c = string.charAt(0);
            int n = string.indexOf(92, 2);
            int n2 = string.indexOf(47, 2);
            if ((c == '/' || c == '\\') && string.charAt(1) == c) {
                if (n != -1) {
                    return string.substring(n + 1);
                }
                if (n2 != -1) {
                    return string.substring(n2 + 1);
                }
                return string;
            }
            return string;
        }
        return string;
    }

    public T3FileSystemLocalMountPoint(String string) throws T3Exception {
        FileT3MBean fileT3MBean = null;
        this.fileSystemName = string;
        fileT3MBean = ManagementService.getRuntimeAccess(kernelId).getDomain().lookupFileT3(this.fileSystemName);
        if (fileT3MBean == null) {
            throw new T3Exception("Unknown file system " + this.fileSystemName);
        }
        this.mountPoint = fileT3MBean.getPath() + this.separator();
        if (!FileService.getFileService().isFileSystemMounted(string)) {
            throw new T3Exception("Unknown file system " + this.fileSystemName);
        }
    }

    public T3File getFile(String string) {
        return new T3FileLocal(this.mountPoint + string);
    }

    public T3File getFile(String string, String string2) {
        return this.getFile(this.mountPoint + string + this.separator() + string2);
    }

    public String getName() {
        return this.fileSystemName;
    }

    public T3FileInputStream getFileInputStream(String string) throws T3Exception {
        string = this.stripLeadingSlash(string);
        return this.getFile(string).getFileInputStream();
    }

    public T3FileInputStream getFileInputStream(String string, int n, int n2) throws T3Exception {
        string = this.stripLeadingSlash(string);
        return this.getFile(string).getFileInputStream(n, n2);
    }

    public T3FileOutputStream getFileOutputStream(String string) throws T3Exception {
        string = this.stripLeadingSlash(string);
        return this.getFile(string).getFileOutputStream();
    }

    public T3FileOutputStream getFileOutputStream(String string, int n, int n2) throws T3Exception {
        string = this.stripLeadingSlash(string);
        return this.getFile(string).getFileOutputStream(n, n2);
    }

    private String stripLeadingSlash(String string) {
        if (string.startsWith(this.pathSeparator())) {
            return string.substring(1);
        }
        return string;
    }
}

